/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.LiteralSerializerWriterBase;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;

public class LiteralSequenceSerializerWriter
extends LiteralSerializerWriterBase
implements GeneratorConstants {
    protected String serializerName;
    protected String serializerMemberName;
    protected LiteralType dataType;

    public LiteralSequenceSerializerWriter(LiteralType type, Names names) {
        super(type, names);
        this.serializerName = names.typeObjectSerializerClassName(type);
        this.serializerMemberName = names.getClassMemberName(this.serializerName);
        this.dataType = type;
    }

    public void createSerializer(IndentingWriter p, StringBuffer typeName, String serName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        LiteralType type = (LiteralType)this.type;
        boolean isExtendable = ((LiteralStructuredType)type).getParentType() != null;
        String encodeType = encodeTypes && isExtendable ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        this.declareType(p, typeName, type.getName(), false, false);
        p.plnI(GeneratorConstants.BASE_SERIALIZER_NAME + " " + serName + " = new " + this.serializerName() + "(" + typeName + ", \"\", " + encodeType + ");");
        p.pO();
    }

    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln(modifier + GeneratorConstants.BASE_SERIALIZER_NAME + " " + this.serializerMemberName() + ";");
    }

    public String serializerName() {
        return this.serializerName;
    }

    public String serializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    public String deserializerName() {
        return this.serializerName;
    }

    public String deserializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }
}

