/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import java.io.IOException;
import javax.xml.namespace.QName;

public abstract class SerializerWriterBase
implements SerializerWriter,
GeneratorConstants {
    AbstractType type;
    Names names;
    SOAPVersion soapVer = SOAPVersion.SOAP_11;

    public SerializerWriterBase(AbstractType type, Names names) {
        if (type.isSOAPType()) {
            String ver = type.getVersion();
            if (ver.equals(SOAPVersion.SOAP_11.toString())) {
                this.soapVer = SOAPVersion.SOAP_11;
            } else if (ver.equals(SOAPVersion.SOAP_12.toString())) {
                this.soapVer = SOAPVersion.SOAP_12;
            }
        }
        this.type = type;
        this.names = names;
    }

    public void registerSerializer(IndentingWriter p, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        StringBuffer typeName = new StringBuffer(40);
        typeName.append("type");
        this.createSerializer(p, typeName, "serializer", encodeTypes, multiRefEncoding, typeMapping);
        this.writeRegisterFactories(p, typeName.toString(), "serializer", typeMapping);
    }

    public void initializeSerializer(IndentingWriter p, String typeName, String registry) throws IOException {
        String javaType = null;
        javaType = this.type.getName().equals(SchemaConstants.QNAME_TYPE_IDREF) ? ModelerConstants.STRING_CLASSNAME : this.type.getJavaType().getRealName();
        p.pln(this.serializerMemberName() + " = (CombinedSerializer)registry.getSerializer(" + this.getEncodingStyleString() + ", " + javaType + ".class, " + typeName + ");");
    }

    public String serializerName() {
        return GeneratorConstants.BASE_SERIALIZER_NAME;
    }

    public String deserializerName() {
        return this.serializerName();
    }

    public static boolean handlesType(AbstractType type) {
        return false;
    }

    protected String getEncodingStyleString() {
        if (this.soapVer.equals(SOAPVersion.SOAP_12)) {
            return "SOAP12Constants.NS_SOAP_ENCODING";
        }
        if (this.soapVer.equals(SOAPVersion.SOAP_11)) {
            return "SOAPConstants.NS_SOAP_ENCODING";
        }
        return null;
    }

    protected String getEncodingStyle() {
        if (this.soapVer.equals(SOAPVersion.SOAP_12)) {
            return "http://www.w3.org/2002/06/soap-encoding";
        }
        if (this.soapVer.equals(SOAPVersion.SOAP_11)) {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        return null;
    }

    protected String getSOAPVersionString() {
        if (this.soapVer.equals(SOAPVersion.SOAP_12)) {
            return "SOAPVersion.SOAP_12";
        }
        if (this.soapVer.equals(SOAPVersion.SOAP_11)) {
            return "SOAPVersion.SOAP_11";
        }
        return null;
    }

    protected void declareType(IndentingWriter p, StringBuffer member, QName type, boolean isStatic, boolean isFinal) throws IOException {
        String qnameConstant = GeneratorUtil.getQNameConstant(type);
        if (qnameConstant != null) {
            member.delete(0, member.length());
            member.append(qnameConstant);
        } else {
            String modifier = this.getModifier(isStatic, isFinal);
            p.p(modifier + "QName " + member + " = ");
            GeneratorUtil.writeNewQName(p, type);
            p.pln(";");
        }
    }

    protected void writeRegisterFactories(IndentingWriter p, String typeName, String memberName, String mapping) throws IOException {
        p.pln("registerSerializer(" + mapping + "," + this.type.getJavaType().getRealName() + ".class, " + typeName + ", " + memberName + ");");
    }

    protected String getModifier(boolean isStatic, boolean isFinal) {
        String modifier = "";
        if (isStatic) {
            modifier = modifier + "static ";
        }
        if (isFinal) {
            modifier = modifier + "final ";
        }
        return modifier;
    }

    protected String getPrefix(AbstractType type) {
        QName typeName = type.getName();
        String prefix = this.names.getPrefix(typeName);
        return prefix;
    }
}

