/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ExceptionModelerBase
implements RmiConstants {
    protected RmiModeler modeler;
    protected Class defRuntimeException;
    protected ProcessorEnvironment env;
    protected static final String THROWABLE_CLASSNAME = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionModelerBase.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName();
    protected static final String OBJECT_CLASSNAME = (class$java$lang$Object == null ? (class$java$lang$Object = ExceptionModelerBase.class$("java.lang.Object")) : class$java$lang$Object).getName();
    protected static final int MESSAGE_FLAG = 2;
    protected static final int LOCALIZED_MESSAGE_FLAG = 4;
    protected static Method GET_MESSAGE_METHOD;
    protected Map faultMap;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$RuntimeException;

    public ExceptionModelerBase(RmiModeler modeler) {
        this.modeler = modeler;
        this.env = modeler.getProcessorEnvironment();
        this.faultMap = new HashMap();
        try {
            this.defRuntimeException = RmiUtils.getClassForName((class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = ExceptionModelerBase.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).getName(), this.env.getClassLoader());
            GET_MESSAGE_METHOD = RmiUtils.getClassForName((class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionModelerBase.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName(), this.env.getClassLoader()).getDeclaredMethod("getMessage", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", (class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = ExceptionModelerBase.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).getName());
        }
        catch (NoSuchMethodException e) {
            throw new ModelerException("rmimodeler.no.such.method", new Object[]{"getMessage", (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionModelerBase.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName()});
        }
    }

    public Fault modelException(String typeUri, String wsdlUri, Class exceptionClass) {
        String className = exceptionClass.getName();
        this.env.getNames();
        if (Names.isInJavaOrJavaxPackage(className)) {
            throw new ModelerException("rmimodeler.java.exceptions.not.allowed", className);
        }
        return this.createFault(typeUri, wsdlUri, exceptionClass);
    }

    public abstract Fault createFault(String var1, String var2, Class var3);

    protected static Set getDuplicateMembers(Map members) {
        HashSet<RmiType> types = new HashSet<RmiType>();
        HashSet<Method> duplicateMembers = new HashSet<Method>();
        Iterator iter = members.entrySet().iterator();
        while (iter.hasNext()) {
            Method member = (Method)iter.next().getValue();
            RmiType type = RmiType.getRmiType(member.getReturnType());
            String memberName = member.getName();
            if (types.contains(type)) {
                duplicateMembers.add(member);
                continue;
            }
            types.add(type);
        }
        return duplicateMembers;
    }

    public void collectMembers(Class classDef, Map members) {
        try {
            if (this.defRuntimeException.isAssignableFrom(classDef)) {
                throw new ModelerException("rmimodeler.must.not.extend.runtimeexception", classDef.getName());
            }
            if (classDef.equals(class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionModelerBase.class$("java.lang.Throwable")) : class$java$lang$Throwable)) {
                members.put("getMessage", GET_MESSAGE_METHOD);
                return;
            }
            if (classDef.getSuperclass() != null) {
                this.collectMembers(classDef.getSuperclass(), members);
            }
            Method[] methods = classDef.getMethods();
            int i = 0;
            while (i < methods.length) {
                String memberName;
                Class<?> decClass = methods[i].getDeclaringClass();
                if (!(Modifier.isStatic(methods[i].getModifiers()) || decClass.equals(class$java$lang$Throwable == null ? ExceptionModelerBase.class$("java.lang.Throwable") : class$java$lang$Throwable) || decClass.equals(class$java$lang$Object == null ? ExceptionModelerBase.class$("java.lang.Object") : class$java$lang$Object) || !(memberName = methods[i].getName()).startsWith("get") && !memberName.startsWith("is") || methods[i].getParameterTypes().length != 0 || members.containsKey(memberName))) {
                    members.put(memberName, methods[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ModelerException(new LocalizableExceptionAdapter(e));
        }
    }

    private Fault getMappedFault(String className) {
        return (Fault)this.faultMap.get(className);
    }

    private void log(ProcessorEnvironment env, String msg) {
        if (env.verbose()) {
            StringBuffer stringBuffer = new StringBuffer().append("[");
            env.getNames();
            System.out.println(stringBuffer.append(Names.stripQualifier(this.getClass().getName())).append(": ").append(msg).append("]").toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            GET_MESSAGE_METHOD = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionModelerBase.class$("java.lang.Throwable")) : class$java$lang$Throwable).getDeclaredMethod("getMessage", new Class[0]);
        }
        catch (Exception e) {}
    }
}

