/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.modeler.rmi.ExceptionModelerBase;
import com.sun.xml.rpc.processor.modeler.rmi.LiteralTypeModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.modeler.rmi.RmiTypeModeler;
import com.sun.xml.rpc.processor.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class LiteralExceptionModeler
extends ExceptionModelerBase
implements RmiConstants {
    private LiteralTypeModeler literalTypeModeler;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Exception;

    public LiteralExceptionModeler(RmiModeler modeler, LiteralTypeModeler typeModeler) {
        super(modeler);
        this.literalTypeModeler = typeModeler;
    }

    public Fault createFault(String typeUri, String wsdlUri, Class classDef) {
        String exceptionName = classDef.getName();
        Fault fault = (Fault)this.faultMap.get(exceptionName);
        if (fault != null) {
            return fault;
        }
        HashMap<String, Method> members = new HashMap<String, Method>();
        this.collectMembers(classDef, members);
        int getMessageFlags = 0;
        if (members.containsKey("getMessage")) {
            Iterator iterator = members.entrySet().iterator();
            while (iterator.hasNext()) {
                Method member = (Method)iterator.next().getValue();
                if (!member.getReturnType().equals(class$java$lang$String == null ? LiteralExceptionModeler.class$("java.lang.String") : class$java$lang$String) || member.getName().equals("getMessage")) continue;
                members.remove("getMessage");
                break;
            }
        }
        if (members.size() == 0) {
            members.put("getMessage", ExceptionModelerBase.GET_MESSAGE_METHOD);
        }
        if (members.containsKey("getMessage")) {
            getMessageFlags = 2;
        }
        boolean hasDuplicates = false;
        Set duplicateMembers = ExceptionModelerBase.getDuplicateMembers(members);
        if (duplicateMembers.size() > 0) {
            hasDuplicates = true;
        }
        if (members.size() > 0 && !hasDuplicates) {
            LiteralElementMember[] literalMembers;
            Constructor<?>[] constrs = classDef.getConstructors();
            Constructor<?> defaultConstructor = null;
            int i = 0;
            while (i < constrs.length && fault == null) {
                if (constrs[i].getParameterTypes().length == 0) {
                    defaultConstructor = constrs[i];
                } else {
                    literalMembers = this.constructorMatches(typeUri, wsdlUri, classDef, constrs[i], members, getMessageFlags);
                    if (literalMembers != null) {
                        fault = this.createFault(typeUri, wsdlUri, classDef, literalMembers);
                    }
                }
                ++i;
            }
            if (fault == null && defaultConstructor != null && (literalMembers = this.constructorMatches(typeUri, wsdlUri, classDef, defaultConstructor, members, getMessageFlags)) != null) {
                fault = this.createFault(typeUri, wsdlUri, classDef, literalMembers);
            }
        }
        if (fault == null) {
            ArrayList<String> newMembers = new ArrayList<String>();
            if (!members.containsKey("getMessage")) {
                newMembers.add("getMessage");
            }
            fault = this.createFault(typeUri, wsdlUri, classDef, this.addMessage(typeUri, wsdlUri, classDef, members, newMembers));
        }
        this.faultMap.put(classDef.getName().toString(), fault);
        return fault;
    }

    private LiteralElementMember[] constructorMatches(String typeUri, String wsdlUri, Class classDef, Constructor cstr, Map members, int getMessageFlags) {
        Object[] memberArray;
        boolean memberCountMatch;
        Class<?>[] args = cstr.getParameterTypes();
        boolean bl = memberCountMatch = args.length == (memberArray = members.values().toArray()).length;
        if (!(memberCountMatch || getMessageFlags != 0 && args.length == memberArray.length - 1)) {
            return null;
        }
        LiteralElementMember[] literalMembers = new LiteralElementMember[args.length];
        int i = 0;
        while (i < args.length) {
            int j = 0;
            while (j < memberArray.length && literalMembers[i] == null) {
                block9: {
                    block8: {
                        if (memberCountMatch) break block8;
                        String memberName = ((Method)memberArray[j]).getName();
                        if (getMessageFlags == 2 && memberName.equals("getMessage")) break block9;
                    }
                    if (args[i].equals(((Method)memberArray[j]).getReturnType())) {
                        literalMembers[i] = this.createLiteralMember(typeUri, wsdlUri, classDef, (Method)memberArray[j], i);
                    }
                }
                ++j;
            }
            if (literalMembers[i] == null) {
                return null;
            }
            ++i;
        }
        return literalMembers;
    }

    public LiteralElementMember createLiteralMember(String typeUri, String wsdlUri, Class classDef, Method member, int cstrPos) {
        String packageName = classDef.getPackage().getName();
        RmiType memberType = RmiType.getRmiType(member.getReturnType());
        String readMethod = member.getName();
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = wsdlUri;
        }
        String propertyName = readMethod.startsWith("get") ? StringUtils.decapitalize(readMethod.substring(3)) : StringUtils.decapitalize(readMethod.substring(2));
        QName propertyQName = new QName("", propertyName);
        LiteralElementMember literalMember = this.literalTypeModeler.modelTypeLiteral(propertyQName, typeUri, memberType);
        JavaStructureMember javaMember = literalMember.getJavaStructureMember();
        javaMember.setConstructorPos(cstrPos);
        javaMember.setReadMethod(readMethod);
        return literalMember;
    }

    public LiteralElementMember[] addMessage(String typeUri, String wsdlUri, Class classDef, Map members, List newMembers) {
        String packageName = classDef.getPackage().getName();
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = wsdlUri;
        }
        LiteralElementMember[] literalMembers = new LiteralElementMember[members.size() + newMembers.size()];
        Iterator iter = members.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Method argMember = (Method)iter.next().getValue();
            literalMembers[i] = this.createLiteralMember(typeUri, wsdlUri, classDef, argMember, -1);
            ++i;
        }
        iter = newMembers.iterator();
        int i2 = members.size();
        while (iter.hasNext()) {
            String tmp = (String)((Object)iter.next());
            String propertyName = tmp.startsWith("get") ? StringUtils.decapitalize(tmp.substring(3)) : StringUtils.decapitalize(tmp.substring(2));
            QName propertyQName = new QName("", propertyName);
            LiteralSimpleType propertyType = this.literalTypeModeler.getLiteralTypes().XSD_STRING_LITERALTYPE;
            LiteralElementMember literalMember = new LiteralElementMember(propertyQName, propertyType, null);
            JavaStructureMember javaMember = new JavaStructureMember(propertyName, propertyType.getJavaType(), literalMember);
            literalMember.setJavaStructureMember(javaMember);
            javaMember.setReadMethod(tmp);
            literalMember.setJavaStructureMember(javaMember);
            literalMembers[i2] = literalMember;
            ++i2;
        }
        return literalMembers;
    }

    public Fault createFault(String typeUri, String wsdlUri, Class classDef, LiteralElementMember[] literalMembers) {
        String packageName = classDef.getPackage().getName();
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = typeUri;
        }
        Set sortedMembers = LiteralExceptionModeler.sortMembers(classDef, literalMembers);
        this.env.getNames();
        Fault fault = new Fault(Names.stripQualifier(classDef.getName()));
        LiteralSequenceType literalStruct = new LiteralSequenceType(new QName(namespaceURI, fault.getName()));
        namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = wsdlUri;
        }
        QName faultQName = new QName(namespaceURI, fault.getName());
        JavaException javaException = new JavaException(classDef.getName(), true, literalStruct);
        Iterator iter = sortedMembers.iterator();
        while (iter.hasNext()) {
            LiteralElementMember member = (LiteralElementMember)iter.next();
            literalStruct.add(member);
            javaException.add(member.getJavaStructureMember());
        }
        Block faultBlock = new Block(faultQName, literalStruct);
        fault.setBlock(faultBlock);
        literalStruct.setJavaType(javaException);
        fault.setJavaException(javaException);
        return fault;
    }

    public static Set sortMembers(Class classDef, LiteralElementMember[] unsortedMembers) {
        TreeSet<LiteralElementMember> sortedMembers = new TreeSet<LiteralElementMember>(new LiteralElementMemberComparator(classDef));
        int i = 0;
        while (i < unsortedMembers.length) {
            sortedMembers.add(unsortedMembers[i]);
            ++i;
        }
        return sortedMembers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LiteralElementMemberComparator
    implements Comparator {
        Class classDef;

        public LiteralElementMemberComparator(Class classDef) {
            this.classDef = classDef;
        }

        public int compare(Object o1, Object o2) {
            LiteralElementMember mem1 = (LiteralElementMember)o1;
            LiteralElementMember mem2 = (LiteralElementMember)o2;
            return this.sort(mem1, mem2);
        }

        protected int sort(LiteralElementMember mem1, LiteralElementMember mem2) {
            Class class2;
            String key1 = mem1.getJavaStructureMember().getName();
            String key2 = mem2.getJavaStructureMember().getName();
            Class class1 = this.getDeclaringClass(this.classDef, mem1);
            if (class1.equals(class2 = this.getDeclaringClass(this.classDef, mem2))) {
                return key1.compareTo(key2);
            }
            if (class1.equals(class$java$lang$Throwable == null ? (class$java$lang$Throwable = LiteralExceptionModeler.class$("java.lang.Throwable")) : class$java$lang$Throwable) || class1.equals(class$java$lang$Exception == null ? (class$java$lang$Exception = LiteralExceptionModeler.class$("java.lang.Exception")) : class$java$lang$Exception)) {
                return 1;
            }
            if (class1.isAssignableFrom(class2)) {
                return -1;
            }
            return 1;
        }

        protected Class getDeclaringClass(Class testClass, LiteralElementMember member) {
            String readMethod = member.getJavaStructureMember().getReadMethod();
            Class retClass = RmiTypeModeler.getDeclaringClassMethod(testClass, readMethod, new Class[0]);
            return retClass;
        }
    }
}

