/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class RmiStructure
implements RmiConstants {
    private ProcessorEnvironment env;
    private Class implClassDef;
    private HashMap members;
    private Class defRemote;
    static /* synthetic */ Class class$java$lang$RuntimeException;

    private static RmiStructure forClass(ProcessorEnvironment env, Class implClassDef) {
        RmiStructure sc = new RmiStructure(env, implClassDef);
        sc.initialize();
        return sc;
    }

    public static Map modelTypeSOAP(ProcessorEnvironment env, RmiType type) {
        Class cDec = null;
        RmiStructure rt = null;
        try {
            cDec = type.getTypeClass(env.getClassLoader());
            rt = RmiStructure.forClass(env, cDec);
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", type.toString());
        }
        if (rt == null) {
            return null;
        }
        return rt.getMembers();
    }

    private HashMap getMembers() {
        return (HashMap)this.members.clone();
    }

    private RmiStructure(ProcessorEnvironment env, Class implClassDef) {
        this.env = env;
        this.implClassDef = implClassDef;
    }

    private void initialize() {
        try {
            this.defRemote = RmiUtils.getClassForName(RmiConstants.REMOTE_CLASSNAME, this.env.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", (class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = RmiStructure.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).getName());
        }
        if (!this.implClassDef.isInterface() && !Modifier.isAbstract(this.implClassDef.getModifiers())) {
            boolean hasDefaultConstructor = false;
            try {
                hasDefaultConstructor = this.implClassDef.getConstructor(new Class[0]) != null;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (!hasDefaultConstructor) {
                throw new ModelerException("rmimodeler.no.empty.constructor", this.implClassDef.getName().toString());
            }
        }
        this.members = new HashMap();
        Vector<Class> interfacesImplemented = new Vector<Class>();
        interfacesImplemented.addElement(this.implClassDef);
        if (this.defRemote.isAssignableFrom(this.implClassDef)) {
            RmiStructure.log(this.env, "remote interface implemented by: " + this.implClassDef.getName());
            throw new ModelerException("rmimodeler.type.cannot.implement.remote", this.implClassDef.getName());
        }
        if (!this.collectMembers(this.implClassDef, this.members)) {
            this.members = new HashMap();
        }
    }

    public boolean collectMembers(Class interfaceDef, HashMap map) {
        Field[] fields = interfaceDef.getFields();
        int i = 0;
        while (fields != null && i < fields.length) {
            int modifier = fields[i].getModifiers();
            if (!(!Modifier.isPublic(modifier) || Modifier.isFinal(modifier) && Modifier.isStatic(modifier) || Modifier.isTransient(modifier) || map.get(fields[i].getName()) != null)) {
                MemberInfo memInfo = new MemberInfo(fields[i].getName(), RmiType.getRmiType(fields[i].getType()), true);
                if (fields[i].getDeclaringClass().equals(interfaceDef)) {
                    memInfo.setDeclaringClass(fields[i].getDeclaringClass());
                }
                map.put(fields[i].getName(), memInfo);
            }
            ++i;
        }
        return true;
    }

    private static void log(ProcessorEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[RmiStructure: " + msg + "]");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

