/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.rpc.server.Tie;
import com.sun.xml.rpc.server.http.Implementor;
import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.RuntimeEndpointInfo;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImplementorCache {
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private Map cachedImplementors = new HashMap();
    private static final Log logger = LogFactory.getLog((String)"javax.enterprise.resource.webservices.rpc.server.http");

    public ImplementorCache(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
        this.cachedImplementors = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Implementor getImplementorFor(RuntimeEndpointInfo targetEndpoint) {
        ImplementorCache implementorCache = this;
        synchronized (implementorCache) {
            Implementor implementor = (Implementor)this.cachedImplementors.get(targetEndpoint);
            if (implementor != null) {
                return implementor;
            }
        }
        try {
            Tie tie;
            if (this.servletConfig != null) {
                tie = (Tie)targetEndpoint.getTieClass().newInstance();
                Remote servant = (Remote)targetEndpoint.getImplementationClass().newInstance();
                tie.setTarget(servant);
                Implementor implementor = new Implementor(this.servletContext, tie);
                implementor.init();
                this.postImplementorInit(implementor, targetEndpoint);
                Implementor existingImplementor = null;
                ImplementorCache implementorCache2 = this;
                synchronized (implementorCache2) {
                    existingImplementor = (Implementor)this.cachedImplementors.get(targetEndpoint);
                    if (existingImplementor == null) {
                        this.cachedImplementors.put(targetEndpoint, implementor);
                    }
                }
                if (existingImplementor == null) {
                    return implementor;
                }
                this.preImplementorDestroy(implementor);
                implementor.destroy();
                return existingImplementor;
            }
            tie = (Tie)targetEndpoint.getTieClass().newInstance();
            Remote servant = (Remote)targetEndpoint.getImplementationClass().newInstance();
            tie.setTarget(servant);
            Implementor implementor = new Implementor(null, tie);
            this.cachedImplementors.put(targetEndpoint, implementor);
            return implementor;
        }
        catch (IllegalAccessException e) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", targetEndpoint.getName());
        }
        catch (InstantiationException e) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", targetEndpoint.getName());
        }
        catch (ServiceException e) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", targetEndpoint.getName());
        }
        catch (JAXRPCServletException e) {
            throw e;
        }
        catch (JAXRPCException e) {
            throw new JAXRPCServletException("error.implementorFactory.servantInitFailed", targetEndpoint.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseImplementor(RuntimeEndpointInfo targetEndpoint, Implementor implementor) {
        boolean mustDestroy = false;
        ImplementorCache implementorCache = this;
        synchronized (implementorCache) {
            Implementor cachedImplementor = (Implementor)this.cachedImplementors.get(targetEndpoint);
            if (cachedImplementor != implementor) {
                mustDestroy = true;
            }
        }
        if (mustDestroy) {
            this.preImplementorDestroy(implementor);
            implementor.destroy();
        }
    }

    public void destroy() {
        if (this.servletConfig != null) {
            Iterator iter = this.cachedImplementors.values().iterator();
            while (iter.hasNext()) {
                Implementor implementor = (Implementor)iter.next();
                this.preImplementorDestroy(implementor);
                implementor.destroy();
            }
        }
        try {
            this.cachedImplementors.clear();
        }
        catch (UnsupportedOperationException e) {}
    }

    protected void postImplementorInit(Implementor implementor, RuntimeEndpointInfo targetEndpoint) {
    }

    protected void preImplementorDestroy(Implementor implementor) {
    }
}

