/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http.ea;

import com.sun.xml.rpc.server.http.Implementor;
import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.ea.ImplementorInfo;
import com.sun.xml.rpc.server.http.ea.ImplementorRegistry;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;

public class ImplementorFactory {
    protected ServletConfig _servletConfig;
    protected ImplementorRegistry _registry = new ImplementorRegistry();
    protected Map _cachedImplementors = new HashMap();

    public ImplementorFactory(ServletConfig servletConfig) {
        this._servletConfig = servletConfig;
    }

    public ImplementorFactory(ServletConfig servletConfig, String configFilePath) {
        if (configFilePath == null) {
            throw new JAXRPCServletException("error.implementorFactory.noConfiguration");
        }
        this._registry.readFrom(configFilePath);
        this._servletConfig = servletConfig;
    }

    public ImplementorFactory(ServletConfig servletConfig, InputStream configInputStream) {
        if (configInputStream == null) {
            throw new IllegalArgumentException("error.implementorFactory.noInputStream");
        }
        this._registry.readFrom(configInputStream);
        this._servletConfig = servletConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Implementor getImplementorFor(String name) {
        ImplementorFactory implementorFactory = this;
        synchronized (implementorFactory) {
            Implementor implementor = (Implementor)this._cachedImplementors.get(name);
            if (implementor != null) {
                return implementor;
            }
        }
        try {
            ImplementorInfo info = this._registry.getImplementorInfo(name);
            if (this._servletConfig != null) {
                Implementor implementor = info.createImplementor(this._servletConfig.getServletContext());
                implementor.init();
                Implementor existingImplementor = null;
                ImplementorFactory implementorFactory2 = this;
                synchronized (implementorFactory2) {
                    existingImplementor = (Implementor)this._cachedImplementors.get(name);
                    if (existingImplementor == null) {
                        this._cachedImplementors.put(name, implementor);
                    }
                }
                if (existingImplementor == null) {
                    return implementor;
                }
                implementor.destroy();
                return existingImplementor;
            }
            Implementor implementor = info.createImplementor(null);
            this._cachedImplementors.put(name, implementor);
            return implementor;
        }
        catch (IllegalAccessException e) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", name);
        }
        catch (InstantiationException e) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", name);
        }
        catch (ServiceException e) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", name);
        }
        catch (JAXRPCServletException e) {
            throw e;
        }
        catch (JAXRPCException e) {
            throw new JAXRPCServletException("error.implementorFactory.servantInitFailed", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseImplementor(String name, Implementor implementor) {
        boolean mustDestroy = false;
        ImplementorFactory implementorFactory = this;
        synchronized (implementorFactory) {
            Implementor cachedImplementor = (Implementor)this._cachedImplementors.get(name);
            if (cachedImplementor != implementor) {
                mustDestroy = true;
            }
        }
        if (mustDestroy) {
            implementor.destroy();
        }
    }

    public Iterator names() {
        return this._registry.names();
    }

    public void destroy() {
        if (this._servletConfig != null) {
            Iterator iter = this._cachedImplementors.values().iterator();
            while (iter.hasNext()) {
                Implementor implementor = (Implementor)iter.next();
                implementor.destroy();
            }
        }
        try {
            this._cachedImplementors.clear();
        }
        catch (UnsupportedOperationException e) {}
    }
}

