/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.soap.message;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.util.NullIterator;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class SOAPMessageContext
implements javax.xml.rpc.handler.soap.SOAPMessageContext {
    int currentHandler = -1;
    private SOAPMessage _message;
    private boolean _failure;
    private Map _properties;
    private String[] roles;
    private static MessageFactory _messageFactory;
    private static final String DEFAULT_SERVER_ERROR_ENVELOPE = "<?xml version='1.0' encoding='UTF-8'?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><env:Fault><faultcode>env:Server</faultcode><faultstring>Internal server error</faultstring></env:Fault></env:Body></env:Envelope>";

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public SOAPMessage getMessage() {
        return this._message;
    }

    public void setMessage(SOAPMessage message) {
        this._message = message;
    }

    public boolean isFailure() {
        return this._failure;
    }

    public void setFailure(boolean b) {
        this._failure = b;
    }

    public void setCurrentHandler(int i) {
        this.currentHandler = i;
    }

    public int getCurrentHandler() {
        return this.currentHandler;
    }

    public Object getProperty(String name) {
        if (this._properties == null) {
            return null;
        }
        return this._properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put(name, value);
    }

    public void removeProperty(String name) {
        if (this._properties != null) {
            this._properties.remove(name);
        }
    }

    public boolean containsProperty(String name) {
        if (this._properties == null) {
            return false;
        }
        return this._properties.containsKey(name);
    }

    public Iterator getPropertyNames() {
        if (this._properties == null) {
            return NullIterator.getInstance();
        }
        return this._properties.keySet().iterator();
    }

    public SOAPMessage createMessage() {
        try {
            return _messageFactory.createMessage();
        }
        catch (SOAPException e) {
            return null;
        }
    }

    public SOAPMessage createMessage(MimeHeaders headers, InputStream in) throws IOException {
        try {
            return _messageFactory.createMessage(headers, in);
        }
        catch (SOAPException e) {
            return null;
        }
    }

    public void writeInternalServerErrorResponse() {
        try {
            this.setFailure(true);
            SOAPMessage message = this.createMessage();
            message.getSOAPPart().setContent((Source)new StreamSource((InputStream)XmlUtil.getUTF8ByteInputStream(DEFAULT_SERVER_ERROR_ENVELOPE)));
            this.setMessage(message);
        }
        catch (SOAPException e) {}
    }

    public void writeSimpleErrorResponse(QName faultCode, String faultString) {
        try {
            this.setFailure(true);
            SOAPMessage message = this.createMessage();
            ByteArrayOutputStream bufferedStream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedStream, "UTF-8");
            writer.write("<?xml version='1.0' encoding='UTF-8'?>\n<env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><env:Fault><faultcode>env:");
            writer.write(faultCode.getLocalPart());
            writer.write("</faultcode><faultstring>");
            writer.write(faultString);
            writer.write("</faultstring></env:Fault></env:Body></env:Envelope>");
            ((Writer)writer).close();
            byte[] data = bufferedStream.toByteArray();
            message.getSOAPPart().setContent((Source)new StreamSource((InputStream)new ByteInputStream(data, data.length)));
            this.setMessage(message);
        }
        catch (Exception e) {
            this.writeInternalServerErrorResponse();
        }
    }

    static {
        try {
            _messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {}
    }
}

