/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.ant;

import com.sun.xml.rpc.tools.wscompile.CompileTool;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Wscompile
extends MatchingTask {
    protected Path compileClasspath = null;
    private File baseDir = null;
    protected boolean define = false;
    private String features = null;
    private boolean debug = false;
    protected boolean client = false;
    protected boolean server = false;
    protected boolean both = false;
    private String HTTPProxyURL = null;
    private URL proxyURL = null;
    protected boolean genImport = false;
    private boolean keep = false;
    private File modelFile = null;
    private File nonClassDir = null;
    private boolean optimize = false;
    private File sourceBase;
    protected boolean verbose = false;
    protected boolean version = false;
    protected boolean xPrintStackTrace = false;
    private File xDebugModel = null;
    private File config = null;
    private boolean includeAntRuntime = false;
    private boolean includeJavaRuntime = false;

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getCP() {
        return this.getClasspath();
    }

    public void setCP(Path classpath) {
        this.setClasspath(classpath);
    }

    public File getBase() {
        return this.baseDir;
    }

    public void setBase(File base) {
        this.baseDir = base;
    }

    public boolean getDefine() {
        return this.define;
    }

    public void setDefine(boolean define) {
        this.define = define;
    }

    public String getF() {
        return this.getFeatures();
    }

    public void setF(String features) {
        this.setFeatures(features);
    }

    public String getFeatures() {
        return this.features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getGen() {
        return this.getClient();
    }

    public void setGen(boolean client) {
        this.setClient(client);
    }

    public boolean getClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public boolean getServer() {
        return this.server;
    }

    public void setServer(boolean server) {
        this.server = server;
    }

    public boolean getBoth() {
        return this.both;
    }

    public void setBoth(boolean both) {
        this.both = both;
    }

    public String getHTTPProxy() {
        return this.HTTPProxyURL;
    }

    public void setHTTPProxy(String HTTPProxy) {
        if (HTTPProxy != null && !HTTPProxy.equals("")) {
            this.HTTPProxyURL = HTTPProxy.startsWith("http://") ? HTTPProxy : "http://" + HTTPProxy;
            try {
                URL proxyServer = new URL(this.HTTPProxyURL);
                this.setProxyServer(proxyServer);
            }
            catch (MalformedURLException e) {
                throw new Error("Invalid HTTP URL specified: " + this.HTTPProxyURL);
            }
        }
    }

    public URL getProxyServer() {
        return this.proxyURL;
    }

    public void setProxyServer(URL proxyURL) {
        this.proxyURL = proxyURL;
    }

    public boolean getImport() {
        return this.genImport;
    }

    public void setImport(boolean genImport) {
        this.genImport = genImport;
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public File getModel() {
        return this.modelFile;
    }

    public void setModel(File modelFile) {
        this.modelFile = modelFile;
    }

    public File getNonClassDir() {
        return this.nonClassDir;
    }

    public void setNonClassDir(File nonClassDir) {
        this.nonClassDir = nonClassDir;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void setSourceBase(File sourceBase) {
        this.keep = true;
        this.sourceBase = sourceBase;
    }

    public File getSourceBase() {
        return this.sourceBase;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public boolean getXPrintStackTrace() {
        return this.xPrintStackTrace;
    }

    public void setXPrintStackTrace(boolean xPrintStackTrace) {
        this.xPrintStackTrace = xPrintStackTrace;
    }

    public File getXDebugModel() {
        return this.xDebugModel;
    }

    public void setXDebugModel(File xDebugModel) {
        this.xDebugModel = xDebugModel;
    }

    public File getConfig() {
        return this.config;
    }

    public void setConfig(File config) {
        this.config = config;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    private Path generateCompileClasspath() {
        Path classpath = new Path(this.getProject());
        if (this.getClasspath() == null) {
            if (this.getIncludeantruntime()) {
                classpath.addExisting(Path.systemClasspath);
            }
        } else if (this.getIncludeantruntime()) {
            classpath.addExisting(this.getClasspath().concatSystemClasspath("last"));
        } else {
            classpath.addExisting(this.getClasspath().concatSystemClasspath("ignore"));
        }
        if (this.getIncludejavaruntime()) {
            classpath.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
            classpath.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
        }
        return classpath;
    }

    private Commandline setupWscompileCommand(String[] options) {
        String host;
        Path classpath;
        Commandline cmd = new Commandline();
        if (options != null) {
            int i = 0;
            while (i < options.length) {
                cmd.createArgument().setValue(options[i]);
                ++i;
            }
        }
        if ((classpath = this.getClasspath()) != null && !classpath.toString().equals("")) {
            cmd.createArgument().setValue("-classpath");
            cmd.createArgument().setPath(classpath);
        }
        if (null != this.getBase() && !this.getBase().equals("")) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.getBase());
        }
        if (this.getDefine()) {
            cmd.createArgument().setValue("-define");
        }
        if (this.getFeatures() != null && !this.getFeatures().equals("")) {
            cmd.createArgument().setValue("-features:" + this.getFeatures());
        }
        if (this.getDebug()) {
            cmd.createArgument().setValue("-g");
        }
        if (this.getBoth()) {
            cmd.createArgument().setValue("-gen:both");
        } else if (this.getClient()) {
            cmd.createArgument().setValue("-gen:client");
        } else if (this.getServer()) {
            cmd.createArgument().setValue("-gen:server");
        }
        if (this.getProxyServer() != null && (host = this.getProxyServer().getHost()) != null && !host.equals("")) {
            String proxyVal = "-httpproxy:" + host;
            if (this.getProxyServer().getPort() != -1) {
                proxyVal = proxyVal + ":" + this.getProxyServer().getPort();
            }
            cmd.createArgument().setValue(proxyVal);
        }
        if (this.getImport()) {
            cmd.createArgument().setValue("-import");
        }
        if (this.getKeep()) {
            cmd.createArgument().setValue("-keep");
        }
        if (this.getModel() != null && !this.getModel().equals("")) {
            cmd.createArgument().setValue("-model");
            cmd.createArgument().setFile(this.getModel());
        }
        if (null != this.getNonClassDir() && !this.getNonClassDir().equals("")) {
            cmd.createArgument().setValue("-nd");
            cmd.createArgument().setFile(this.getNonClassDir());
        }
        if (this.getOptimize()) {
            cmd.createArgument().setValue("-O");
        }
        if (null != this.getSourceBase() && !this.getSourceBase().equals("")) {
            cmd.createArgument().setValue("-s");
            cmd.createArgument().setFile(this.getSourceBase());
        }
        if (this.getVerbose()) {
            cmd.createArgument().setValue("-verbose");
        }
        if (this.getVersion()) {
            cmd.createArgument().setValue("-version");
        }
        if (this.getXPrintStackTrace()) {
            cmd.createArgument().setValue("-Xprintstacktrace");
        }
        if (this.getXDebugModel() != null && !this.getXDebugModel().equals("")) {
            cmd.createArgument().setValue("-Xdebugmodel:" + this.getXDebugModel());
        }
        if (this.getConfig() != null) {
            cmd.createArgument().setValue(this.getConfig().toString());
        }
        return cmd;
    }

    private Commandline setupWscompileCommand() {
        return this.setupWscompileCommand(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (!this.getVersion()) {
            if (this.getConfig() == null) throw new BuildException("wscompile config file does not exist!", this.location);
            if (!this.getConfig().exists()) {
                throw new BuildException("wscompile config file does not exist!", this.location);
            }
        }
        Commandline cmd = this.setupWscompileCommand();
        if (this.verbose) {
            this.log("command line: wscompile " + cmd.toString());
        }
        LogOutputStream logstr = new LogOutputStream((Task)this, 1);
        try {
            try {
                CompileTool compTool = new CompileTool((OutputStream)logstr, "wscompile");
                boolean ok = compTool.run(cmd.getArguments());
                if (!ok) {
                    if (this.verbose) throw new BuildException("wscompile failed", this.location);
                    this.log("Command invoked: wscompile " + cmd.toString());
                    throw new BuildException("wscompile failed", this.location);
                }
                Object var6_6 = null;
            }
            catch (Exception ex) {
                if (!(ex instanceof BuildException)) throw new BuildException("Error starting wscompile: ", (Throwable)ex, this.getLocation());
                throw (BuildException)ex;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                logstr.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        logstr.close();
    }
}

