/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wsdeploy;

import com.sun.xml.rpc.processor.Processor;
import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ModelFileModelInfo;
import com.sun.xml.rpc.processor.config.RmiInterfaceInfo;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.XMLModelWriter;
import com.sun.xml.rpc.tools.wscompile.CompileTool;
import com.sun.xml.rpc.tools.wsdeploy.EndpointInfo;
import com.sun.xml.rpc.tools.wsdeploy.WebServicesInfo;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class EndpointCompileTool
extends CompileTool {
    protected EndpointInfo endpointInfo;
    protected WebServicesInfo webServicesInfo;
    protected File targetDirectory;
    protected boolean useModel;
    protected String additionalClasspath;
    protected Hashtable hashtable;
    protected ArrayList vector;
    protected boolean localUseWSIBasicProfile = false;
    private static final String PS = System.getProperty("path.separator");
    private static final char PSCHAR = System.getProperty("path.separator").charAt(0);
    private static final String FS = System.getProperty("file.separator");
    private static final char FSCHAR = System.getProperty("file.separator").charAt(0);

    public EndpointCompileTool(OutputStream out, String program, WebServicesInfo wsi, ArrayList list, File dir, String classpath, ProcessorNotificationListener l) {
        super(out, program);
        this.webServicesInfo = wsi;
        this.targetDirectory = dir;
        this.additionalClasspath = classpath;
        this.listener = l;
        this.vector = list;
        this.endpointInfo = (EndpointInfo)this.vector.get(0);
        this.useModel = this.endpointInfo.getModel() != null;
    }

    public EndpointCompileTool(OutputStream out, String program, EndpointInfo ei, WebServicesInfo wsi, File dir, String classpath, ProcessorNotificationListener l) {
        super(out, program);
        this.endpointInfo = ei;
        this.webServicesInfo = wsi;
        this.targetDirectory = dir;
        this.additionalClasspath = classpath;
        this.listener = l;
        this.useModel = this.endpointInfo.getModel() != null;
    }

    protected void beforeHook() {
        String targetPath = this.targetDirectory.getAbsolutePath();
        this.nonclassDestDir = new File(targetPath + FS + "WEB-INF");
        this.userClasspath = targetPath + FS + "WEB-INF" + FS + "classes";
        this.destDir = new File(this.userClasspath);
        if (new File(targetPath + FS + "WEB-INF" + FS + "lib").exists()) {
            File[] fs = new File(targetPath + FS + "WEB-INF" + FS + "lib").listFiles();
            int counter = 0;
            while (counter < fs.length) {
                this.userClasspath = this.userClasspath + PS + fs[counter];
                ++counter;
            }
        }
        if (this.additionalClasspath != null && this.additionalClasspath.length() > 0) {
            this.userClasspath = this.userClasspath + PS + this.additionalClasspath;
        }
        if (!this.useModel) {
            this.modelFile = new File(this.makeModelFileName());
        }
        this.serializerInfix = "_" + this.endpointInfo.getName() + "_";
        this.keepGenerated = true;
        this.compilerDebug = false;
        this.compilerOptimize = true;
        super.beforeHook();
    }

    protected void withModelHook() {
        Iterator services;
        EndpointInfo ei = null;
        if ((this.endpointInfo.getClientHandlerChainInfo() != null || this.endpointInfo.getServerHandlerChainInfo() != null) && (services = this.processor.getModel().getServices()).hasNext()) {
            Service service = (Service)services.next();
            this.endpointInfo.setRuntimeServiceName(service.getName());
            Iterator ports = service.getPorts();
            Port port = null;
            Object qName = null;
            while (ports.hasNext()) {
                port = (Port)ports.next();
                if (this.endpointInfo.getModel() == null) {
                    if (!port.getJavaInterface().getName().equals(this.endpointInfo.getInterface())) continue;
                    port.setClientHandlerChainInfo(this.endpointInfo.getClientHandlerChainInfo());
                    port.setServerHandlerChainInfo(this.endpointInfo.getServerHandlerChainInfo());
                    continue;
                }
                int counter = 0;
                while (counter < this.vector.size()) {
                    ei = (EndpointInfo)this.vector.get(counter);
                    if (port.getJavaInterface().getName().equals(ei.getInterface())) {
                        ei.setRuntimeServiceName(service.getName());
                        port.setClientHandlerChainInfo(ei.getClientHandlerChainInfo());
                        port.setServerHandlerChainInfo(ei.getServerHandlerChainInfo());
                        counter = this.vector.size();
                    }
                    ++counter;
                }
            }
        }
    }

    protected void afterHook() {
        boolean isCommonInterface = false;
        HashSet<EndpointInfo> hSet = new HashSet<EndpointInfo>();
        boolean flag = false;
        if (this.environment.getErrorCount() == 0) {
            Iterator services;
            this.endpointInfo.setRuntimeModel(this.useModel ? this.endpointInfo.getModel() : this.makeAppRelative(this.modelFile));
            if (this.endpointInfo.getRuntimeWSDL() == null) {
                this.endpointInfo.setRuntimeWSDL(this.makeAppRelative(this.findGeneratedFileEndingWith(".wsdl")));
            }
            if ((services = this.processor.getModel().getServices()).hasNext()) {
                Service service = (Service)services.next();
                this.endpointInfo.setRuntimeServiceName(service.getName());
                Iterator ports = service.getPorts();
                Port port = null;
                EndpointInfo endpoint = null;
                String name = null;
                if (this.endpointInfo.getModel() != null) {
                    int counter = 0;
                    while (counter < this.vector.size()) {
                        endpoint = (EndpointInfo)this.vector.get(counter);
                        name = "";
                        int index = counter + 1;
                        while (index < this.vector.size()) {
                            if (endpoint.getInterface().equals(((EndpointInfo)this.vector.get(index)).getInterface())) {
                                flag = hSet.add(endpoint);
                                if (flag && endpoint.getRuntimePortName() == null) {
                                    name = endpoint.getName();
                                    this.onWarning(this.getMessage("wscompile.warning.noportInfo", name));
                                }
                                flag = false;
                                flag = hSet.add((EndpointInfo)this.vector.get(index));
                                if (flag && ((EndpointInfo)this.vector.get(index)).getRuntimePortName() == null) {
                                    name = ((EndpointInfo)this.vector.get(index)).getName();
                                    this.onWarning(this.getMessage("wscompile.warning.noportInfo", name));
                                }
                            }
                            ++index;
                        }
                        ++counter;
                    }
                }
                while (ports.hasNext()) {
                    port = (Port)ports.next();
                    QName portName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
                    if (portName == null) {
                        portName = port.getName();
                    }
                    if (this.endpointInfo.getModel() == null) {
                        if (!port.getJavaInterface().getName().equals(this.endpointInfo.getInterface())) continue;
                        this.endpointInfo.setRuntimePortName(portName);
                        JavaInterface intf = port.getJavaInterface();
                        this.endpointInfo.setRuntimeTie(this.environment.getNames().tieFor(port));
                        this.endpointInfo.setRuntimeDeployed(true);
                        continue;
                    }
                    int counter = 0;
                    while (counter < this.vector.size()) {
                        JavaInterface intf;
                        this.endpointInfo = (EndpointInfo)this.vector.get(counter);
                        if (this.vector.size() > 1) {
                            if (!hSet.contains(this.endpointInfo) || this.endpointInfo.getRuntimePortName() != null) {
                                if (hSet.contains(this.endpointInfo) && portName.equals(this.endpointInfo.getRuntimePortName())) {
                                    this.endpointInfo.setRuntimeModel(this.useModel ? this.endpointInfo.getModel() : this.makeAppRelative(this.modelFile));
                                    if (this.endpointInfo.getRuntimeWSDL() == null) {
                                        this.endpointInfo.setRuntimeWSDL(this.makeAppRelative(this.findGeneratedFileEndingWith(".wsdl")));
                                    }
                                    this.endpointInfo.setRuntimeServiceName(service.getName());
                                    intf = port.getJavaInterface();
                                    this.endpointInfo.setRuntimeTie(this.environment.getNames().tieFor(port));
                                    this.endpointInfo.setRuntimeDeployed(true);
                                } else if (port.getJavaInterface().getName().equals(this.endpointInfo.getInterface()) && !hSet.contains(this.endpointInfo)) {
                                    this.endpointInfo.setRuntimeModel(this.useModel ? this.endpointInfo.getModel() : this.makeAppRelative(this.modelFile));
                                    if (this.endpointInfo.getRuntimeWSDL() == null) {
                                        this.endpointInfo.setRuntimeWSDL(this.makeAppRelative(this.findGeneratedFileEndingWith(".wsdl")));
                                    }
                                    this.endpointInfo.setRuntimeServiceName(service.getName());
                                    intf = port.getJavaInterface();
                                    this.endpointInfo.setRuntimeTie(this.environment.getNames().tieFor(port));
                                    if (this.endpointInfo.getRuntimePortName() == null) {
                                        this.endpointInfo.setRuntimePortName(portName);
                                    }
                                    this.endpointInfo.setRuntimeDeployed(true);
                                }
                            }
                        } else if (port.getJavaInterface().getName().equals(this.endpointInfo.getInterface())) {
                            this.endpointInfo.setRuntimeModel(this.useModel ? this.endpointInfo.getModel() : this.makeAppRelative(this.modelFile));
                            if (this.endpointInfo.getRuntimeWSDL() == null) {
                                this.endpointInfo.setRuntimeWSDL(this.makeAppRelative(this.findGeneratedFileEndingWith(".wsdl")));
                            }
                            this.endpointInfo.setRuntimeServiceName(service.getName());
                            this.endpointInfo.setRuntimePortName(portName);
                            intf = port.getJavaInterface();
                            this.endpointInfo.setRuntimeTie(this.environment.getNames().tieFor(port));
                            this.endpointInfo.setRuntimeDeployed(true);
                        }
                        ++counter;
                    }
                }
            }
        }
    }

    protected Configuration createConfiguration() throws Exception {
        Configuration config = new Configuration(this.environment);
        if (this.useModel) {
            ModelFileModelInfo modelInfo = new ModelFileModelInfo();
            modelInfo.setLocation(this.makeAbsolute(this.endpointInfo.getModel()));
            config.setModelInfo(modelInfo);
        } else {
            RmiModelInfo modelInfo = new RmiModelInfo();
            modelInfo.setName(this.endpointInfo.getName());
            modelInfo.setTargetNamespaceURI(this.makeTargetNamespaceURI());
            modelInfo.setTypeNamespaceURI(this.makeTypeNamespaceURI());
            modelInfo.setJavaPackageName(this.makeJavaPackageName());
            RmiInterfaceInfo interfaceInfo = new RmiInterfaceInfo();
            interfaceInfo.setName(this.endpointInfo.getInterface());
            interfaceInfo.setServantName(this.endpointInfo.getImplementation());
            interfaceInfo.setServerHandlerChainInfo(this.endpointInfo.getServerHandlerChainInfo());
            modelInfo.add(interfaceInfo);
            config.setModelInfo(modelInfo);
        }
        return config;
    }

    protected String makeTargetNamespaceURI() {
        String base = this.webServicesInfo.getTargetNamespaceBase();
        if (base.endsWith("/") || base.startsWith("urn:")) {
            return base + this.endpointInfo.getName();
        }
        return base + "/" + this.endpointInfo.getName();
    }

    protected String makeTypeNamespaceURI() {
        String base = this.webServicesInfo.getTypeNamespaceBase();
        if (base.endsWith("/") || base.startsWith("urn:")) {
            return base + this.endpointInfo.getName();
        }
        return base + "/" + this.endpointInfo.getName();
    }

    protected String makeModelFileName() {
        return this.targetDirectory.getAbsolutePath() + FS + "WEB-INF" + FS + this.endpointInfo.getName() + "_model.xml.gz";
    }

    protected String makeJavaPackageName() {
        return "jaxrpc.generated." + this.environment.getNames().validJavaPackageName(this.endpointInfo.getName());
    }

    protected String makeAbsolute(String s) {
        if (s == null) {
            return null;
        }
        return new File(this.targetDirectory.getAbsolutePath() + s).getAbsolutePath();
    }

    protected String makeAppRelative(File f) {
        String target;
        if (f == null) {
            return null;
        }
        String s = f.getAbsolutePath();
        if (s.startsWith(target = this.targetDirectory.getAbsolutePath())) {
            return s.substring(target.length()).replace(FSCHAR, '/');
        }
        return null;
    }

    protected File findGeneratedFileEndingWith(String s) {
        Iterator iter = this.environment.getGeneratedFiles();
        while (iter.hasNext()) {
            GeneratedFileInfo fileInfo = (GeneratedFileInfo)iter.next();
            File file = fileInfo.getFile();
            if (!file.getAbsolutePath().endsWith(s)) continue;
            return file;
        }
        return null;
    }

    protected void registerProcessorActions(Processor processor) {
        if (!this.useModel) {
            try {
                processor.add(new XMLModelWriter(this.modelFile));
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        processor.add(this.getAction("enumeration.generator"));
        processor.add(this.getAction("enumeration.encoder.generator"));
        processor.add(this.getAction("holder.generator"));
        processor.add(this.getAction("custom.class.generator"));
        processor.add(this.getAction("soap.object.serializer.generator"));
        processor.add(this.getAction("interface.serializer.generator"));
        processor.add(this.getAction("soap.object.builder.generator"));
        processor.add(this.getAction("literal.object.serializer.generator"));
        processor.add(this.getAction("custom.exception.generator"));
        processor.add(this.getAction("soap.fault.serializer.generator"));
        processor.add(this.getAction("fault.exception.builder.generator"));
        processor.add(this.getAction("serializer.registry.generator"));
        processor.add(this.getAction("tie.generator"));
        processor.add(this.getAction("wsdl.generator"));
    }

    public void onError(Localizable msg) {
        this.report(this.getMessage("wscompile.error", this.localizer.localize(msg)));
    }

    public void onWarning(Localizable msg) {
        this.report(this.getMessage("wscompile.warning", this.localizer.localize(msg)));
    }

    public void onInfo(Localizable msg) {
        this.report(this.getMessage("wscompile.info", this.localizer.localize(msg)));
    }
}

