/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util.xml;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.util.xml.NamedNodeMapIterator;
import com.sun.xml.rpc.util.xml.NodeListIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtil {
    static TransformerFactory transformerFactory = null;

    public static String getPrefix(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            return null;
        }
        return s.substring(0, i);
    }

    public static String getLocalPart(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1);
    }

    public static String getAttributeOrNull(Element e, String name) {
        Attr a = e.getAttributeNode(name);
        if (a == null) {
            return null;
        }
        return a.getValue();
    }

    public static String getAttributeNSOrNull(Element e, String name, String nsURI) {
        Attr a = e.getAttributeNodeNS(nsURI, name);
        if (a == null) {
            return null;
        }
        return a.getValue();
    }

    public static boolean matchesTagNS(Element e, String tag, String nsURI) {
        return e.getLocalName().equals(tag) && e.getNamespaceURI().equals(nsURI);
    }

    public static boolean matchesTagNS(Element e, QName name) {
        return e.getLocalName().equals(name.getLocalPart()) && e.getNamespaceURI().equals(name.getNamespaceURI());
    }

    public static Iterator getAllChildren(Element element) {
        return new NodeListIterator(element.getChildNodes());
    }

    public static Iterator getAllAttributes(Element element) {
        return new NamedNodeMapIterator(element.getAttributes());
    }

    public static List parseTokenList(String tokenList) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(tokenList, " ");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public static String getTextForNode(Node node) {
        StringBuffer sb = new StringBuffer();
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return null;
        }
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n instanceof Text) {
                sb.append(n.getNodeValue());
            } else if (n instanceof EntityReference) {
                String s = XmlUtil.getTextForNode(n);
                if (s == null) {
                    return null;
                }
                sb.append(s);
            } else {
                return null;
            }
            ++i;
        }
        return sb.toString();
    }

    public static InputStream getUTF8Stream(String s) {
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)bas, "utf-8");
            w.write(s);
            ((Writer)w).close();
            byte[] ba = bas.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(ba);
            return bis;
        }
        catch (IOException e) {
            throw new RuntimeException("should not happen");
        }
    }

    public static ByteInputStream getUTF8ByteInputStream(String s) {
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)bas, "utf-8");
            w.write(s);
            ((Writer)w).close();
            byte[] ba = bas.toByteArray();
            ByteInputStream bis = new ByteInputStream(ba, ba.length);
            return bis;
        }
        catch (IOException e) {
            throw new RuntimeException("should not happen");
        }
    }

    public static Transformer newTransformer() {
        Transformer t = null;
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        try {
            t = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException tex) {
            throw new IllegalStateException("Unable to create a JAXP transformer");
        }
        return t;
    }
}

