/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.document.schema;

import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.document.schema.SchemaEntity;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.framework.AbstractDocument;
import com.sun.xml.rpc.wsdl.framework.Defining;
import com.sun.xml.rpc.wsdl.framework.Extension;
import com.sun.xml.rpc.wsdl.framework.Kind;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class Schema
extends Extension
implements Defining {
    private AbstractDocument _document;
    private String _targetNamespaceURI;
    private SchemaElement _content;
    private List _definedEntities;
    private Map _nsPrefixes;

    public Schema(AbstractDocument document) {
        this._document = document;
        this._nsPrefixes = new HashMap();
        this._definedEntities = new ArrayList();
    }

    public QName getElementName() {
        return SchemaConstants.QNAME_SCHEMA;
    }

    public SchemaElement getContent() {
        return this._content;
    }

    public void setContent(SchemaElement entity) {
        this._content = entity;
        this._content.setSchema(this);
    }

    public void setTargetNamespaceURI(String uri) {
        this._targetNamespaceURI = uri;
    }

    public String getTargetNamespaceURI() {
        return this._targetNamespaceURI;
    }

    public void addPrefix(String prefix, String uri) {
        this._nsPrefixes.put(prefix, uri);
    }

    public String getURIForPrefix(String prefix) {
        return (String)this._nsPrefixes.get(prefix);
    }

    public Iterator prefixes() {
        return this._nsPrefixes.keySet().iterator();
    }

    public void defineAllEntities() {
        if (this._content == null) {
            throw new ValidationException("validation.shouldNotHappen", "missing schema content");
        }
        Iterator iter = this._content.children();
        while (iter.hasNext()) {
            QName name;
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                name = new QName(this._targetNamespaceURI, child.getValueOfMandatoryAttribute("name"));
                this.defineEntity(child, SchemaKinds.XSD_ATTRIBUTE, name);
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                name = new QName(this._targetNamespaceURI, child.getValueOfMandatoryAttribute("name"));
                this.defineEntity(child, SchemaKinds.XSD_ATTRIBUTE_GROUP, name);
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ELEMENT)) {
                name = new QName(this._targetNamespaceURI, child.getValueOfMandatoryAttribute("name"));
                this.defineEntity(child, SchemaKinds.XSD_ELEMENT, name);
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_GROUP)) {
                name = new QName(this._targetNamespaceURI, child.getValueOfMandatoryAttribute("name"));
                this.defineEntity(child, SchemaKinds.XSD_GROUP, name);
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_COMPLEX_TYPE)) {
                name = new QName(this._targetNamespaceURI, child.getValueOfMandatoryAttribute("name"));
                this.defineEntity(child, SchemaKinds.XSD_TYPE, name);
                continue;
            }
            if (!child.getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) continue;
            name = new QName(this._targetNamespaceURI, child.getValueOfMandatoryAttribute("name"));
            this.defineEntity(child, SchemaKinds.XSD_TYPE, name);
        }
    }

    public void defineEntity(SchemaElement element, Kind kind, QName name) {
        SchemaEntity entity = new SchemaEntity(this, element, kind, name);
        this._document.define(entity);
        this._definedEntities.add(entity);
    }

    public Iterator definedEntities() {
        return this._definedEntities.iterator();
    }

    public void validateThis() {
        if (this._content == null) {
            throw new ValidationException("validation.shouldNotHappen", "missing schema content");
        }
    }

    public String asString(QName name) {
        if (name.getNamespaceURI().equals("")) {
            return name.getLocalPart();
        }
        Iterator iter = this.prefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            if (!prefix.equals(name.getNamespaceURI())) continue;
            return prefix + ":" + name.getLocalPart();
        }
        return null;
    }
}

