/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.wsdl.document.schema.Schema;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.document.schema.SchemaDocument;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.framework.WriterContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class SchemaWriter {
    public void write(SchemaDocument document, OutputStream os) throws IOException {
        WriterContext context = new WriterContext(os);
        this.writeSchema(context, document.getSchema());
        context.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSchema(WriterContext context, Schema schema) throws IOException {
        context.push();
        try {
            try {
                this.writeTopSchemaElement(context, schema);
            }
            catch (Exception e) {
                Object var5_4 = null;
                context.pop();
            }
            Object var5_3 = null;
            context.pop();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.pop();
            throw throwable;
        }
    }

    protected void writeTopSchemaElement(WriterContext context, Schema schema) throws IOException {
        SchemaElement schemaElement = schema.getContent();
        QName name = schemaElement.getQName();
        Iterator iter = schema.prefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String expectedURI = schema.getURIForPrefix(prefix);
            if (expectedURI.equals(context.getNamespaceURI(prefix))) continue;
            context.declarePrefix(prefix, expectedURI);
        }
        Iterator iter2 = schemaElement.prefixes();
        while (iter2.hasNext()) {
            String prefix = (String)iter2.next();
            String uri = schemaElement.getURIForPrefix(prefix);
            context.declarePrefix(prefix, uri);
        }
        context.writeStartTag(name);
        Iterator iter3 = schemaElement.attributes();
        while (iter3.hasNext()) {
            SchemaAttribute attribute = (SchemaAttribute)iter3.next();
            if (attribute.getNamespaceURI() == null) {
                context.writeAttribute(attribute.getLocalName(), attribute.getValue(context));
                continue;
            }
            context.writeAttribute(context.getQNameString(attribute.getQName()), attribute.getValue(context));
        }
        context.writeAllPendingNamespaceDeclarations();
        Iterator iter4 = schemaElement.children();
        while (iter4.hasNext()) {
            SchemaElement child = (SchemaElement)iter4.next();
            this.writeSchemaElement(context, child);
        }
        context.writeEndTag(name);
    }

    protected void writeSchemaElement(WriterContext context, SchemaElement schemaElement) throws IOException {
        Iterator iter;
        QName name = schemaElement.getQName();
        if (schemaElement.declaresPrefixes()) {
            context.push();
        }
        context.writeStartTag(name);
        if (schemaElement.declaresPrefixes()) {
            iter = schemaElement.prefixes();
            while (iter.hasNext()) {
                String prefix = (String)iter.next();
                String uri = schemaElement.getURIForPrefix(prefix);
                context.writeNamespaceDeclaration(prefix, uri);
                context.declarePrefix(prefix, uri);
            }
        }
        iter = schemaElement.attributes();
        while (iter.hasNext()) {
            SchemaAttribute attribute = (SchemaAttribute)iter.next();
            if (attribute.getNamespaceURI() == null) {
                context.writeAttribute(attribute.getLocalName(), attribute.getValue(context));
                continue;
            }
            context.writeAttribute(context.getQNameString(attribute.getQName()), attribute.getValue(context));
        }
        Iterator iter2 = schemaElement.children();
        while (iter2.hasNext()) {
            SchemaElement child = (SchemaElement)iter2.next();
            this.writeSchemaElement(context, child);
        }
        context.writeEndTag(name);
        if (schemaElement.declaresPrefixes()) {
            context.pop();
        }
    }
}

