/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.calc;

import org.opensha.data.Direction;
import org.opensha.data.Location;
import org.opensha.data.LocationList;

public final class RelativeLocation {
    public static final String C = "RelativeLocation";
    protected static final boolean D = false;
    public static final int R = 6367;
    public static final double RADIANS_CONVERSION = Math.PI / 180;
    public static final double D_COEFF = 111.11;
    static final boolean SPEED_TEST = false;

    private RelativeLocation() {
    }

    public static Direction getDirection(Location location1, Location location2) throws UnsupportedOperationException {
        Direction dir = new Direction();
        double lat1 = location1.getLatitude();
        double lon1 = location1.getLongitude();
        double lat2 = location2.getLatitude();
        double lon2 = location2.getLongitude();
        double horzDistance = RelativeLocation.getHorzDistance(lat1, lon1, lat2, lon2);
        double azimuth = RelativeLocation.getAzimuth(lat1, lon1, lat2, lon2);
        double backAzimuth = RelativeLocation.getBackAzimuth(lat1, lon1, lat2, lon2);
        double vertDistance = -1.0 * (location1.getDepth() - location2.getDepth());
        dir.setHorzDistance(horzDistance);
        dir.setAzimuth(azimuth);
        dir.setBackAzimuth(backAzimuth);
        dir.setVertDistance(vertDistance);
        return dir;
    }

    public static double getTotalDistance(Location loc1, Location loc2) {
        double hDist = RelativeLocation.getHorzDistance(loc1, loc2);
        double vDist = RelativeLocation.getVertDistance(loc1, loc2);
        return Math.sqrt(hDist * hDist + vDist * vDist);
    }

    public static double getVertDistance(Location loc1, Location loc2) {
        return -1.0 * (loc1.getDepth() - loc2.getDepth());
    }

    public static Location getLocation(Location location, Direction direction) throws UnsupportedOperationException {
        double lat1 = location.getLatitude();
        double lon1 = location.getLongitude();
        double depth = location.getDepth();
        double azimuth = direction.getAzimuth();
        double horzDistance = direction.getHorzDistance();
        double vertDistance = direction.getVertDistance();
        double newLat = RelativeLocation.getLatitude(horzDistance, azimuth, lat1, lon1);
        double newLon = RelativeLocation.getLongitude(horzDistance, azimuth, lat1, lon1);
        double newDepth = depth + -1.0 * vertDistance;
        Location newLoc = new Location(newLat, newLon, newDepth);
        return newLoc;
    }

    private static double getLatitude(double delta, double azimuth, double lat, double lon) {
        delta = delta / 111.11 * (Math.PI / 180);
        double sdelt = Math.sin(delta);
        double cdelt = Math.cos(delta);
        double xlat = lat * (Math.PI / 180);
        double xlon = lon * (Math.PI / 180);
        double az2 = azimuth * (Math.PI / 180);
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double phi0 = xlon;
        double cz0 = Math.cos(az2);
        double ct1 = st0 * sdelt * cz0 + ct0 * cdelt;
        double x = st0 * cdelt - ct0 * sdelt * cz0;
        double y = sdelt * Math.sin(az2);
        double st1 = Math.pow(x * x + y * y, 0.5);
        double dlon = Math.atan2(y, x);
        double newLat = Math.atan2(ct1, st1) / (Math.PI / 180);
        return newLat;
    }

    private static double getLongitude(double delta, double azimuth, double lat, double lon) {
        delta = delta / 111.11 * (Math.PI / 180);
        double sdelt = Math.sin(delta);
        double cdelt = Math.cos(delta);
        double xlat = lat * (Math.PI / 180);
        double xlon = lon * (Math.PI / 180);
        double az2 = azimuth * (Math.PI / 180);
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double phi0 = xlon;
        double cz0 = Math.cos(az2);
        double ct1 = st0 * sdelt * cz0 + ct0 * cdelt;
        double x = st0 * cdelt - ct0 * sdelt * cz0;
        double y = sdelt * Math.sin(az2);
        double st1 = Math.pow(x * x + y * y, 0.5);
        double dlon = Math.atan2(y, x);
        double newLon = (phi0 + dlon) / (Math.PI / 180);
        return newLon;
    }

    private static double getMin(double a, double b) {
        if (a <= b) {
            return a;
        }
        return b;
    }

    public static double getApproxHorzDistance(double lat1, double lon1, double lat2, double lon2) {
        double d1 = (lat1 - lat2) * 111.111;
        double d2 = (lon1 - lon2) * 111.111 * Math.cos((lat1 + lat2) / 2.0 * Math.PI / 180.0);
        return Math.sqrt(d1 * d1 + d2 * d2);
    }

    public static double getHorzDistance(double lat1, double lon1, double lat2, double lon2) {
        double xlat = lat1 * (Math.PI / 180);
        double xlon = lon1 * (Math.PI / 180);
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double phi0 = xlon;
        xlat = lat2 * (Math.PI / 180);
        xlon = lon2 * (Math.PI / 180);
        double st1 = Math.cos(xlat);
        double ct1 = Math.sin(xlat);
        double sdlon = Math.sin(xlon - phi0);
        double cdlon = Math.cos(xlon - phi0);
        double cdelt = st0 * st1 * cdlon + ct0 * ct1;
        double x = st0 * ct1 - st1 * ct0 * cdlon;
        double y = st1 * sdlon;
        double sdelt = Math.pow(x * x + y * y, 0.5);
        double delta = Math.atan2(sdelt, cdelt) / (Math.PI / 180);
        return delta *= 111.11;
    }

    public static double getApproxHorzDistance(Location loc1, Location loc2) {
        return RelativeLocation.getApproxHorzDistance(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude());
    }

    public static double getHorzDistance(Location loc1, Location loc2) {
        return RelativeLocation.getHorzDistance(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude());
    }

    public static double getAzimuth(double lat1, double lon1, double lat2, double lon2) {
        double xlat = lat1 * (Math.PI / 180);
        double xlon = lon1 * (Math.PI / 180);
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double phi0 = xlon;
        xlat = lat2 * (Math.PI / 180);
        xlon = lon2 * (Math.PI / 180);
        double st1 = Math.cos(xlat);
        double ct1 = Math.sin(xlat);
        double sdlon = Math.sin(xlon - phi0);
        double cdlon = Math.cos(xlon - phi0);
        double x = st0 * ct1 - st1 * ct0 * cdlon;
        double y = st1 * sdlon;
        double az = Math.atan2(y, x) / (Math.PI / 180);
        return az;
    }

    public static double getAzimuth(Location loc1, Location loc2) {
        return RelativeLocation.getAzimuth(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude());
    }

    public static double getBackAzimuth(double lat1, double lon1, double lat2, double lon2) {
        double xlat = lat1 * (Math.PI / 180);
        double xlon = lon1 * (Math.PI / 180);
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double phi0 = xlon;
        xlat = lat2 * (Math.PI / 180);
        xlon = lon2 * (Math.PI / 180);
        double st1 = Math.cos(xlat);
        double ct1 = Math.sin(xlat);
        double sdlon = Math.sin(xlon - phi0);
        double cdlon = Math.cos(xlon - phi0);
        double x = st1 * ct0 - st0 * ct1 * cdlon;
        double y = -sdlon * st0;
        double baz = Math.atan2(y, x) / (Math.PI / 180);
        return baz;
    }

    public static double getDeltaLatFromKm(double km) {
        return km / 111.14;
    }

    public static double getDeltaLonFromKm(double lat, double km) {
        double radius = 6367.0 * Math.cos(Math.toRadians(lat));
        double longDistVal = Math.PI * 2 * radius / 360.0;
        return km / longDistVal;
    }

    public static void main(String[] argv) {
        System.out.println("test1:");
        Location loc1 = new Location(34.5, -128.0, 0.0);
        Location loc2 = new Location(33.3, -125.0, 0.0);
        Location pt1 = new Location(35.0, -122.0, 0.0);
        Location pt2 = new Location(35.0, 238.0, 0.0);
        System.out.println("Horizontal distance1 = " + RelativeLocation.getHorzDistance(loc1, pt1));
        System.out.println("Horizontal distance2 = " + RelativeLocation.getHorzDistance(loc1, pt2));
        System.out.println("Approx. Horizontal distance1 = " + RelativeLocation.getApproxHorzDistance(loc1, pt1));
        System.out.println("Approx. Horizontal distance2 = " + RelativeLocation.getApproxHorzDistance(loc1, pt2));
        System.out.println("Approx. Horizontal distance Calc from loc1 to Line = " + RelativeLocation.getApproxHorzDistToLine(pt1, loc1, loc2));
        System.out.println("Approx. Horizontal distance Calc from loc2 to Line = " + RelativeLocation.getApproxHorzDistToLine(pt2, loc1, loc2));
        System.out.println("Approx. Horizontal distance(considering line is evenly discretized by 0.1km) from loc1 to Line = " + RelativeLocation.getApproxHorzDistToLine_2(pt1, loc1, loc2));
        System.out.println("Approx. Horizontal distance(considering line is evenly discretized by 0.1km) from loc2 to Line = " + RelativeLocation.getApproxHorzDistToLine_2(pt2, loc1, loc2));
    }

    public static double latLonDistance(double lat1, double lon1, double lat2, double lon2) {
        double deltaLon = Math.toRadians(lon2) - Math.toRadians(lon1);
        double deltaLat = Math.toRadians(lat2) - Math.toRadians(lat1);
        double sin2DeltaLat = Math.pow(Math.sin(deltaLat / 2.0), 2.0);
        double sin2DeltaLon = Math.pow(Math.sin(deltaLon / 2.0), 2.0);
        double cosLat1 = Math.cos(Math.toRadians(lat1));
        double cosLat2 = Math.cos(Math.toRadians(lat2));
        double a = sin2DeltaLat + cosLat1 * cosLat2 * sin2DeltaLon;
        double b = RelativeLocation.getMin(1.0, Math.sqrt(a));
        double c = 2.0 * Math.asin(b);
        return 6367.0 * c;
    }

    public static double getApproxHorzDistToLine_2(Location loc, Location lineLoc1, Location lineLoc2) {
        Direction dir = RelativeLocation.getDirection(lineLoc1, lineLoc2);
        LocationList locList = new LocationList();
        int nDist = (int)(dir.getHorzDistance() / 0.1);
        for (int i = 0; i <= nDist; ++i) {
            dir.setHorzDistance((double)i * 0.1);
            locList.addLocation(RelativeLocation.getLocation(lineLoc1, dir));
        }
        return locList.getHorzDistToClosestLocation(loc);
    }

    public static double getApproxHorzDistToLine(Location loc, Location lineLoc1, Location lineLoc2) {
        double horzCorr = Math.cos(Math.PI * (0.5 * loc.getLatitude() + 0.25 * lineLoc1.getLatitude() + 0.25 * lineLoc2.getLatitude()) / 180.0);
        double x1 = 111.111 * horzCorr * (lineLoc1.getLongitude() - loc.getLongitude());
        double x2 = 111.111 * horzCorr * (lineLoc2.getLongitude() - loc.getLongitude());
        double y1 = 111.111 * (lineLoc1.getLatitude() - loc.getLatitude());
        double y2 = 111.111 * (lineLoc2.getLatitude() - loc.getLatitude());
        if (x1 != x2) {
            double slope = (y2 - y1) / (x2 - x1);
            double intercept = y2 - slope * x2;
            double xTarget = -slope * intercept / (1.0 + slope * slope);
            double yTarget = slope * xTarget + intercept;
            boolean within = false;
            if (x2 > x1) {
                if (xTarget <= x2 && xTarget >= x1) {
                    within = true;
                }
            } else if (xTarget <= x1 && xTarget >= x2) {
                within = true;
            }
            if (within) {
                return Math.sqrt(xTarget * xTarget + yTarget * yTarget);
            }
            double d1 = Math.sqrt(x1 * x1 + y1 * y1);
            double d2 = Math.sqrt(x2 * x2 + y2 * y2);
            return Math.min(d1, d2);
        }
        if (y2 > y1) {
            if (y2 <= 0.0) {
                return Math.sqrt(x2 * x2 + y2 * y2);
            }
            if (y1 >= 0.0) {
                return Math.sqrt(x1 * x1 + y1 * y1);
            }
            return Math.abs(x1);
        }
        if (y1 <= 0.0) {
            return Math.sqrt(x1 * x1 + y1 * y1);
        }
        if (y2 >= 0.0) {
            return Math.sqrt(x2 * x2 + y2 * y2);
        }
        return Math.abs(x1);
    }
}

