/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.calc.magScalingRelations.magScalingRelImpl;

import org.opensha.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.util.FaultUtils;

public class WC1994_MagLengthRelationship
extends MagLengthRelationship {
    static final String C = "WC1994_MagLengthRelationship";
    public static final String NAME = "W&C 1994 Mag-Length Rel.";

    public WC1994_MagLengthRelationship() {
        this.rake = Double.NaN;
    }

    public String getName() {
        return NAME;
    }

    public double getMedianMag(double length) {
        if (Double.isNaN(this.rake)) {
            return 5.08 + 1.16 * Math.log(length) * 0.434294;
        }
        if (this.rake <= 45.0 && this.rake >= -45.0 || this.rake >= 135.0 && this.rake <= -135.0) {
            return 5.16 + 1.12 * Math.log(length) * 0.434294;
        }
        if (this.rake > 0.0) {
            return 5.0 + 1.22 * Math.log(length) * 0.434294;
        }
        return 4.86 + 1.32 * Math.log(length) * 0.434294;
    }

    public double getMagStdDev() {
        if (Double.isNaN(this.rake)) {
            return 0.28;
        }
        if (this.rake <= 45.0 && this.rake >= -45.0 || this.rake >= 135.0 && this.rake <= -135.0) {
            return 0.28;
        }
        if (this.rake > 0.0) {
            return 0.28;
        }
        return 0.34;
    }

    public double getMedianLength(double mag) {
        if (Double.isNaN(this.rake)) {
            return Math.pow(10.0, -3.22 + 0.69 * mag);
        }
        if (this.rake <= 45.0 && this.rake >= -45.0 || this.rake >= 135.0 && this.rake <= -135.0) {
            return Math.pow(10.0, -3.55 + 0.74 * mag);
        }
        if (this.rake > 0.0) {
            return Math.pow(10.0, -2.86 + 0.63 * mag);
        }
        return Math.pow(10.0, -2.01 + 0.5 * mag);
    }

    public double getLengthStdDev() {
        if (Double.isNaN(this.rake)) {
            return 0.22;
        }
        if (this.rake <= 45.0 && this.rake >= -45.0 || this.rake >= 135.0 && this.rake <= -135.0) {
            return 0.23;
        }
        if (this.rake > 0.0) {
            return 0.2;
        }
        return 0.21;
    }

    public void setRake(double rake) {
        if (!Double.isNaN(rake)) {
            FaultUtils.assertValidRake(rake);
        }
        this.rake = rake;
    }
}

