/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.estimate;

import org.opensha.data.estimate.Estimate;
import org.opensha.data.estimate.InvalidParamValException;
import org.opensha.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.data.function.DiscretizedFunc;

public abstract class DiscretizedFuncEstimate
extends Estimate {
    protected ArbDiscrEmpiricalDistFunc func = null;
    protected DiscretizedFunc cumDistFunc = null;
    protected double tol = 1.0E-6;

    public DiscretizedFuncEstimate(DiscretizedFunc func, boolean isNormalized) {
        this.setValues(func, isNormalized);
    }

    public String toString() {
        String text = "EstimateType=" + this.getName() + "\n";
        text = text + super.toString() + "\n";
        text = text + "Values from toString() method of specific estimate\nValue\tProbability\n";
        for (int i = 0; this.func != null && i < this.func.getNum(); ++i) {
            text = text + "\n" + this.func.getX(i) + "\t" + this.func.getY(i);
        }
        text = text + "\ngetFractile(0.5) = " + this.getFractile(0.5) + "\n" + "getDiscreteFractile(0.5) = " + this.getDiscreteFractile(0.5) + "\n";
        return text;
    }

    public void setValues(DiscretizedFunc newFunc, boolean isNormalized) {
        double val;
        int i;
        double sum = 0.0;
        int num = newFunc.getNum();
        if (isNormalized) {
            for (i = 0; i < num; ++i) {
                val = newFunc.getY(i);
                if (val < 0.0 || val > 1.0) {
                    throw new InvalidParamValException("Error: All probabilities must be \u2265 0 and \u2264 1");
                }
                sum += val;
            }
            if (Math.abs(sum - 1.0) > this.tol) {
                throw new InvalidParamValException("Error: The probability values do not sum to 1");
            }
        } else {
            for (i = 0; i < num; ++i) {
                val = newFunc.getY(i);
                if (val < 0.0) {
                    throw new InvalidParamValException("Error: All probability values must be positive");
                }
                sum += val;
            }
            if (sum == 0.0) {
                throw new InvalidParamValException("Error: At least one probability value must be > 0.");
            }
            for (i = 0; i < num; ++i) {
                val = newFunc.getY(i);
                newFunc.set(i, val / sum);
            }
        }
        this.func = new ArbDiscrEmpiricalDistFunc();
        for (i = 0; i < newFunc.getNum(); ++i) {
            this.func.set(newFunc.getX(i), newFunc.getY(i));
        }
        this.min = this.func.getMinX();
        this.max = this.func.getMaxX();
        this.cumDistFunc = this.func.getCumDist();
    }

    public DiscretizedFunc getValues() {
        return this.func;
    }

    public double getMode() {
        return this.func.getMode();
    }

    public double getMedian() {
        return this.func.getMedian();
    }

    public double getStdDev() {
        return this.func.getStdDev();
    }

    public double getMean() {
        return this.func.getMean();
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }

    public DiscretizedFunc getFunc() {
        return this.func;
    }

    public double getFractile(double prob) {
        return this.func.getInterpolatedFractile(prob);
    }

    public double getDiscreteFractile(double prob) {
        return this.func.getDiscreteFractile(prob);
    }
}

