/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.function;

import java.io.Serializable;
import java.util.Iterator;
import org.opensha.data.DataPoint2D;
import org.opensha.data.EmpiricalDistributionTreeMap;
import org.opensha.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.data.function.DiscretizedFuncAPI;
import org.opensha.exceptions.DataPoint2DException;
import org.opensha.exceptions.InvalidRangeException;

public class ArbDiscrEmpiricalDistFunc
extends ArbitrarilyDiscretizedFunc
implements Serializable {
    protected static final String C = "ArbDiscrEmpiricalDistFunc";
    protected static final boolean D = true;

    public ArbDiscrEmpiricalDistFunc() {
        this.points = new EmpiricalDistributionTreeMap();
    }

    public void setTolerance(double newTolerance) throws InvalidRangeException {
        throw new InvalidRangeException("Cannot change the tolerance for ArbDiscrEmpiricalDistFunc (it must be zero)");
    }

    public DiscretizedFuncAPI deepClone() {
        ArbDiscrEmpiricalDistFunc function = new ArbDiscrEmpiricalDistFunc();
        function.setInfo(this.getInfo());
        Iterator it = this.getPointsIterator();
        if (it != null) {
            while (it.hasNext()) {
                function.set((DataPoint2D)((DataPoint2D)it.next()).clone());
            }
        }
        return function;
    }

    public double getInterpolatedFractile(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new InvalidRangeException("fraction value must be between 0 and 1");
        }
        ArbitrarilyDiscretizedFunc tempCumDist = this.getNormalizedCumDist();
        if (fraction < tempCumDist.getMinY()) {
            return tempCumDist.getMinX();
        }
        return tempCumDist.getFirstInterpolatedX(fraction);
    }

    public double getDiscreteFractile(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new InvalidRangeException("fraction value must be between 0 and 1");
        }
        ArbitrarilyDiscretizedFunc tempCumDist = this.getNormalizedCumDist();
        for (int i = 0; i < tempCumDist.getNum(); ++i) {
            if (!(fraction <= tempCumDist.getY(i))) continue;
            return tempCumDist.getX(i);
        }
        if (fraction < tempCumDist.getMinY()) {
            return tempCumDist.getMinX();
        }
        return tempCumDist.getFirstInterpolatedX(fraction);
    }

    public ArbitrarilyDiscretizedFunc getNormalizedCumDist() {
        double totSum = 0.0;
        Iterator it = this.getPointsIterator();
        while (it.hasNext()) {
            totSum += ((DataPoint2D)it.next()).getY();
        }
        return this.getCumDist(totSum);
    }

    public double getMean() {
        ArbitrarilyDiscretizedFunc tempCumDist = this.getNormalizedCumDist();
        double mean = 0.0;
        for (int i = 0; i < tempCumDist.getNum(); ++i) {
            mean += tempCumDist.getX(i) * tempCumDist.getY(i);
        }
        return mean;
    }

    public double getStdDev() {
        double mean = this.getMean();
        double stdDev = 0.0;
        for (int i = 0; i < this.getNum(); ++i) {
            stdDev += Math.pow(mean - this.getX(i), 2.0);
        }
        return Math.sqrt(stdDev /= (double)this.getNum());
    }

    public double getMode() {
        int index = -1;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.getNum(); ++i) {
            if (!(this.getY(i) > maxY)) continue;
            maxY = this.getY(i);
            index = i;
        }
        return this.getX(index);
    }

    public double getMedian() {
        return this.getInterpolatedFractile(0.5);
    }

    private ArbitrarilyDiscretizedFunc getCumDist(double totSum) throws DataPoint2DException {
        ArbitrarilyDiscretizedFunc cumDist = new ArbitrarilyDiscretizedFunc(0.0);
        double sum = 0.0;
        Iterator it = this.getPointsIterator();
        while (it.hasNext()) {
            DataPoint2D dp = (DataPoint2D)it.next();
            DataPoint2D dpNew = new DataPoint2D(dp.getX(), (sum += dp.getY()) / totSum);
            cumDist.set(dpNew);
        }
        return cumDist;
    }

    public ArbitrarilyDiscretizedFunc getCumDist() {
        return this.getCumDist(1.0);
    }

    public static void main(String[] args) {
        DataPoint2D point;
        ArbDiscrEmpiricalDistFunc func = new ArbDiscrEmpiricalDistFunc();
        func.set(0.0042254953, 0.1);
        func.set(0.008433135, 0.3);
        func.set(0.02094968, 0.1);
        func.set(0.002148321, 0.02);
        func.set(0.0042920266, 0.06);
        func.set(0.010695551, 0.02);
        func.set(0.002150044, 0.02);
        func.set(0.0042954655, 0.06);
        func.set(0.010704094, 0.02);
        func.set(0.0021466056, 0.02);
        func.set(0.0042886036, 0.06);
        func.set(0.010687049, 0.02);
        func.set(0.0021485311, 0.02);
        func.set(0.004292446, 0.06);
        func.set(0.010696594, 0.02);
        func.set(0.0021486057, 0.02);
        func.set(0.0042925947, 0.06);
        func.set(0.0106969625, 0.02);
        System.out.println("func:");
        Iterator it = func.getPointsIterator();
        while (it.hasNext()) {
            point = (DataPoint2D)it.next();
            System.out.println(point.getX() + "  " + point.getY());
        }
        System.out.println("\ncumFunc:");
        ArbitrarilyDiscretizedFunc cumFunc = func.getNormalizedCumDist();
        it = cumFunc.getPointsIterator();
        while (it.hasNext()) {
            point = (DataPoint2D)it.next();
            System.out.println(point.getX() + "  " + point.getY());
        }
        System.out.println("\nFractiles from cumFunc:");
        System.out.println("0.25: " + cumFunc.getFirstInterpolatedX(0.25));
        System.out.println("0.5: " + cumFunc.getFirstInterpolatedX(0.5));
        System.out.println("0.75: " + cumFunc.getFirstInterpolatedX(0.75));
        System.out.println("\nFractiles from method:");
        System.out.println("0.0: " + func.getInterpolatedFractile(0.0));
        System.out.println("0.05: " + func.getInterpolatedFractile(0.05));
        System.out.println("0.25: " + func.getInterpolatedFractile(0.25));
        System.out.println("0.5: " + func.getInterpolatedFractile(0.5));
        System.out.println("0.75: " + func.getInterpolatedFractile(0.75));
        System.out.println("1.0: " + func.getInterpolatedFractile(1.0));
    }
}

