/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.function;

import java.util.ArrayList;
import org.opensha.calc.FractileCurveCalculator;
import org.opensha.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.data.function.DiscretizedFuncAPI;
import org.opensha.data.function.DiscretizedFuncList;

public class WeightedFuncList {
    private ArrayList relativeWts = new ArrayList();
    private DiscretizedFuncList functionList = new DiscretizedFuncList();
    private DiscretizedFuncList fractileList = new DiscretizedFuncList();
    private ArbitrarilyDiscretizedFunc meanFunction;
    private static final String ERROR_WEIGHTS = "Error! Number of weights should be equal to number of curves";
    private FractileCurveCalculator fractileCalc;
    private ArrayList fractionList = new ArrayList();
    private boolean isMeanFractileCalculated = false;
    private String info = null;

    public void addList(ArrayList relWts, DiscretizedFuncList funcList) {
        int size = relWts.size();
        if (size != funcList.size()) {
            throw new RuntimeException(ERROR_WEIGHTS);
        }
        for (int i = 0; i < size; ++i) {
            DiscretizedFuncAPI function = funcList.get(i);
            if (!this.isFuncAllowed(function)) {
                throw new RuntimeException("Function not allowed");
            }
            this.functionList.add(function);
            this.relativeWts.add(relWts.get(i));
        }
        if (this.fractileList.size() > 0) {
            ArrayList list = new ArrayList();
            list.addAll(this.fractionList);
            this.addFractiles(list);
        }
        if (this.isMeanFractileCalculated) {
            this.addMean();
        }
        this.setInfoForWeightedFunctionList();
    }

    private void setInfoForWeightedFunctionList() {
        String funcListInfo = this.functionList.size() + " functions with relative weights: ";
        for (int i = 0; i < this.relativeWts.size(); ++i) {
            funcListInfo = funcListInfo + (Double)this.relativeWts.get(i) + ", ";
        }
        funcListInfo = funcListInfo.substring(0, funcListInfo.length() - 2) + "\n";
        this.functionList.setInfo(funcListInfo);
        int size = this.functionList.size();
    }

    public void add(double relWt, DiscretizedFuncAPI func) {
        this.relativeWts.add(new Double(relWt));
        if (!this.isFuncAllowed(func)) {
            throw new RuntimeException("Function not allowed");
        }
        this.functionList.add(func);
        if (this.fractileList.size() > 0) {
            ArrayList list = new ArrayList();
            list.addAll(this.fractionList);
            this.addFractiles(list);
        }
        if (this.isMeanFractileCalculated) {
            this.addMean();
        }
        this.setInfoForWeightedFunctionList();
    }

    public boolean isFuncAllowed(DiscretizedFuncAPI function) {
        int listSize = this.functionList.size();
        if (listSize != 0) {
            int numPoints = this.functionList.get(0).getNum();
            if (function.getNum() != numPoints) {
                return false;
            }
        }
        return true;
    }

    private void setFractileCurveCalcuations() {
        if (this.fractileCalc == null) {
            this.fractileCalc = new FractileCurveCalculator(this.functionList, this.relativeWts);
        } else {
            this.fractileCalc.set(this.functionList, this.relativeWts);
        }
    }

    public void addFractile(double fraction) {
        this.fractionList.add(new Double(fraction));
        this.setFractileCurveCalcuations();
        this.fractileList.add(this.fractileCalc.getFractile(fraction));
    }

    public void addFractiles(ArrayList list) {
        int size = list.size();
        this.fractileList.clear();
        this.fractionList.clear();
        this.setFractileCurveCalcuations();
        for (int i = 0; i < size; ++i) {
            this.fractionList.add(list.get(i));
            double fraction = (Double)list.get(i);
            this.fractileList.add(this.fractileCalc.getFractile(fraction));
        }
        this.setFractilesInfo();
    }

    public void addMean() {
        this.setFractileCurveCalcuations();
        this.meanFunction = this.fractileCalc.getMeanCurve();
        this.isMeanFractileCalculated = true;
        String meanInfo = "Mean\n";
        this.meanFunction.setInfo(meanInfo);
    }

    public DiscretizedFuncList getWeightedFunctionList() {
        return this.functionList;
    }

    public DiscretizedFuncList getFractileList() {
        if (this.fractileList.size() > 0) {
            return this.fractileList;
        }
        return null;
    }

    public ArrayList getFractileValuesList() {
        return this.fractionList;
    }

    public DiscretizedFuncAPI getMean() {
        if (this.isMeanFractileCalculated) {
            return this.meanFunction;
        }
        return null;
    }

    public ArrayList getRelativeWtList() {
        return this.relativeWts;
    }

    public int getNumWeightedFunctions() {
        return this.functionList.size();
    }

    public int getNumFractileFunctions() {
        return this.fractileList.size();
    }

    public void removeAllFractiles() {
        this.fractionList.clear();
        this.fractileList.clear();
    }

    public void removeMean() {
        if (this.isMeanFractileCalculated) {
            this.meanFunction = null;
            this.isMeanFractileCalculated = false;
        }
    }

    public void clearWeightedFunctionList() {
        this.relativeWts.clear();
        this.functionList.clear();
    }

    public boolean isMeanFunctionCalculated() {
        return this.isMeanFractileCalculated;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }

    private void setFractilesInfo() {
        String fractileInfo = "Fractiles: ";
        for (int i = 0; i < this.fractionList.size(); ++i) {
            fractileInfo = fractileInfo + (Double)this.fractionList.get(i) + ", ";
        }
        fractileInfo = fractileInfo.substring(0, fractileInfo.length() - 2) + "\n";
        this.fractileList.setInfo(fractileInfo);
        int size = this.fractileList.size();
    }

    public String getFractileInfo() {
        return this.fractileList.getInfo();
    }

    public String getFunctionTraceInfo() {
        return this.functionList.getInfo();
    }

    public String getMeanFunctionInfo() {
        return this.meanFunction.getInfo();
    }
}

