/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.region;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.region.EvenlyGriddedGeographicRegionAPI;
import org.opensha.data.region.GeographicRegion;

public class EvenlyGriddedGeographicRegion
extends GeographicRegion
implements EvenlyGriddedGeographicRegionAPI {
    private static final String C = "EvenlyGriddedGeographicRegion";
    private static final boolean D = false;
    protected double gridSpacing;
    protected double niceMinLat;
    protected double niceMinLon;
    protected double niceMaxLat;
    protected double niceMaxLon;
    protected LocationList gridLocsList;
    private int[] locsBelowLat;
    private ArrayList lonsPerLatList;

    public EvenlyGriddedGeographicRegion() {
    }

    public EvenlyGriddedGeographicRegion(LocationList locList, double gridSpacing) {
        this.createEvenlyGriddedGeographicRegion(locList, gridSpacing);
    }

    public EvenlyGriddedGeographicRegion(LocationList locList, double gridSpacing, EvenlyGriddedGeographicRegionAPI region) {
        this(locList, gridSpacing);
        this.createRegionLocationsList(region);
    }

    public LocationList createRegionLocationsList(EvenlyGriddedGeographicRegionAPI region) {
        int numLocations = this.getNumGridLocs();
        for (int i = 0; i < numLocations; ++i) {
            Location loc = this.getNearestGridLocation(i, region);
            this.gridLocsList.addLocation(loc);
        }
        return this.gridLocsList;
    }

    public void createEvenlyGriddedGeographicRegion(LocationList locList, double gridSpacing) {
        this.createGeographicRegion(locList);
        this.setGridSpacing(gridSpacing);
    }

    protected void initLatLonArray() {
        int numLats = (int)Math.rint((this.niceMaxLat - this.niceMinLat) / this.gridSpacing) + 1;
        this.locsBelowLat = new int[numLats + 1];
        this.lonsPerLatList = new ArrayList();
        int locBelowIndex = 0;
        this.locsBelowLat[locBelowIndex++] = 0;
        for (int iLat = 0; iLat < numLats; ++iLat) {
            double lat = this.niceMinLat + (double)iLat * this.gridSpacing;
            ArrayList<Double> lonList = new ArrayList<Double>();
            for (double lon = this.minLon; lon <= this.niceMaxLon; lon += this.gridSpacing) {
                Location loc = new Location(lat, lon);
                if (!this.isLocationInside(loc)) continue;
                lonList.add(new Double(lon));
            }
            this.locsBelowLat[locBelowIndex] = this.locsBelowLat[locBelowIndex - 1];
            int n = locBelowIndex++;
            this.locsBelowLat[n] = this.locsBelowLat[n] + lonList.size();
            this.lonsPerLatList.add(lonList);
        }
    }

    public void setGridSpacing(double degrees) {
        this.gridSpacing = degrees;
        this.niceMinLat = Math.ceil(this.minLat / this.gridSpacing) * this.gridSpacing;
        this.niceMinLon = Math.ceil(this.minLon / this.gridSpacing) * this.gridSpacing;
        this.niceMaxLat = Math.floor(this.maxLat / this.gridSpacing) * this.gridSpacing;
        this.niceMaxLon = Math.floor(this.maxLon / this.gridSpacing) * this.gridSpacing;
        this.initLatLonArray();
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public int getNumGridLocs() {
        if (this.gridLocsList != null) {
            return this.gridLocsList.size();
        }
        return this.locsBelowLat[this.locsBelowLat.length - 1];
    }

    public ListIterator getGridLocationsIterator() {
        if (this.gridLocsList == null) {
            this.createGriddedLocationList();
        }
        return this.gridLocsList.listIterator();
    }

    public LocationList getGridLocationsList() {
        if (this.gridLocsList == null) {
            this.createGriddedLocationList();
        }
        return this.gridLocsList;
    }

    public Location getGridLocationClone(int index) {
        int size = this.locsBelowLat.length;
        int locIndex = 0;
        int latIndex = 0;
        boolean locationFound = false;
        for (int i = 0; i < size - 1; ++i) {
            int locsIndex2 = this.locsBelowLat[i + 1];
            if (index >= locsIndex2) continue;
            locIndex = this.locsBelowLat[i];
            latIndex = i;
            locationFound = true;
            break;
        }
        if (!locationFound) {
            return null;
        }
        ArrayList lonList = (ArrayList)this.lonsPerLatList.get(latIndex);
        double lon = (Double)lonList.get(index - locIndex);
        double lat = this.niceMinLat + (double)latIndex * this.gridSpacing;
        return new Location(lat, lon);
    }

    public void clearRegionLocations() {
        if (this.gridLocsList != null) {
            this.gridLocsList.clear();
            this.gridLocsList = null;
        }
    }

    public Location getNearestGridLocation(int index, EvenlyGriddedGeographicRegionAPI region) {
        Location loc = this.getGridLocationClone(index);
        return region.getNearestLocation(loc);
    }

    public int getNearestGridLocationIndex(int index, EvenlyGriddedGeographicRegionAPI region) {
        Location loc = this.getGridLocationClone(index);
        return region.getNearestLocationIndex(loc);
    }

    public Location getGridLocation(int index) {
        if (index < 0 || index > this.getNumGridLocs() - 1) {
            return null;
        }
        LocationList locList = this.getGridLocationsList();
        Location loc = locList.getLocationAt(index);
        return loc;
    }

    public Location getNearestLocation(Location loc) {
        LocationList locList = this.getGridLocationsList();
        int index = 0;
        index = this.getNearestLocationIndex(loc);
        if (index < 0) {
            return null;
        }
        return locList.getLocationAt(index);
    }

    public Location getNearestLocationClone(Location loc) {
        double lat = Math.rint(loc.getLatitude() / this.gridSpacing) * this.gridSpacing;
        double lon = Math.rint(loc.getLongitude() / this.gridSpacing) * this.gridSpacing;
        if (!this.isLocationInside(loc)) {
            return null;
        }
        if (lat < this.niceMinLat) {
            lat = this.niceMinLat;
        } else if (lat > this.niceMaxLat) {
            lat = this.niceMaxLat;
        }
        if (lon < this.niceMinLon) {
            lon = this.niceMinLon;
        } else if (lon > this.niceMaxLon) {
            lon = this.niceMaxLon;
        }
        return new Location(lat, lon);
    }

    public int getNearestLocationIndex(Location loc) {
        double lat = loc.getLatitude();
        double lon = loc.getLongitude();
        if (!this.isLocationInside(loc)) {
            return -1;
        }
        if (lat < this.niceMinLat) {
            lat = this.niceMinLat;
        } else if (lat > this.niceMaxLat) {
            lat = this.niceMaxLat;
        }
        if (lon < this.niceMinLon) {
            lon = this.niceMinLon;
        } else if (lon > this.niceMaxLon) {
            lon = this.niceMaxLon;
        }
        int latIndex = (int)Math.rint((lat - this.niceMinLat) / this.gridSpacing);
        int locIndex = this.locsBelowLat[latIndex];
        ArrayList lonList = (ArrayList)this.lonsPerLatList.get(latIndex);
        int size = lonList.size();
        for (int i = 0; i < size; ++i) {
            double latLon = (Double)lonList.get(i);
            if (!(Math.abs(latLon - lon) <= this.gridSpacing / 2.0)) continue;
            locIndex += i;
            break;
        }
        return locIndex;
    }

    protected void createGriddedLocationList() {
        this.gridLocsList = new LocationList();
        int lonsPerLatSize = this.lonsPerLatList.size();
        double lat = this.niceMinLat;
        for (int i = 0; i < lonsPerLatSize; ++i) {
            ArrayList lonList = (ArrayList)this.lonsPerLatList.get(i);
            int numLons = lonList.size();
            for (int j = 0; j < numLons; ++j) {
                double lon = (Double)lonList.get(j);
                Location loc = new Location(lat, lon);
                this.gridLocsList.addLocation(loc);
            }
            lat += this.gridSpacing;
        }
    }

    public double getMinGridLat() {
        return this.niceMinLat;
    }

    public double getMaxGridLat() {
        return this.niceMaxLat;
    }

    public double getMinGridLon() {
        return this.niceMinLon;
    }

    public double getMaxGridLon() {
        return this.niceMaxLon;
    }

    public static void main(String[] args) {
        LocationList locList = new LocationList();
        locList.addLocation(new Location(37.19, -120.61, 0.0));
        locList.addLocation(new Location(36.43, -122.09, 0.0));
        locList.addLocation(new Location(38.23, -123.61, 0.0));
        locList.addLocation(new Location(39.02, -122.08, 0.0));
        EvenlyGriddedGeographicRegion gridReg = new EvenlyGriddedGeographicRegion(locList, 0.05);
        try {
            FileWriter fw = new FileWriter("GeoRegionFile.txt");
            ListIterator it = gridReg.getGridLocationsIterator();
            while (it.hasNext()) {
                Location loc = (Location)it.next();
                fw.write(loc.toString() + "\n");
            }
            fw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

