/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.region;

import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.region.EvenlyGriddedGeographicRegion;
import org.opensha.data.region.EvenlyGriddedGeographicRegionAPI;
import org.opensha.exceptions.RegionConstraintException;

public class EvenlyGriddedRectangularGeographicRegion
extends EvenlyGriddedGeographicRegion {
    private int numLatGridPoints;
    private int numLonGridPoints;
    private static final String C = "EvenlyGriddedRectangularGeographicRegion";
    private static final boolean D = false;

    public EvenlyGriddedRectangularGeographicRegion(double minLat, double maxLat, double minLon, double maxLon, double gridSpacing) throws RegionConstraintException {
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
        if (minLat > maxLat) {
            throw new RegionConstraintException("Min. Lat must be less then Max. Lat.\n");
        }
        if (minLon > maxLon) {
            throw new RegionConstraintException("Min. Lon must be less then Max. Lon.\n");
        }
        this.locList = new LocationList();
        this.locList.addLocation(new Location(minLat, minLon));
        this.locList.addLocation(new Location(minLat, maxLon));
        this.locList.addLocation(new Location(maxLat, maxLon));
        this.locList.addLocation(new Location(maxLat, minLon));
        this.createEvenlyGriddedGeographicRegion(this.locList, gridSpacing);
    }

    public EvenlyGriddedRectangularGeographicRegion(double minLat, double maxLat, double minLon, double maxLon, double gridSpacing, EvenlyGriddedGeographicRegionAPI region) throws RegionConstraintException {
        this(minLat, maxLat, minLon, maxLon, gridSpacing);
        this.createRegionLocationsList(region);
    }

    public void setGridSpacing(double gridSpacing) {
        this.gridSpacing = gridSpacing;
        this.niceMinLat = Math.ceil(this.minLat / gridSpacing) * gridSpacing;
        this.niceMinLon = Math.ceil(this.minLon / gridSpacing) * gridSpacing;
        this.niceMaxLat = Math.floor(this.maxLat / gridSpacing) * gridSpacing;
        this.niceMaxLon = Math.floor(this.maxLon / gridSpacing) * gridSpacing;
        this.numLatGridPoints = (int)Math.rint((this.niceMaxLat - this.niceMinLat) / gridSpacing) + 1;
        this.numLonGridPoints = (int)Math.rint((this.niceMaxLon - this.niceMinLon) / gridSpacing) + 1;
    }

    public int getNumGridLocs() {
        return this.numLatGridPoints * this.numLonGridPoints;
    }

    public boolean isLocationInside(Location location) {
        double tempLat = location.getLatitude();
        double tempLon = location.getLongitude();
        return tempLat >= this.minLat && tempLat < this.maxLat && tempLon >= this.minLon && tempLon < this.maxLon;
    }

    public int getNumGridLats() {
        return this.numLatGridPoints;
    }

    public int getNumGridLons() {
        return this.numLonGridPoints;
    }

    public Location getGridLocationClone(int index) {
        int row = index / this.numLonGridPoints;
        int col = index % this.numLonGridPoints;
        if (row > this.numLatGridPoints - 1 || col > this.numLonGridPoints - 1) {
            return null;
        }
        double newLat = this.niceMinLat + (double)row * this.gridSpacing;
        double newLon = this.niceMinLon + (double)col * this.gridSpacing;
        return new Location(newLat, newLon);
    }

    public int getNearestLocationIndex(Location loc) {
        double lat = loc.getLatitude();
        double lon = loc.getLongitude();
        if (!this.isLocationInside(loc)) {
            return -1;
        }
        if (lat < this.niceMinLat) {
            lat = this.niceMinLat;
        } else if (lat > this.niceMaxLat) {
            lat = this.niceMaxLat;
        }
        if (lon < this.niceMinLon) {
            lon = this.niceMinLon;
        } else if (lon > this.niceMaxLon) {
            lon = this.niceMaxLon;
        }
        int rowIndex = (int)Math.rint((lat - this.niceMinLat) / this.gridSpacing);
        int colIndex = (int)Math.rint((lon - this.niceMinLon) / this.gridSpacing);
        int index = rowIndex * this.numLonGridPoints + colIndex;
        return index;
    }

    protected void createGriddedLocationList() {
        this.gridLocsList = new LocationList();
        for (int iLat = 0; iLat < this.numLatGridPoints; ++iLat) {
            double lat = this.niceMinLat + this.gridSpacing * (double)iLat;
            for (int iLon = 0; iLon < this.numLonGridPoints; ++iLon) {
                double lon = this.niceMinLon + this.gridSpacing * (double)iLon;
                this.gridLocsList.addLocation(new Location(lat, lon));
            }
        }
    }

    public static void main(String[] args) {
        EvenlyGriddedGeographicRegion geoReg = null;
        try {
            geoReg = new EvenlyGriddedRectangularGeographicRegion(39.0, 39.99, 120.0, 121.0, 0.1);
            ListIterator lit = geoReg.getGridLocationsIterator();
            while (lit.hasNext()) {
                System.out.println((Location)lit.next());
            }
        }
        catch (RegionConstraintException ex) {
            // empty catch block
        }
        geoReg.getGridLocation(0);
        Location loc = null;
        long time = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            try {
                loc = geoReg.getGridLocation(-10);
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        System.out.println("time1 = " + (System.currentTimeMillis() - time));
    }
}

