/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.EditableException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DependentParameterAPI;
import org.opensha.param.Parameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.ParameterList;

public abstract class DependentParameter
extends Parameter
implements DependentParameterAPI {
    protected ArrayList independentParameters = new ArrayList();
    protected String metadataString;

    public DependentParameter() {
    }

    public DependentParameter(String name, ParameterConstraintAPI constraint, String units, Object value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    public ListIterator getIndependentParametersIterator() {
        return this.getIndependentParameterList().getParametersIterator();
    }

    public ParameterAPI getIndependentParameter(String name) throws ParameterException {
        int index = this.getIndexOf(name);
        if (index != -1) {
            ParameterAPI param = (ParameterAPI)this.independentParameters.get(index);
            return param;
        }
        String S = "Parameter: getParameter(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    private int getIndexOf(String paramName) {
        int size = this.independentParameters.size();
        for (int i = 0; i < size; ++i) {
            if (!((ParameterAPI)this.independentParameters.get(i)).getName().equals(paramName)) continue;
            return i;
        }
        return -1;
    }

    public String getIndependentParametersKey() {
        StringBuffer key = new StringBuffer(this.name);
        Iterator it = this.independentParameters.iterator();
        while (it.hasNext()) {
            Object value = ((ParameterAPI)it.next()).getValue();
            if (value == null) continue;
            key.append('/');
            key.append(value.toString());
        }
        return key.toString();
    }

    public boolean containsIndependentParameter(String paramName) {
        int index = this.getIndexOf(paramName);
        return index != -1;
    }

    public void setIndependentParameters(ParameterList list) throws ParameterException, EditableException {
        String S = "Parameter: setIndependentParameters(): ";
        this.checkEditable(S);
        this.independentParameters.clear();
        if (list != null) {
            ListIterator it = list.getParametersIterator();
            while (it.hasNext()) {
                ParameterAPI param = (ParameterAPI)it.next();
                this.independentParameters.add(param);
            }
        }
    }

    public String getDependentParamMetadataString() {
        if (this.independentParameters.size() > 0) {
            StringBuffer metadata = new StringBuffer();
            metadata.append(this.getName() + " [ ");
            ListIterator list = this.getIndependentParametersIterator();
            while (list.hasNext()) {
                ParameterAPI tempParam = (ParameterAPI)list.next();
                metadata.append(tempParam.getMetadataString() + " ; ");
            }
            metadata.replace(metadata.length() - 2, metadata.length(), " ]");
            this.metadataString = metadata.toString();
        }
        return this.metadataString;
    }

    public void setDependentParamMetadataString(String dependentParamMedataString) {
        this.metadataString = dependentParamMedataString;
    }

    public void addIndependentParameter(ParameterAPI parameter) throws ParameterException, EditableException {
        String S = "Parameter: addIndependentParameter(): ";
        this.checkEditable(S);
        String name = parameter.getName();
        int index = this.getIndexOf(name);
        if (index != -1) {
            throw new ParameterException(S + "A Parameter already exists named " + name);
        }
        this.independentParameters.add(parameter);
    }

    public void removeIndependentParameter(String name) throws ParameterException, EditableException {
        String S = "Parameter: removeIndependentParameter(): ";
        this.checkEditable(S);
        int index = this.getIndexOf(name);
        if (index == -1) {
            throw new ParameterException(S + "No Parameter exist named " + name + ", unable to remove");
        }
        this.independentParameters.remove(index);
    }

    public ParameterList getIndependentParameterList() {
        Iterator it = this.independentParameters.iterator();
        ParameterList list = new ParameterList();
        while (it.hasNext()) {
            ParameterAPI param = (ParameterAPI)it.next();
            list.addParameter(param);
        }
        return list;
    }
}

