/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import org.opensha.exceptions.EditableException;
import org.opensha.param.ParameterConstraint;

public class DoubleConstraint
extends ParameterConstraint {
    protected static final String C = "DoubleConstraint";
    protected static final boolean D = false;
    protected Double min = null;
    protected Double max = null;

    public DoubleConstraint() {
    }

    public DoubleConstraint(double min, double max) {
        this.min = new Double(min);
        this.max = new Double(max);
    }

    public DoubleConstraint(Double min, Double max) {
        this.min = min;
        this.max = max;
    }

    public void setMinMax(double min, double max) throws EditableException {
        String S = "DoubleConstraint: setMinMax(double, double): ";
        this.checkEditable(S);
        this.min = new Double(min);
        this.max = new Double(max);
    }

    public void setMinMax(Double min, Double max) throws EditableException {
        String S = "DoubleConstraint: setMinMax(Double, Double): ";
        this.checkEditable(S);
        this.min = min;
        this.max = max;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public boolean isAllowed(Object obj) {
        if (this.nullAllowed && obj == null) {
            return true;
        }
        if (!(obj instanceof Double)) {
            return false;
        }
        return this.isAllowed((Double)obj);
    }

    public boolean isAllowed(Double d) {
        if (this.nullAllowed && d == null) {
            return true;
        }
        if (this.min == null || this.max == null) {
            return true;
        }
        return d.compareTo(this.min) >= 0 && d.compareTo(this.max) <= 0;
    }

    public boolean isAllowed(double d) {
        return this.isAllowed(new Double(d));
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        if (this.name != null) {
            b.append(TAB + "Name = " + this.name + '\n');
        }
        if (this.min != null) {
            b.append(TAB + "Min = " + this.min.toString() + '\n');
        }
        if (this.max != null) {
            b.append(TAB + "Max = " + this.max.toString() + '\n');
        }
        b.append(TAB + "Null Allowed = " + this.nullAllowed + '\n');
        return b.toString();
    }

    public Object clone() {
        DoubleConstraint c1 = new DoubleConstraint(this.min, this.max);
        c1.setName(this.name);
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

