/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DependentParameter;
import org.opensha.param.DependentParameterAPI;
import org.opensha.param.IntegerConstraint;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;

public class IntegerParameter
extends DependentParameter
implements DependentParameterAPI,
ParameterAPI {
    protected static final String C = "IntegerParameter";
    protected static final boolean D = false;

    public IntegerParameter(String name) {
        super(name, null, null, null);
    }

    public IntegerParameter(String name, String units) throws ConstraintException {
        this(name, null, units, null);
    }

    public IntegerParameter(String name, int min, int max) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, int min, int max, String units) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, Integer min, Integer max) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, Integer min, Integer max, String units) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, IntegerConstraint constraint) throws ConstraintException {
        super(name, constraint, null, null);
    }

    public IntegerParameter(String name, IntegerConstraint constraint, String units) throws ConstraintException {
        super(name, constraint, units, null);
    }

    public IntegerParameter(String name, Integer value) {
        super(name, null, null, value);
    }

    public IntegerParameter(String name, String units, Integer value) throws ConstraintException {
        super(name, null, units, value);
    }

    public IntegerParameter(String name, int min, int max, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, value);
    }

    public IntegerParameter(String name, Integer min, Integer max, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, value);
    }

    public IntegerParameter(String name, IntegerConstraint constraint, Integer value) throws ConstraintException {
        super(name, constraint, null, value);
    }

    public IntegerParameter(String name, int min, int max, String units, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), units, value);
    }

    public IntegerParameter(String name, Integer min, Integer max, String units, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), units, value);
    }

    public IntegerParameter(String name, IntegerConstraint constraint, String units, Integer value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    public void setConstraint(ParameterConstraintAPI constraint) throws ParameterException {
        String S = "IntegerParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof IntegerConstraint)) {
            throw new ParameterException(S + "This parameter only accepts IntegerConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    public boolean isAllowed(Integer i) {
        return this.isAllowed((Object)i);
    }

    public boolean isAllowed(Object d) {
        if (d instanceof Integer || d == null) {
            return super.isAllowed(d);
        }
        return false;
    }

    public boolean isAllowed(int i) {
        return this.isAllowed(new Integer(i));
    }

    public Integer getMin() throws Exception {
        if (this.constraint != null) {
            return ((IntegerConstraint)this.constraint).getMin();
        }
        return null;
    }

    public Integer getMax() {
        if (this.constraint != null) {
            return ((IntegerConstraint)this.constraint).getMax();
        }
        return null;
    }

    public String getType() {
        String type = C;
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    public int compareTo(Object obj) throws ClassCastException {
        String S = "IntegerParameter:compareTo(): ";
        if (!(obj instanceof IntegerParameter)) {
            throw new ClassCastException(S + "Object not a IntegerParameter, unable to compare");
        }
        IntegerParameter param = (IntegerParameter)obj;
        boolean result = false;
        Integer n1 = (Integer)this.getValue();
        Integer n2 = (Integer)param.getValue();
        return n1.compareTo(n2);
    }

    public boolean equals(Object obj) throws ClassCastException {
        String S = "IntegerParameter:equals(): ";
        if (!(obj instanceof IntegerParameter)) {
            throw new ClassCastException(S + "Object not a IntegerParameter, unable to compare");
        }
        String otherName = ((IntegerParameter)obj).getName();
        return this.compareTo(obj) == 0 && this.getName().equals(otherName);
    }

    public Object clone() {
        IntegerConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (IntegerConstraint)this.constraint.clone();
        }
        IntegerParameter param = null;
        param = this.value == null ? new IntegerParameter(this.name, c1, this.units) : new IntegerParameter(this.name, c1, this.units, new Integer(this.value.toString()));
        if (param == null) {
            return null;
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }
}

