/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.EditableException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DependentParameter;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.DoubleParameter;
import org.opensha.param.LocationConstraint;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.ParameterListParameter;

public class LocationParameter
extends DependentParameter
implements Serializable {
    protected static final String C = "LocationParameter";
    protected static final boolean D = false;
    protected static final String PARAM_TYPE = "LocationParameter";
    protected ParameterListParameter locationParameterListParameter;
    protected ParameterAPI latParam;
    protected ParameterAPI lonParam;
    protected ParameterAPI depthParam;
    private Location location;
    private static final String LOCATION_PARAMETER_LIST_PARAMETER_NAME = "Location(lat,lon,depth)";
    private static final String LOCATION_WITHOUT_DEPTH_PARAMETER_LIST_PARAMETER_NAME = "Location(lat,lon)";
    private static final String DECIMAL_DEGREES = "Decimal Degrees";
    private static final String KMS = "kms";

    public LocationParameter(String name) {
        super(name, null, null, null);
    }

    public LocationParameter(String name, ArrayList locationList) throws ConstraintException {
        super(name, new LocationConstraint(locationList), null, locationList.get(0));
        this.location = (Location)locationList.get(0);
    }

    public LocationParameter(String name, ArrayList locationList, Location value) throws ConstraintException {
        super(name, new LocationConstraint(locationList), null, value);
        this.location = value;
    }

    public LocationParameter(String name, ArrayList locationList, String units, Location value) throws ConstraintException {
        super(name, new LocationConstraint(locationList), units, value);
        this.location = value;
    }

    public LocationParameter(String name, LocationConstraint locationListConstraint, String units, Location value) throws ConstraintException {
        super(name, locationListConstraint, units, value);
        this.location = value;
    }

    public LocationParameter(String name, LocationConstraint locationListConstraint) throws ConstraintException {
        super(name, locationListConstraint, null, locationListConstraint.getAllowedLocations().get(0));
        Location loc;
        this.location = loc = (Location)locationListConstraint.getAllowedLocations().get(0);
    }

    public LocationParameter(String name, LocationConstraint locationListConstraint, Location value) throws ConstraintException {
        super(name, locationListConstraint, null, value);
        this.location = value;
    }

    public LocationParameter(String locationParamName, String latParamName, String lonParamName, String depthParamName, DoubleConstraint latConstraint, DoubleConstraint lonConstraint, DoubleConstraint depthConstraint, String latUnits, String lonUnits, String depthUnits, Double latValue, Double lonValue, Double depthValue) {
        super(locationParamName, null, null, null);
        this.latParam = new DoubleParameter(latParamName, latConstraint, latUnits, latValue);
        this.lonParam = new DoubleParameter(lonParamName, lonConstraint, lonUnits, lonValue);
        this.depthParam = new DoubleParameter(depthParamName, depthConstraint, depthUnits, depthValue);
        ParameterList paramList = new ParameterList();
        paramList.addParameter(this.latParam);
        paramList.addParameter(this.lonParam);
        paramList.addParameter(this.depthParam);
        this.locationParameterListParameter = new ParameterListParameter(LOCATION_PARAMETER_LIST_PARAMETER_NAME, paramList);
        this.location = new Location((Double)this.latParam.getValue(), (Double)this.lonParam.getValue(), (Double)this.depthParam.getValue());
        this.setValue(this.location);
        this.setIndependentParameters(paramList);
    }

    public LocationParameter(String locationParamName, String latParamName, String lonParamName, String depthParamName, double minLat, double maxLat, double minLon, double maxLon, double minDepth, double maxDepth, String latUnits, String lonUnits, String depthUnits, Double latValue, Double lonValue, Double depthValue) {
        super(locationParamName, null, null, null);
        this.latParam = new DoubleParameter(latParamName, new DoubleConstraint(minLat, maxLat), latUnits, latValue);
        this.lonParam = new DoubleParameter(lonParamName, new DoubleConstraint(minLon, maxLon), lonUnits, lonValue);
        this.depthParam = new DoubleParameter(depthParamName, new DoubleConstraint(minDepth, maxDepth), depthUnits, depthValue);
        ParameterList paramList = new ParameterList();
        paramList.addParameter(this.latParam);
        paramList.addParameter(this.lonParam);
        paramList.addParameter(this.depthParam);
        this.locationParameterListParameter = new ParameterListParameter(LOCATION_PARAMETER_LIST_PARAMETER_NAME, paramList);
        this.location = new Location((Double)this.latParam.getValue(), (Double)this.lonParam.getValue(), (Double)this.depthParam.getValue());
        this.setValue(this.location);
        this.setIndependentParameters(paramList);
    }

    public LocationParameter(String locationParamName, String latParamName, String lonParamName, String depthParamName, String latUnits, String lonUnits, String depthUnits, Double latValue, Double lonValue, Double depthValue) {
        super(locationParamName, null, null, null);
        this.latParam = new DoubleParameter(latParamName, new DoubleConstraint(-90.0, 90.0), latUnits, latValue);
        this.lonParam = new DoubleParameter(lonParamName, new DoubleConstraint(-360.0, 360.0), lonUnits, lonValue);
        this.depthParam = new DoubleParameter(depthParamName, new DoubleConstraint(0.0, 50.0), depthUnits, depthValue);
        ParameterList paramList = new ParameterList();
        paramList.addParameter(this.latParam);
        paramList.addParameter(this.lonParam);
        paramList.addParameter(this.depthParam);
        this.locationParameterListParameter = new ParameterListParameter(LOCATION_PARAMETER_LIST_PARAMETER_NAME, paramList);
        this.location = new Location((Double)this.latParam.getValue(), (Double)this.lonParam.getValue(), (Double)this.depthParam.getValue());
        this.setValue(this.location);
        this.setIndependentParameters(paramList);
    }

    public LocationParameter(String locationParamName, String latParamName, String lonParamName, String depthParamName, Double latValue, Double lonValue, Double depthValue) {
        super(locationParamName, null, null, null);
        this.latParam = new DoubleParameter(latParamName, new DoubleConstraint(-90.0, 90.0), DECIMAL_DEGREES, latValue);
        this.lonParam = new DoubleParameter(lonParamName, new DoubleConstraint(-360.0, 360.0), DECIMAL_DEGREES, lonValue);
        this.depthParam = new DoubleParameter(depthParamName, new DoubleConstraint(0.0, 50.0), KMS, depthValue);
        ParameterList paramList = new ParameterList();
        paramList.addParameter(this.latParam);
        paramList.addParameter(this.lonParam);
        paramList.addParameter(this.depthParam);
        this.locationParameterListParameter = new ParameterListParameter(LOCATION_PARAMETER_LIST_PARAMETER_NAME, paramList);
        this.location = new Location((Double)this.latParam.getValue(), (Double)this.lonParam.getValue(), (Double)this.depthParam.getValue());
        this.setValue(this.location);
        this.setIndependentParameters(paramList);
    }

    public LocationParameter(String locationParamName, String latParamName, String lonParamName, String depthParamName, DoubleConstraint latConstraint, DoubleConstraint lonConstraint, DoubleConstraint depthConstraint, Double latValue, Double lonValue, Double depthValue) {
        super(locationParamName, null, null, null);
        this.latParam = new DoubleParameter(latParamName, latConstraint, DECIMAL_DEGREES, latValue);
        this.lonParam = new DoubleParameter(lonParamName, lonConstraint, DECIMAL_DEGREES, lonValue);
        this.depthParam = new DoubleParameter(depthParamName, depthConstraint, KMS, depthValue);
        ParameterList paramList = new ParameterList();
        paramList.addParameter(this.latParam);
        paramList.addParameter(this.lonParam);
        paramList.addParameter(this.depthParam);
        this.locationParameterListParameter = new ParameterListParameter(LOCATION_PARAMETER_LIST_PARAMETER_NAME, paramList);
        this.location = new Location((Double)this.latParam.getValue(), (Double)this.lonParam.getValue(), (Double)this.depthParam.getValue());
        this.setValue(this.location);
        this.setIndependentParameters(paramList);
    }

    public LocationParameter(String locationParamName, String latParamName, String lonParamName, String depthParamName, double minLat, double maxLat, double minLon, double maxLon, double minDepth, double maxDepth, Double latValue, Double lonValue, Double depthValue) {
        super(locationParamName, null, null, null);
        this.latParam = new DoubleParameter(latParamName, new DoubleConstraint(minLat, maxLat), DECIMAL_DEGREES, latValue);
        this.lonParam = new DoubleParameter(lonParamName, new DoubleConstraint(minLon, maxLon), DECIMAL_DEGREES, lonValue);
        this.depthParam = new DoubleParameter(depthParamName, new DoubleConstraint(minDepth, maxDepth), KMS, depthValue);
        ParameterList paramList = new ParameterList();
        paramList.addParameter(this.latParam);
        paramList.addParameter(this.lonParam);
        paramList.addParameter(this.depthParam);
        this.locationParameterListParameter = new ParameterListParameter(LOCATION_PARAMETER_LIST_PARAMETER_NAME, paramList);
        this.location = new Location((Double)this.latParam.getValue(), (Double)this.lonParam.getValue(), (Double)this.depthParam.getValue());
        this.setValue(this.location);
        this.setIndependentParameters(paramList);
    }

    public LocationParameter(String name, ParameterList paramList, Location loc) {
        super(name, null, null, null);
        this.locationParameterListParameter = paramList.size() == 3 ? new ParameterListParameter(LOCATION_PARAMETER_LIST_PARAMETER_NAME, paramList) : new ParameterListParameter(LOCATION_WITHOUT_DEPTH_PARAMETER_LIST_PARAMETER_NAME, paramList);
        this.location = loc;
        this.setValue(this.location);
        this.setIndependentParameters(paramList);
    }

    public ParameterAPI getLocationParameter() {
        if (this.constraint == null) {
            return this.locationParameterListParameter;
        }
        return this;
    }

    public void setConstraint(ParameterConstraintAPI constraint) throws ParameterException, EditableException {
        String S = "LocationParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof LocationConstraint)) {
            throw new ParameterException(S + "This parameter only accepts LocationConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    public void setValue(Location loc) {
        this.location = loc;
        this.setValue((Object)loc);
    }

    public double getLatitude() {
        if (this.constraint != null) {
            return this.location.getLatitude();
        }
        return (Double)this.latParam.getValue();
    }

    public double getLongitude() {
        if (this.constraint != null) {
            return this.location.getLongitude();
        }
        return (Double)this.lonParam.getValue();
    }

    public double getDepth() {
        if (this.constraint != null) {
            return this.location.getDepth();
        }
        return (Double)this.depthParam.getValue();
    }

    public ArrayList getAllowedLocations() {
        return ((LocationConstraint)this.constraint).getAllowedLocations();
    }

    public int compareTo(Object obj) {
        String S = "LocationParameter:compareTo(): ";
        if (!(obj instanceof LocationParameter)) {
            throw new ClassCastException(S + "Object not a LocationParameter, unable to compare");
        }
        LocationParameter param = (LocationParameter)obj;
        if (this.value == null && param.value == null) {
            return 0;
        }
        boolean result = false;
        LocationParameter n1 = (LocationParameter)this.getValue();
        LocationParameter n2 = (LocationParameter)param.getValue();
        return n1.compareTo(n2);
    }

    public boolean equals(Object obj) {
        String S = "LocationParameter:equals(): ";
        if (!(obj instanceof LocationParameter)) {
            throw new ClassCastException(S + "Object not a LocationParameter, unable to compare");
        }
        String otherName = ((LocationParameter)obj).getName();
        return this.compareTo(obj) == 0 && this.getName().equals(otherName);
    }

    public Object clone() {
        LocationConstraint c1 = null;
        LocationParameter param = null;
        if (this.constraint != null) {
            c1 = (LocationConstraint)this.constraint.clone();
            param = new LocationParameter(this.name, c1, (Location)this.value);
        } else {
            param = this.value != null ? new LocationParameter(this.name, (ParameterList)this.locationParameterListParameter.getValue(), (Location)this.value) : new LocationParameter(this.name);
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }

    public ListIterator getParametersIterator() {
        return ((ParameterList)this.getValue()).getParametersIterator();
    }

    public ParameterList getParameter() {
        return (ParameterList)this.getValue();
    }

    public String getType() {
        String type = this.constraint != null ? "ConstrainedLocationParameter" : "LocationParameter";
        return type;
    }

    public String getMetadataString() {
        if (this.constraint == null) {
            return this.getDependentParamMetadataString();
        }
        return super.getMetadataString();
    }
}

