/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.util.ArrayList;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.EditableException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.StringListConstraint;
import org.opensha.param.StringParameter;

public class StringListParameter
extends StringParameter {
    protected static final String C = "StringListParameter";

    public StringListParameter(String name) {
        super(name);
    }

    public StringListParameter(String name, ArrayList strings) throws ConstraintException {
        this(name, new StringListConstraint(strings), null, null);
    }

    public StringListParameter(String name, StringListConstraint constraint) throws ConstraintException {
        this(name, constraint, null, null);
    }

    public StringListParameter(String name, String units, ArrayList values) throws ConstraintException {
        this(name, null, units, values);
    }

    public StringListParameter(String name, ArrayList strings, ArrayList values) throws ConstraintException {
        this(name, new StringListConstraint(strings), null, values);
    }

    public StringListParameter(String name, StringListConstraint constraint, ArrayList values) throws ConstraintException {
        this(name, constraint, null, values);
    }

    public StringListParameter(String name, StringListConstraint constraint, String units, ArrayList values) throws ConstraintException {
        super(name, constraint, units);
        this.value = values;
    }

    public void setConstraint(ParameterConstraintAPI constraint) throws ParameterException, EditableException {
        String S = "StringListParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof StringListConstraint)) {
            throw new ParameterException(S + "This parameter only accepts StringConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    public String getType() {
        String type = C;
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    public int compareTo(Object obj) throws ClassCastException {
        ArrayList n2;
        String S = "StringListParameter:compareTo(): ";
        if (!(obj instanceof StringListParameter)) {
            throw new ClassCastException(S + "Object not a StringListParameter, unable to compare");
        }
        StringListParameter param = (StringListParameter)obj;
        if (this.value == null && param.value == null) {
            return 0;
        }
        boolean result = false;
        ArrayList n1 = (ArrayList)this.getValue();
        if (n1.containsAll(n2 = (ArrayList)param.getValue()) && n2.containsAll(n1)) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object obj) throws ClassCastException {
        String S = "StringListParameter:equals(): ";
        if (!(obj instanceof StringListParameter)) {
            throw new ClassCastException(S + "Object not a StringListParameter, unable to compare");
        }
        String otherName = ((StringListParameter)obj).getName();
        return this.compareTo(obj) == 0 && this.getName().equals(otherName);
    }

    public Object clone() {
        StringListConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (StringListConstraint)this.constraint.clone();
        }
        StringListParameter param = null;
        if (this.value == null) {
            param = new StringListParameter(this.name, c1);
            param.setUnits(this.units);
        } else {
            param = new StringListParameter(this.name, c1, this.units, (ArrayList)((ArrayList)this.value).clone());
        }
        if (param == null) {
            return null;
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }
}

