/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensha.exceptions.ConstraintException;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.StringListConstraint;
import org.opensha.param.StringListParameter;
import org.opensha.param.editor.ParameterEditor;

public class ConstrainedStringListParameterEditor
extends ParameterEditor
implements ListSelectionListener {
    protected static final String C = "ConstrainedStringListParameterEditor";
    protected static final boolean D = false;

    public ConstrainedStringListParameterEditor() {
        String S = "ConstrainedStringListParameterEditor: Constructor(): ";
    }

    public ConstrainedStringListParameterEditor(ParameterAPI model) throws ConstraintException {
        super(model);
        String S = "ConstrainedStringListParameterEditor: Constructor(model): ";
    }

    public void setParameter(ParameterAPI model) {
        String S = "ConstrainedStringListParameterEditor: setParameter(): ";
        this.verifyModel(model);
        this.model = model;
        String name = model.getName();
        Object value = model.getValue();
        this.removeWidget();
        this.addWidget();
        this.setWidgetObject(name, value);
    }

    private void verifyModel(ParameterAPI model) throws ConstraintException {
        String S = "ConstrainedStringListParameterEditor: Constructor(model): ";
        if (model == null) {
            throw new NullPointerException(S + "Input Parameter model cannot be null");
        }
        if (!(model instanceof StringListParameter)) {
            throw new ConstraintException(S + "Input model parameter must be a StringListParameter.");
        }
        ParameterConstraintAPI constraint = model.getConstraint();
        if (!(constraint instanceof StringListConstraint)) {
            throw new ConstraintException(S + "Input model constraints must be a StringListConstraint.");
        }
        int numConstriants = ((StringListConstraint)constraint).size();
        if (numConstriants < 1) {
            throw new ConstraintException(S + "There are no constraints present, unable to build editor selection list.");
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    protected void setWidgetObject(String name, Object obj) {
        String S = "ConstrainedStringListParameterEditor: setWidgetObject(): ";
        super.setWidgetObject(name, obj);
        if (obj != null && this.valueEditor != null && this.valueEditor instanceof JList) {
            this.setSelectedItems((ArrayList)obj);
        }
    }

    protected void addWidget() {
        String S = "ConstrainedStringListParameterEditor: addWidget(): ";
        if (this.model != null) {
            StringListConstraint con = (StringListConstraint)((StringListParameter)this.model).getConstraint();
            ListIterator it = con.listIterator();
            Vector<String> strs = new Vector<String>();
            while (it.hasNext()) {
                String str = it.next().toString();
                if (strs.contains(str)) continue;
                strs.add(str);
            }
            this.valueEditor = new JList(strs);
            this.valueEditor.setFont(DEFAULT_FONT);
            JScrollPane scrollPane = new JScrollPane(this.valueEditor);
            scrollPane.setPreferredSize(JLIST_DIM);
            scrollPane.setMinimumSize(JLIST_DIM);
            this.widgetPanel.setPreferredSize(JLIST_DIM);
            this.widgetPanel.setMinimumSize(JLIST_DIM);
            ((JList)this.valueEditor).addListSelectionListener(this);
            this.widgetPanel.add((Component)scrollPane, WIDGET_GBC);
            this.widgetPanel.setBackground(null);
            this.widgetPanel.validate();
            this.widgetPanel.repaint();
        }
    }

    public void refreshParamEditor() {
        ArrayList list;
        if (this.valueEditor instanceof JList && (list = (ArrayList)this.model.getValue()) != null) {
            this.setSelectedItems(list);
        }
    }

    private void setSelectedItems(ArrayList selectItemsList) {
        int size = selectItemsList.size();
        StringListConstraint stringListConstraint = (StringListConstraint)this.model.getConstraint();
        ArrayList allowedVals = stringListConstraint.getAllowedValues();
        int[] selectedIndices = new int[size];
        for (int i = 0; i < size; ++i) {
            int index = allowedVals.indexOf(selectItemsList.get(i));
            if (index >= 0) {
                selectedIndices[i] = index;
                continue;
            }
            new ConstraintException(selectItemsList.get(i).toString() + " is not allowed");
        }
        ((JList)this.valueEditor).setSelectedIndices(selectedIndices);
    }

    public void valueChanged(ListSelectionEvent event) {
        int[] selectedIndices = ((JList)this.valueEditor).getSelectedIndices();
        ListModel listModel = ((JList)this.valueEditor).getModel();
        ArrayList list = new ArrayList();
        for (int i = 0; i < selectedIndices.length; ++i) {
            list.add(listModel.getElementAt(selectedIndices[i]));
        }
        this.model.setValue(list);
    }
}

