/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import org.opensha.data.ValueWeight;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.DoubleParameter;
import org.opensha.param.DoubleValueWeightConstraint;
import org.opensha.param.ParameterAPI;
import org.opensha.param.editor.ParameterEditor;
import org.opensha.param.editor.ParameterEditorFactory;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeListener;

public class DoubleValueWeightParameterEditor
extends ParameterEditor
implements ParameterChangeListener {
    private static final boolean D = false;
    private static final String VALUE = "Value";
    private static final String WEIGHT = "Weight";
    protected DoubleParameter valueParameter;
    protected DoubleParameter weightParameter;
    private ParameterEditor valueParameterEditor;
    private ParameterEditor weightParameterEditor;
    protected static final Dimension PANEL_DIM = new Dimension(100, 50);

    public DoubleValueWeightParameterEditor() {
    }

    public DoubleValueWeightParameterEditor(ParameterAPI model) throws Exception {
        super(model);
    }

    public void setParameter(ParameterAPI model) {
        this.model = model;
        this.createValueAndWeightParams();
        this.createParamEditors();
        this.setLayout(GBL);
        this.titledBorder1.setTitle(model.getName());
        this.widgetPanel.add((Component)this.valueParameterEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.widgetPanel.add((Component)this.weightParameterEditor, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.widgetPanel.setMinimumSize(PANEL_DIM);
        this.widgetPanel.setPreferredSize(PANEL_DIM);
    }

    private void createParamEditors() {
        try {
            this.valueParameterEditor = ParameterEditorFactory.getEditor(this.valueParameter);
            this.weightParameterEditor = ParameterEditorFactory.getEditor(this.weightParameter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEnabled(boolean isEnabled) {
        this.valueParameterEditor.setEnabled(isEnabled);
        this.weightParameterEditor.setEnabled(isEnabled);
    }

    private void createValueAndWeightParams() {
        DoubleValueWeightConstraint constraint = (DoubleValueWeightConstraint)this.model.getConstraint();
        DoubleConstraint valConstraint = null;
        DoubleConstraint weightConstraint = null;
        if (constraint != null) {
            valConstraint = new DoubleConstraint(constraint.getMinVal(), constraint.getMaxVal());
            valConstraint.setNullAllowed(true);
            weightConstraint = new DoubleConstraint(constraint.getMinWt(), constraint.getMaxWt());
            weightConstraint.setNullAllowed(true);
        }
        this.valueParameter = new DoubleParameter(VALUE, valConstraint, this.model.getUnits());
        this.valueParameter.addParameterChangeListener(this);
        this.weightParameter = new DoubleParameter(WEIGHT, weightConstraint);
        this.weightParameter.addParameterChangeListener(this);
        ValueWeight valueWeight = (ValueWeight)this.model.getValue();
        if (valueWeight != null) {
            this.valueParameter.setValue(valueWeight.getValue());
            this.weightParameter.setValue(valueWeight.getWeight());
        }
    }

    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        ValueWeight oldValueWeight = (ValueWeight)this.model.getValue();
        ValueWeight valueWeight = oldValueWeight == null ? new ValueWeight() : (ValueWeight)oldValueWeight.clone();
        if (paramName.equalsIgnoreCase(VALUE)) {
            Double value = (Double)this.valueParameter.getValue();
            if (value == null) {
                value = new Double(Double.NaN);
            }
            valueWeight.setValue(value);
        } else if (paramName.equalsIgnoreCase(WEIGHT)) {
            Double weight = (Double)this.weightParameter.getValue();
            if (weight == null) {
                weight = new Double(Double.NaN);
            }
            valueWeight.setWeight(weight);
        }
        this.model.setValue(valueWeight);
    }
}

