/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.opensha.gui.LabeledBoxPanel;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.editor.ParameterEditor;
import org.opensha.param.editor.ParameterEditorAPI;
import org.opensha.param.editor.ParameterEditorFactory;

public class ParameterListEditor
extends LabeledBoxPanel {
    protected static final String C = "ParameterListEditor";
    protected static final boolean D = false;
    protected ParameterList parameterList;
    protected ArrayList parameterEditors = new ArrayList();
    protected ArrayList parametersName = new ArrayList();
    protected String[] searchPaths;

    public ParameterListEditor() {
        this.makeSearchPaths();
        this.setLayout(new GridBagLayout());
    }

    private void makeSearchPaths() {
        this.searchPaths = new String[3];
        this.searchPaths[0] = ParameterListEditor.getDefaultSearchPath();
        this.searchPaths[1] = "org.opensha.sha.param.editor";
        this.searchPaths[2] = "org.opensha.param.editor.estimate";
    }

    public ParameterListEditor(ParameterList paramList) {
        this.parameterList = paramList;
        this.makeSearchPaths();
        this.addParameters();
    }

    public ParameterListEditor(ParameterList paramList, String[] searchPaths) {
        this.parameterList = paramList;
        this.searchPaths = searchPaths;
        this.setLayout(new GridBagLayout());
        this.addParameters();
    }

    public void setParameterList(ParameterList paramList) {
        this.parameterList = paramList;
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public void setParameterVisible(String parameterName, boolean visible) {
        int index = this.getIndexOf(parameterName = this.parameterList.getParameterName(parameterName));
        if (index != -1) {
            ParameterEditor editor = (ParameterEditor)this.parameterEditors.get(index);
            editor.setVisible(visible);
        }
    }

    public void setEnabled(boolean isEnabled) {
        for (int i = 0; i < this.parameterEditors.size(); ++i) {
            ((ParameterEditor)this.parameterEditors.get(i)).setEnabled(isEnabled);
        }
    }

    private int getIndexOf(String paramName) {
        int size = this.parametersName.size();
        for (int i = 0; i < size; ++i) {
            if (!((String)this.parametersName.get(i)).equals(paramName)) continue;
            return i;
        }
        return -1;
    }

    public static String getDefaultSearchPath() {
        return "org.opensha.param.editor";
    }

    public ParameterList getVisibleParameters() {
        ParameterList visibles = new ParameterList();
        Iterator it = this.parameterEditors.iterator();
        while (it.hasNext()) {
            ParameterEditor editor = (ParameterEditor)it.next();
            if (!editor.isVisible()) continue;
            ParameterAPI param = editor.getParameter();
            visibles.addParameter(param);
        }
        return visibles;
    }

    public ParameterList getVisibleParametersCloned() {
        return (ParameterList)this.getVisibleParameters().clone();
    }

    public ParameterEditor getParameterEditor(String parameterName) throws NoSuchElementException {
        int index = this.getIndexOf(parameterName = this.parameterList.getParameterName(parameterName));
        if (index != -1) {
            ParameterEditor editor = (ParameterEditor)this.parameterEditors.get(index);
            return editor;
        }
        throw new NoSuchElementException("No ParameterEditor exist named " + parameterName);
    }

    public void refreshParamEditor() {
        Iterator it = this.parameterEditors.iterator();
        while (it.hasNext()) {
            ParameterEditorAPI editor = (ParameterEditorAPI)it.next();
            editor.refreshParamEditor();
        }
    }

    public void replaceParameterForEditor(String parameterName, ParameterAPI param) {
        int index = this.getIndexOf(parameterName = this.parameterList.getParameterName(parameterName));
        if (index != -1) {
            ParameterEditor editor = (ParameterEditor)this.parameterEditors.get(index);
            editor.setParameter(param);
            this.parameterList.removeParameter(parameterName);
            this.parameterList.addParameter(param);
        }
    }

    protected void addParameters() {
        if (this.parameterList == null) {
            return;
        }
        ListIterator it = this.parameterList.getParameterNamesIterator();
        int counter = 0;
        if (this.searchPaths != null || this.searchPaths.length > 0) {
            ParameterEditorFactory.setSearchPaths(this.searchPaths);
        }
        this.parameterEditors.clear();
        this.editorPanel.setLayout(GBL);
        while (it.hasNext()) {
            Object obj1 = it.next();
            String name = (String)obj1;
            ParameterAPI param = this.parameterList.getParameter(name);
            ParameterEditor panel = ParameterEditorFactory.getEditor(param);
            this.parametersName.add(counter, name);
            this.parameterEditors.add(counter, panel);
            this.editorPanel.add(panel);
            this.editorPanel.add((Component)panel, new GridBagConstraints(0, counter, 0, 1, 1.0, 1.0, 11, 2, new Insets(4, 4, 4, 4), 0, 0));
            ++counter;
        }
    }
}

