/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.data.ValueWeight;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.DoubleDiscreteConstraint;
import org.opensha.param.DoubleDiscreteParameter;
import org.opensha.param.DoubleParameter;
import org.opensha.param.DoubleValueWeightParameter;
import org.opensha.param.IntegerConstraint;
import org.opensha.param.IntegerParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.ParameterListParameter;
import org.opensha.param.StringConstraint;
import org.opensha.param.StringParameter;
import org.opensha.param.WarningDoubleParameter;
import org.opensha.param.WarningIntegerParameter;
import org.opensha.param.editor.ParameterListEditor;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeFailEvent;
import org.opensha.param.event.ParameterChangeFailListener;
import org.opensha.param.event.ParameterChangeListener;
import org.opensha.param.event.ParameterChangeWarningEvent;
import org.opensha.param.event.ParameterChangeWarningListener;
import org.opensha.sha.param.SimpleFaultParameter;

public class ParameterApplet
extends JApplet
implements ParameterChangeListener,
ParameterChangeFailListener,
ParameterChangeWarningListener {
    protected static final String C = "ParameterApplet";
    protected static final boolean D = true;
    static final int NUM = 6;
    static int paramCount = 0;
    boolean isStandalone = false;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel statusLabel = new JLabel();
    JLabel mainTitleLabel = new JLabel();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    public String[] searchPaths;
    static final String SPECIAL_EDITORS_PACKAGE = "org.opensha.sha.propagation";

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setBackground(Color.white);
        this.setSize(new Dimension(400, 300));
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setMinimumSize(new Dimension(100, 300));
        this.jPanel1.setPreferredSize(new Dimension(100, 300));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.mainTitleLabel.setBackground(Color.white);
        this.mainTitleLabel.setFont(new Font("Dialog", 1, 14));
        this.mainTitleLabel.setBorder(BorderFactory.createEtchedBorder());
        this.mainTitleLabel.setHorizontalAlignment(0);
        this.mainTitleLabel.setText("Parameter Editor Applet");
        this.jPanel2.setBackground(Color.white);
        this.jPanel2.setFont(new Font("Dialog", 0, 10));
        this.jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.statusLabel.setFont(new Font("Dialog", 1, 10));
        this.statusLabel.setForeground(Color.black);
        this.statusLabel.setText("Status");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.mainTitleLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        ParameterList list = this.makeParameterList(5);
        this.searchPaths = new String[3];
        this.searchPaths[0] = ParameterListEditor.getDefaultSearchPath();
        this.searchPaths[1] = SPECIAL_EDITORS_PACKAGE;
        this.searchPaths[2] = "org.opensha.sha.param.editor";
        ParameterListEditor editor = new ParameterListEditor(list, this.searchPaths);
        this.jPanel1.add((Component)editor, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
    }

    private ParameterList makeParameterList(int number) {
        ArrayList<String> val = new ArrayList<String>();
        val.add("Steven");
        val.add("William");
        val.add("Michael");
        StringConstraint constraint = new StringConstraint(val);
        ParameterList list = new ParameterList();
        list.addParameter(this.makeConstrainedStringParameter(constraint));
        list.addParameter(this.makeStringParameter());
        list.addParameter(this.makeConstrainedStringParameter(constraint));
        list.addParameter(this.makeDoubleParameter());
        list.addParameter(this.makeIntegerParameter());
        list.addParameter(this.makeConstrainedIntegerParameter());
        list.addParameter(this.makeConstrainedDoubleDiscreteParameter());
        list.addParameter(this.makeWarningDoubleParameter());
        list.addParameter(this.makeWarningIntegerParameter());
        list.addParameter(this.makeEvenlyGriddedsurfaceParameter());
        for (int i = 3; i < number; ++i) {
            list.addParameter(this.makeStringParameter());
        }
        list.addParameter(this.makeParameterListParameter());
        list.addParameter(this.makeDoubleValueWeightParameter());
        return list;
    }

    private ParameterAPI makeDoubleValueWeightParameter() {
        String name = "Name " + paramCount;
        ++paramCount;
        DoubleValueWeightParameter param = new DoubleValueWeightParameter(name, 0.0, 1.0, 0.0, 1000.0, "mm/yr", new ValueWeight(0.5, 99.9));
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private ParameterAPI makeParameterListParameter() {
        DoubleParameter param1 = new DoubleParameter("param1", new Double(0.01));
        DoubleParameter param2 = new DoubleParameter("param2", new Double(0.02));
        ParameterList paramList = new ParameterList();
        paramList.addParameter(param1);
        paramList.addParameter(param2);
        ParameterListParameter param = new ParameterListParameter("New Param", paramList);
        return param;
    }

    private ParameterAPI makeConstrainedDoubleDiscreteParameter() {
        String name = "Name " + paramCount;
        String value = "12.1";
        ++paramCount;
        ArrayList<Double> val = new ArrayList<Double>();
        val.add(new Double(11.1));
        val.add(new Double(12.1));
        val.add(new Double(13.1));
        DoubleDiscreteConstraint constraint = new DoubleDiscreteConstraint(val);
        DoubleDiscreteParameter param = new DoubleDiscreteParameter(name, constraint, "sec.", new Double(12.1));
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private ParameterAPI makeIntegerParameter() {
        String name = "Name " + paramCount;
        String value = "1" + paramCount;
        ++paramCount;
        IntegerParameter param = new IntegerParameter(name, new Integer(value));
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private ParameterAPI makeEvenlyGriddedsurfaceParameter() {
        String name = "Name " + paramCount;
        SimpleFaultParameter param = new SimpleFaultParameter(name, null);
        ++paramCount;
        return param;
    }

    private ParameterAPI makeConstrainedIntegerParameter() {
        String name = "Name " + paramCount;
        String value = "1" + paramCount;
        ++paramCount;
        IntegerConstraint constraint = new IntegerConstraint(-180, 180);
        IntegerParameter param = new IntegerParameter(name, constraint, "degrees", new Integer(value));
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private ParameterAPI makeWarningIntegerParameter() {
        String name = "Name " + paramCount;
        String value = "1" + paramCount;
        ++paramCount;
        IntegerConstraint constraint = new IntegerConstraint(-200, 200);
        IntegerConstraint warnConstraint = new IntegerConstraint(-100, 100);
        WarningIntegerParameter param = new WarningIntegerParameter(name, constraint, "degrees", new Integer(value));
        param.setWarningConstraint(warnConstraint);
        param.addParameterChangeWarningListener(this);
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private ParameterAPI makeWarningDoubleParameter() {
        String name = "Name " + paramCount;
        String value = "1" + paramCount;
        ++paramCount;
        DoubleConstraint constraint = new DoubleConstraint(-120.0, 120.0);
        DoubleConstraint warn = new DoubleConstraint(-60.0, 60.0);
        WarningDoubleParameter param = new WarningDoubleParameter(name, constraint, "degrees", new Double(value));
        param.setWarningConstraint(warn);
        param.addParameterChangeWarningListener(this);
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private ParameterAPI makeDoubleParameter() {
        String name = "Name " + paramCount;
        String value = "12." + paramCount;
        ++paramCount;
        DoubleConstraint constraint = new DoubleConstraint(0.0, 20.0);
        DoubleParameter param = new DoubleParameter(name, constraint, "acres", new Double(value));
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private ParameterAPI makeStringParameter() {
        String name = "Name " + paramCount;
        String value = "Value " + paramCount;
        ++paramCount;
        StringParameter param = new StringParameter(name, value);
        param.addParameterChangeListener(this);
        return param;
    }

    private ParameterAPI makeConstrainedStringParameter(StringConstraint constraint) {
        String name = "Name " + paramCount;
        String value = "Value " + paramCount;
        ++paramCount;
        StringParameter param = new StringParameter(name, constraint, null, "William");
        param.addParameterChangeListener(this);
        return param;
    }

    public void parameterChange(ParameterChangeEvent event) {
        String S = "ParameterApplet: parameterChange(): ";
        System.out.println(S + "starting: ");
        String name1 = event.getParameterName();
        String old1 = event.getOldValue().toString();
        String str1 = event.getNewValue().toString();
        String msg = "Status: " + name1 + " changed from " + old1 + " to " + str1;
        System.out.println(msg);
        this.statusLabel.setText(msg);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        Double d1 = new Double(1.0);
        Double d2 = new Double(Double.NaN);
        Object d3 = null;
        ParameterApplet applet = new ParameterApplet();
        applet.isStandalone = true;
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Applet Frame");
        frame.getContentPane().add((Component)applet, "Center");
        applet.init();
        applet.start();
        frame.setSize(400, 320);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        StringBuffer b = new StringBuffer();
        b.append('\"');
        b.append(e.getParameterName());
        b.append('\"');
        b.append(" doesn't allow the value: ");
        b.append(e.getBadValue().toString());
        b.append(". \nChoose within constraints:\n");
        b.append(((ParameterAPI)e.getSource()).getConstraint().toString());
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        StringBuffer b = new StringBuffer();
        try {
            Number max;
            Number min;
            if (e.getWarningParameter().getWarningMin() instanceof Double) {
                min = (Double)e.getWarningParameter().getWarningMin();
                max = (Double)e.getWarningParameter().getWarningMax();
            } else {
                min = (Integer)e.getWarningParameter().getWarningMin();
                max = (Integer)e.getWarningParameter().getWarningMax();
            }
            String name = e.getWarningParameter().getName();
            b.append("You have exceeded the recommended range for ");
            b.append(name);
            b.append(": (");
            b.append(min.toString());
            b.append(" to ");
            b.append(max.toString());
            b.append(")\n");
            b.append("Click Yes to accept the new value: ");
            b.append(e.getNewValue().toString());
            JOptionPane.showMessageDialog(this, b.toString(), "Exceeded Recommended Values", 0);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

