/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor.document;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumericPlainDocument
extends PlainDocument {
    protected static final String C = "NumericPlainDocument";
    protected static final boolean D = false;
    protected InsertErrorListener errorListener;
    protected static DecimalFormat defaultFormat = new DecimalFormat();
    protected DecimalFormat format;
    protected char decimalSeparator;
    protected char groupingSeparator;
    protected String positivePrefix;
    protected int positivePrefixLen;
    protected String positiveSuffix;
    protected int positiveSuffixLen;
    protected String negativePrefix;
    protected int negativePrefixLen;
    protected String negativeSuffix;
    protected int negativeSuffixLen;
    protected ParsePosition parsePos;

    public NumericPlainDocument() {
        this.parsePos = new ParsePosition(0);
        this.setFormat(null);
    }

    public NumericPlainDocument(DecimalFormat format) {
        this.parsePos = new ParsePosition(0);
        this.setFormat(format);
    }

    public NumericPlainDocument(AbstractDocument.Content content, DecimalFormat format) {
        super(content);
        String S = "NumericPlainDocument: Constructor(content, format): ";
        this.parsePos = new ParsePosition(0);
        this.setFormat(format);
        try {
            format.parseObject(content.getString(0, content.length()), this.parsePos);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(S + "Initial context not a valid number");
        }
        if (this.parsePos.getIndex() != content.length() - 1) {
            throw new IllegalArgumentException(S + "Initial context not a valid number");
        }
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public void setFormat(DecimalFormat fmt) {
        this.format = fmt != null ? fmt : (DecimalFormat)defaultFormat.clone();
        this.decimalSeparator = this.format.getDecimalFormatSymbols().getDecimalSeparator();
        this.groupingSeparator = this.format.getDecimalFormatSymbols().getGroupingSeparator();
        this.positivePrefix = this.format.getPositivePrefix();
        this.positivePrefixLen = this.positivePrefix.length();
        this.positiveSuffix = this.format.getPositiveSuffix();
        this.positiveSuffixLen = this.positiveSuffix.length();
        this.negativePrefix = this.format.getNegativePrefix();
        this.negativePrefixLen = this.negativePrefix.length();
        this.negativeSuffix = this.format.getNegativeSuffix();
        this.negativeSuffixLen = this.negativeSuffix.length();
    }

    public Number getNumberValue() throws ParseException {
        String S = "NumericPlainDocument: getNumberValue(): ";
        try {
            String context = this.getText(0, this.getLength());
            this.parsePos.setIndex(0);
            Number result = this.format.parse(context, this.parsePos);
            if (this.parsePos.getIndex() != this.getLength()) {
                throw new ParseException(S + "Not a valid number: " + context, 0);
            }
            return result;
        }
        catch (BadLocationException e) {
            throw new ParseException(S + "Not a valid number: ", 0);
        }
    }

    public Long getLongValue() throws ParseException {
        Number result = this.getNumberValue();
        if (!(result instanceof Long)) {
            String S = "NumericPlainDocument: getLongValue(): ";
            throw new ParseException(S + "Not a valid Long: " + result, 0);
        }
        return (Long)result;
    }

    public Double getDoubleValue() throws ParseException {
        Number result = this.getNumberValue();
        if (!(result instanceof Double)) {
            String S = "NumericPlainDocument: getDoubleValue(): ";
            throw new ParseException(S + "Not a valid Double: " + result, 0);
        }
        return (Double)result;
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        block12: {
            block14: {
                String targetString;
                int originalLength;
                int length;
                block13: {
                    int prefixLength;
                    int suffixLength;
                    String suffix;
                    String S = "NumericPlainDocumentinsertString: (): ";
                    if (str == null || str.length() == 0) break block12;
                    AbstractDocument.Content content = this.getContent();
                    originalLength = length = content.length();
                    this.parsePos.setIndex(0);
                    targetString = content.getString(0, offset) + str + content.getString(offset, length - offset - 1);
                    boolean gotPositive = targetString.startsWith(this.positivePrefix);
                    boolean gotNegative = targetString.startsWith(this.negativePrefix);
                    length = targetString.length();
                    if (!gotPositive && !gotNegative) break block13;
                    if (gotPositive && gotNegative) {
                        if (this.positivePrefixLen > this.negativePrefixLen) {
                            gotNegative = false;
                        } else {
                            gotPositive = false;
                        }
                    }
                    if (gotPositive) {
                        suffix = this.positiveSuffix;
                        suffixLength = this.positiveSuffixLen;
                        prefixLength = this.positivePrefixLen;
                    } else {
                        suffix = this.negativeSuffix;
                        suffixLength = this.negativeSuffixLen;
                        prefixLength = this.negativePrefixLen;
                    }
                    if (length == prefixLength) break block14;
                    if (!targetString.endsWith(suffix)) {
                        int i;
                        for (i = suffixLength - 1; i > 0; --i) {
                            if (!targetString.regionMatches(length - i, suffix, 0, i)) continue;
                            targetString = targetString + suffix.substring(i);
                            break;
                        }
                        if (i == 0) {
                            targetString = targetString + suffix;
                        }
                        length = targetString.length();
                    }
                }
                this.format.parse(targetString, this.parsePos);
                int endIndex = this.parsePos.getIndex();
                if (!(endIndex == length || this.positivePrefixLen > 0 && endIndex < this.positivePrefixLen && length <= this.positivePrefixLen && targetString.regionMatches(0, this.positivePrefix, 0, length) || this.negativePrefixLen > 0 && endIndex < this.negativePrefixLen && length <= this.negativePrefixLen && targetString.regionMatches(0, this.negativePrefix, 0, length))) {
                    char lastChar = targetString.charAt(originalLength - 1);
                    int decimalIndex = targetString.indexOf(this.decimalSeparator);
                }
            }
            String context = this.getText(0, this.getLength());
            super.insertString(offset, str, a);
            context = this.getText(0, this.getLength());
        }
    }

    public void addInsertErrorListener(InsertErrorListener l) {
        if (this.errorListener != null) {
            throw new IllegalArgumentException("NumericPlainDocument: addInsertErrorListener(): InsertErrorListener already registered");
        }
        this.errorListener = l;
    }

    public void removeInsertErrorListener(InsertErrorListener l) {
        if (this.errorListener == l) {
            this.errorListener = null;
        }
    }

    public static interface InsertErrorListener {
        public void insertFailed(NumericPlainDocument var1, int var2, String var3, AttributeSet var4);
    }
}

