/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.data.region.EvenlyGriddedGeographicRegionAPI;
import org.opensha.data.region.EvenlyGriddedRectangularGeographicRegion;
import org.opensha.data.region.GeographicRegion;
import org.opensha.exceptions.RegionConstraintException;
import org.opensha.sha.earthquake.EqkRupForecastAPI;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.surface.EvenlyGriddedSurfaceAPI;

public class ERF2GriddedSeisRatesCalc {
    private double minMagnitude;
    private DecimalFormat magFormat = new DecimalFormat("0.00");
    private EqkRupForecastAPI eqkRupForecast;
    private EvenlyGriddedGeographicRegionAPI region;

    public ArrayList calcMFD_ForGriddedRegion(double minMag, double maxMag, int numMagBins, EqkRupForecastAPI eqkRupForecast, EvenlyGriddedGeographicRegionAPI region) {
        double delta = (maxMag - minMag) / (double)(numMagBins - 1);
        ArrayList cumMFDList = this.calcCumMFD_ForGriddedRegion(minMag - delta, eqkRupForecast, region);
        int numLocs = cumMFDList.size();
        ArrayList<IncrementalMagFreqDist> mfdList = new ArrayList<IncrementalMagFreqDist>();
        for (int i = 0; i < numLocs; ++i) {
            IncrementalMagFreqDist magFreqDist = new IncrementalMagFreqDist(minMag, maxMag, numMagBins);
            mfdList.add(magFreqDist);
            ArbitrarilyDiscretizedFunc cumFunc = (ArbitrarilyDiscretizedFunc)cumMFDList.get(i);
            if (cumFunc == null) continue;
            for (int j = 0; j < magFreqDist.getNum(); ++j) {
                double mag = magFreqDist.getX(j);
                double cumRate1 = this.getRateForMag(cumFunc, mag - delta / 2.0);
                double cumRate2 = this.getRateForMag(cumFunc, mag + delta / 2.0);
                magFreqDist.set(mag, cumRate1 - cumRate2);
            }
        }
        return mfdList;
    }

    private double getRateForMag(ArbitrarilyDiscretizedFunc func, double mag) {
        if (mag < func.getMinX()) {
            return func.getY(0);
        }
        if (mag > func.getMaxX()) {
            return 0.0;
        }
        return func.getInterpolatedY(mag);
    }

    public ArrayList calcCumMFD_ForGriddedRegion(double minMag, EqkRupForecastAPI eqkRupForecast, EvenlyGriddedGeographicRegionAPI region) {
        this.minMagnitude = minMag;
        this.eqkRupForecast = eqkRupForecast;
        this.region = region;
        ArbDiscrEmpiricalDistFunc[] funcs = this.calcSeisRatesForGriddedRegion();
        ArrayList<ArbitrarilyDiscretizedFunc> magRateDist = new ArrayList<ArbitrarilyDiscretizedFunc>();
        int size = funcs.length;
        for (int i = 0; i < size; ++i) {
            int numEmpDistElemnents = funcs[i].getNum();
            if (numEmpDistElemnents == 0) {
                magRateDist.add(null);
                continue;
            }
            ArbitrarilyDiscretizedFunc cumDist = funcs[i].getCumDist();
            int numMags = cumDist.getNum();
            ArbitrarilyDiscretizedFunc magRateFunction = new ArbitrarilyDiscretizedFunc();
            magRateFunction.set(cumDist.getX(0), cumDist.getY(numMags - 1));
            for (int magIndex = 1; magIndex < numMags; ++magIndex) {
                double rates = cumDist.getY(numMags - 1) - cumDist.getY(magIndex - 1);
                magRateFunction.set(cumDist.getX(magIndex), rates);
            }
            magRateDist.add(magRateFunction);
        }
        return magRateDist;
    }

    public double[] getTotalSeisRateAtEachLocationInRegion(double minMag, EqkRupForecastAPI eqkRupForecast, EvenlyGriddedGeographicRegionAPI region) {
        this.minMagnitude = minMag;
        this.eqkRupForecast = eqkRupForecast;
        this.region = region;
        double[] rates = this.calcTotalSeisRatesForGriddedRegion();
        return rates;
    }

    public double getTotalSeisRateInRegion(double minMag, EqkRupForecastAPI eqkRupForecast, GeographicRegion region) {
        int numSources = eqkRupForecast.getNumSources();
        double totalRate = 0.0;
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                if (mag < minMag) continue;
                EvenlyGriddedSurfaceAPI rupSurface = rupture.getRuptureSurface();
                long numPts = rupSurface.size();
                double ptRate = this.getRupturePtRate(eqkRupForecast, rupture, numPts);
                ListIterator it = rupSurface.getAllByRowsIterator();
                while (it.hasNext()) {
                    Location ptLoc = (Location)it.next();
                    if (!region.isLocationInside(ptLoc)) continue;
                    totalRate += ptRate;
                }
            }
        }
        return totalRate;
    }

    public ArbDiscrEmpiricalDistFunc getMagRateDistForRegion(double minMag, EqkRupForecastAPI eqkRupForecast, GeographicRegion region) {
        ArbDiscrEmpiricalDistFunc magRateDist = new ArbDiscrEmpiricalDistFunc();
        int numSources = eqkRupForecast.getNumSources();
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                if (mag < minMag) continue;
                EvenlyGriddedSurfaceAPI rupSurface = rupture.getRuptureSurface();
                long numPts = rupSurface.size();
                double ptRate = this.getRupturePtRate(eqkRupForecast, rupture, numPts);
                ListIterator it = rupSurface.getAllByRowsIterator();
                while (it.hasNext()) {
                    Location ptLoc = (Location)it.next();
                    if (!region.isLocationInside(ptLoc)) continue;
                    String ruptureMag = this.magFormat.format(mag);
                    magRateDist.set(Double.parseDouble(ruptureMag), ptRate);
                }
            }
        }
        return magRateDist;
    }

    private double getRupturePtRate(EqkRupForecastAPI eqkRupForecast, ProbEqkRupture rupture, long numPts) {
        return -Math.log(1.0 - rupture.getProbability()) / eqkRupForecast.getTimeSpan().getDuration() / (double)numPts;
    }

    private double[] calcTotalSeisRatesForGriddedRegion() {
        int numSources = this.eqkRupForecast.getNumSources();
        int numLocations = this.region.getNumGridLocs();
        double[] rates = new double[numLocations];
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = this.eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                if (mag < this.minMagnitude) continue;
                EvenlyGriddedSurfaceAPI rupSurface = rupture.getRuptureSurface();
                long numPts = rupSurface.size();
                double ptRate = this.getRupturePtRate(this.eqkRupForecast, rupture, numPts);
                ListIterator it = rupSurface.getAllByRowsIterator();
                while (it.hasNext()) {
                    Location ptLoc = (Location)it.next();
                    int locIndex = 0;
                    locIndex = this.region.getNearestLocationIndex(ptLoc);
                    if (locIndex < 0) continue;
                    int n = locIndex;
                    rates[n] = rates[n] + ptRate;
                }
            }
        }
        return rates;
    }

    private ArbDiscrEmpiricalDistFunc[] calcSeisRatesForGriddedRegion() {
        int numSources = this.eqkRupForecast.getNumSources();
        int numLocations = this.region.getNumGridLocs();
        ArbDiscrEmpiricalDistFunc[] funcs = new ArbDiscrEmpiricalDistFunc[numLocations];
        for (int i = 0; i < numLocations; ++i) {
            funcs[i] = new ArbDiscrEmpiricalDistFunc();
        }
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = this.eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                if (mag < this.minMagnitude) continue;
                EvenlyGriddedSurfaceAPI rupSurface = rupture.getRuptureSurface();
                long numPts = rupSurface.size();
                double ptRate = this.getRupturePtRate(this.eqkRupForecast, rupture, numPts);
                ListIterator it = rupSurface.getAllByRowsIterator();
                while (it.hasNext()) {
                    Location ptLoc = (Location)it.next();
                    int locIndex = 0;
                    locIndex = this.region.getNearestLocationIndex(ptLoc);
                    if (locIndex < 0) continue;
                    String magString = this.magFormat.format(mag);
                    funcs[locIndex].set(Double.parseDouble(magString), ptRate);
                }
            }
        }
        return funcs;
    }

    public double getTotalProbAbove(EqkRupForecastAPI eqkRupForecast, double minMag, GeographicRegion region) {
        int numSources = eqkRupForecast.getNumSources();
        double totalProb = 1.0;
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            boolean isSourcePoission = source.isPoissonianSource();
            double srcProb = isSourcePoission ? 1.0 : 0.0;
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                if (rupture.getMag() < minMag) continue;
                EvenlyGriddedSurfaceAPI rupSurface = rupture.getRuptureSurface();
                double ptProb = rupture.getProbability() / (double)rupSurface.size();
                ListIterator it = rupSurface.getAllByRowsIterator();
                while (it.hasNext()) {
                    Location ptLoc = (Location)it.next();
                    if (!region.isLocationInside(ptLoc)) continue;
                    if (isSourcePoission) {
                        srcProb *= 1.0 - ptProb;
                        continue;
                    }
                    srcProb += ptProb;
                }
            }
            if (isSourcePoission) {
                srcProb = 1.0 - srcProb;
            }
            totalProb *= 1.0 - srcProb;
        }
        return 1.0 - totalProb;
    }

    public static void main(String[] args) {
        ERF2GriddedSeisRatesCalc erf2griddedseisratescalc = new ERF2GriddedSeisRatesCalc();
        Frankel02_AdjustableEqkRupForecast frankelForecast = null;
        frankelForecast = new Frankel02_AdjustableEqkRupForecast();
        frankelForecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_INCLUDE);
        frankelForecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_POINT);
        frankelForecast.getAdjustableParameterList().getParameter("Rupture Offset").setValue(new Double(10.0));
        frankelForecast.getTimeSpan().setDuration(50.0);
        frankelForecast.updateForecast();
        try {
            EvenlyGriddedRectangularGeographicRegion region = new EvenlyGriddedRectangularGeographicRegion(32.0, 38.3, -123.0, -115.0, 0.1);
            double[] rates = erf2griddedseisratescalc.getTotalSeisRateAtEachLocationInRegion(5.0, frankelForecast, region);
            int size = rates.length;
            try {
                FileWriter fw = new FileWriter("magRates_With_BG.txt");
                for (int i = 0; i < size; ++i) {
                    Location loc = region.getGridLocation(i);
                    fw.write(loc + "\t" + (float)rates[i] + "" + "\n");
                }
                fw.close();
            }
            catch (IOException ex2) {}
        }
        catch (RegionConstraintException regionConstraintException) {
            // empty catch block
        }
    }
}

