/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Calendar;
import org.opensha.data.Site;
import org.opensha.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.data.function.DiscretizedFuncAPI;
import org.opensha.data.region.SitesInGriddedRectangularRegion;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.gui.infoTools.HazardMapCalcPostProcessing;
import org.opensha.sha.imr.AttenuationRelationshipAPI;

public class HazardMapCalculator {
    protected static final String C = "HazardMapCalculator";
    protected static final boolean D = false;
    protected double MAX_DISTANCE = 200.0;
    private DecimalFormat decimalFormat = new DecimalFormat("0.00##");
    public static final String DATASETS_PATH = "/opt/install/jakarta-tomcat-4.1.24/webapps/OpenSHA/HazardMapDatasets/";
    boolean xLogFlag = true;
    String newDir;

    public void setMaxSourceDistance(double distance) {
        this.MAX_DISTANCE = distance;
    }

    public void getHazardMapCurves(boolean imtLogFlag, double[] xValues, SitesInGriddedRectangularRegion griddedSites, AttenuationRelationshipAPI imr, EqkRupForecast eqkRupForecast, String mapParametersInfo) {
        boolean success;
        File mainDir = new File(DATASETS_PATH);
        if (!mainDir.isDirectory()) {
            success = new File(DATASETS_PATH).mkdir();
            this.newDir = "/opt/install/jakarta-tomcat-4.1.24/webapps/OpenSHA/HazardMapDatasets/1";
        } else if (mainDir.list() != null) {
            int numDataSets = mainDir.list().length;
            this.newDir = DATASETS_PATH + (numDataSets + 1);
        } else {
            this.newDir = "/opt/install/jakarta-tomcat-4.1.24/webapps/OpenSHA/HazardMapDatasets/1";
        }
        success = new File(this.newDir).mkdir();
        this.calculate(imtLogFlag, xValues, griddedSites, imr, eqkRupForecast, mapParametersInfo, null);
    }

    public void getHazardMapCurves(String dirName, boolean imtLogFlag, double[] xValues, SitesInGriddedRectangularRegion griddedSites, AttenuationRelationshipAPI imr, EqkRupForecast eqkRupForecast, String mapParametersInfo, String email) {
        this.newDir = new String(dirName);
        File f = new File(DATASETS_PATH + dirName);
        if (f.exists()) {
            throw new RuntimeException("Directory already exists please give some other name");
        }
        boolean success = f.mkdir();
        this.calculate(imtLogFlag, xValues, griddedSites, imr, eqkRupForecast, mapParametersInfo, email);
    }

    private void calculate(boolean imtLogFlag, double[] xValues, SitesInGriddedRectangularRegion griddedSites, AttenuationRelationshipAPI imr, EqkRupForecast eqkRupForecast, String mapParametersInfo, String email) {
        this.xLogFlag = imtLogFlag;
        int numSites = griddedSites.getNumGridLocs();
        try {
            HazardCurveCalculator hazCurveCalc = new HazardCurveCalculator();
            int numPoints = xValues.length;
            for (int j = 0; j < numSites; ++j) {
                Site site = griddedSites.getSite(j);
                ArbitrarilyDiscretizedFunc hazFunction = new ArbitrarilyDiscretizedFunc();
                this.initX_Values(hazFunction, xValues);
                hazCurveCalc.getHazardCurve((DiscretizedFuncAPI)hazFunction, site, imr, eqkRupForecast);
                String lat = this.decimalFormat.format(site.getLocation().getLatitude());
                String lon = this.decimalFormat.format(site.getLocation().getLongitude());
                hazFunction = this.toggleHazFuncLogValues(hazFunction, xValues);
                try {
                    FileWriter fr = new FileWriter(DATASETS_PATH + this.newDir + "/" + lat + "_" + lon + ".txt");
                    for (int i = 0; i < numPoints; ++i) {
                        fr.write(hazFunction.getX(i) + " " + hazFunction.getY(i) + "\n");
                    }
                    fr.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            FileWriter fr = new FileWriter(DATASETS_PATH + this.newDir + "/metadata.txt");
            fr.write(mapParametersInfo + "\n");
            fr.close();
            fr = new FileWriter(DATASETS_PATH + this.newDir + "/sites.txt");
            fr.write(griddedSites.getMinLat() + " " + griddedSites.getMaxLat() + " " + griddedSites.getGridSpacing() + "\n" + griddedSites.getMinLon() + " " + griddedSites.getMaxLon() + " " + griddedSites.getGridSpacing() + "\n");
            fr.close();
            if (email != null || !email.equals("")) {
                HazardMapCalcPostProcessing mapPostProcessing = new HazardMapCalcPostProcessing(numSites, email, this.newDir, Calendar.getInstance().getTime().toString().replaceAll(" ", "_"));
            }
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
    }

    private void initX_Values(DiscretizedFuncAPI arb, double[] xValues) {
        if (this.xLogFlag) {
            for (int i = 0; i < xValues.length; ++i) {
                arb.set(Math.log(xValues[i]), 1.0);
            }
        } else {
            throw new RuntimeException("Unsupported IMT");
        }
    }

    private ArbitrarilyDiscretizedFunc toggleHazFuncLogValues(ArbitrarilyDiscretizedFunc hazFunc, double[] xValues) {
        int numPoints = hazFunc.getNum();
        DiscretizedFuncAPI tempFunc = hazFunc.deepClone();
        hazFunc = new ArbitrarilyDiscretizedFunc();
        if (this.xLogFlag) {
            for (int i = 0; i < numPoints; ++i) {
                hazFunc.set(xValues[i], tempFunc.getY(i));
            }
            return hazFunc;
        }
        throw new RuntimeException("Unsupported IMT");
    }
}

