/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.io.Serializable;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.exceptions.InvalidRangeException;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.sha.surface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.surface.PointSurface;
import org.opensha.util.FaultUtils;

public class EqkRupture
implements Serializable {
    protected static final String C = "EqkRupture";
    protected static final boolean D = false;
    protected double mag = Double.NaN;
    protected double aveRake = Double.NaN;
    protected Location hypocenterLocation = null;
    protected EvenlyGriddedSurfaceAPI ruptureSurface = null;
    protected ParameterList otherParams;

    public EqkRupture() {
    }

    public EqkRupture(double mag, double aveRake, EvenlyGriddedSurfaceAPI ruptureSurface, Location hypocenterLocation) throws InvalidRangeException {
        this.mag = mag;
        FaultUtils.assertValidRake(aveRake);
        this.hypocenterLocation = hypocenterLocation;
        this.aveRake = aveRake;
        this.ruptureSurface = ruptureSurface;
    }

    public void addParameter(ParameterAPI parameter) {
        if (this.otherParams == null) {
            this.otherParams = new ParameterList();
        }
        if (!this.otherParams.containsParameter(parameter)) {
            this.otherParams.addParameter(parameter);
        } else {
            this.otherParams.updateParameter(parameter);
        }
    }

    public void removeParameter(ParameterAPI parameter) {
        if (this.otherParams == null) {
            return;
        }
        this.otherParams.removeParameter(parameter);
    }

    public ListIterator getAddedParametersIterator() {
        if (this.otherParams == null) {
            return null;
        }
        return this.otherParams.getParametersIterator();
    }

    public double getMag() {
        return this.mag;
    }

    public void setMag(double mag) {
        this.mag = mag;
    }

    public double getAveRake() {
        return this.aveRake;
    }

    public void setAveRake(double aveRake) throws InvalidRangeException {
        FaultUtils.assertValidRake(aveRake);
        this.aveRake = aveRake;
    }

    public EvenlyGriddedSurfaceAPI getRuptureSurface() {
        return this.ruptureSurface;
    }

    public void setRuptureSurface(EvenlyGriddedSurfaceAPI r) {
        this.ruptureSurface = r;
    }

    public Location getHypocenterLocation() {
        return this.hypocenterLocation;
    }

    public void setHypocenterLocation(Location h) {
        this.hypocenterLocation = h;
    }

    public void setPointSurface(Location location) {
        PointSurface ps = new PointSurface(location.getLatitude(), location.getLongitude(), location.getDepth());
        this.setPointSurface(ps);
    }

    public void setPointSurface(Location location, double aveDip) {
        this.setPointSurface(location);
        ((PointSurface)this.ruptureSurface).setAveDip(aveDip);
    }

    public void setPointSurface(Location location, double aveStrike, double aveDip) {
        this.setPointSurface(location);
        ((PointSurface)this.ruptureSurface).setAveStrike(aveStrike);
        ((PointSurface)this.ruptureSurface).setAveDip(aveDip);
    }

    public void setPointSurface(PointSurface pointSurface) {
        this.ruptureSurface = pointSurface;
    }

    public String getInfo() {
        String info2;
        String info1 = new String("\tMag. = " + (float)this.mag + "\n" + "\tAve. Rake = " + (float)this.aveRake + "\n" + "\tAve. Dip = " + (float)this.ruptureSurface.getAveDip() + "\n" + "\tHypocenter = " + this.hypocenterLocation + "\n");
        if (this.ruptureSurface.getNumCols() == 1 && this.ruptureSurface.getNumRows() == 1) {
            Location loc = this.ruptureSurface.getLocation(0, 0);
            info2 = new String("\tPoint-Surface Location (lat, lon, depth (km):\n\n\t\t" + (float)loc.getLatitude() + ", " + (float)loc.getLongitude() + ", " + (float)loc.getDepth());
        } else {
            Location loc1 = this.ruptureSurface.getLocation(0, 0);
            Location loc2 = this.ruptureSurface.getLocation(0, this.ruptureSurface.getNumCols() - 1);
            Location loc3 = this.ruptureSurface.getLocation(this.ruptureSurface.getNumRows() - 1, 0);
            Location loc4 = this.ruptureSurface.getLocation(this.ruptureSurface.getNumRows() - 1, this.ruptureSurface.getNumCols() - 1);
            info2 = new String("\tRup. Surf. Corner Locations (lat, lon, depth (km):\n\n\t\t" + (float)loc1.getLatitude() + ", " + (float)loc1.getLongitude() + ", " + (float)loc1.getDepth() + "\n" + "\t\t" + (float)loc2.getLatitude() + ", " + (float)loc2.getLongitude() + ", " + (float)loc2.getDepth() + "\n" + "\t\t" + (float)loc3.getLatitude() + ", " + (float)loc3.getLongitude() + ", " + (float)loc3.getDepth() + "\n" + "\t\t" + (float)loc4.getLatitude() + ", " + (float)loc4.getLongitude() + ", " + (float)loc4.getDepth() + "\n");
        }
        return info1 + info2;
    }
}

