/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.util.ArrayList;
import java.util.Iterator;
import org.opensha.calc.RelativeLocation;
import org.opensha.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.Site;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.surface.EvenlyGriddedSurface;

public class FloatingPoissonFaultSource
extends ProbEqkSource {
    private static String C = new String("FloatingPoissonFaultSource");
    private boolean D = false;
    protected String NAME = "Floating Poisson Fault Source";
    private int totNumRups;
    private ArrayList ruptureList;
    private ArrayList faultCornerLocations = new ArrayList();
    private double timeSpan;
    private EvenlyGriddedSurface faultSurface;

    public FloatingPoissonFaultSource(IncrementalMagFreqDist magDist, EvenlyGriddedSurface faultSurface, MagScalingRelationship magScalingRel, double magScalingSigma, double rupAspectRatio, double rupOffset, double rake, double timeSpan, double minMag) {
        this.timeSpan = timeSpan;
        this.faultSurface = faultSurface;
        if (this.D) {
            System.out.println(magDist.getName());
            System.out.println("surface rows, cols: " + faultSurface.getNumCols() + ", " + faultSurface.getNumRows());
            System.out.println("magScalingRelationship: " + magScalingRel.getName());
            System.out.println("magScalingSigma: " + magScalingSigma);
            System.out.println("rupAspectRatio: " + rupAspectRatio);
            System.out.println("rupOffset: " + rupOffset);
            System.out.println("rake: " + rake);
            System.out.println("timeSpan: " + timeSpan);
            System.out.println("minMag: " + minMag);
        }
        this.makeFaultCornerLocs(faultSurface);
        this.ruptureList = new ArrayList();
        if (magScalingSigma == 0.0) {
            this.addRupturesToList(magDist, faultSurface, magScalingRel, magScalingSigma, rupAspectRatio, rupOffset, rake, minMag, 0.0, 1.0);
        } else {
            this.addRupturesToList(magDist, faultSurface, magScalingRel, magScalingSigma, rupAspectRatio, rupOffset, rake, minMag, 0.0, 0.6);
            this.addRupturesToList(magDist, faultSurface, magScalingRel, magScalingSigma, rupAspectRatio, rupOffset, rake, minMag, 1.64, 0.2);
            this.addRupturesToList(magDist, faultSurface, magScalingRel, magScalingSigma, rupAspectRatio, rupOffset, rake, minMag, -1.64, 0.2);
        }
    }

    public FloatingPoissonFaultSource(IncrementalMagFreqDist magDist, EvenlyGriddedSurface faultSurface, MagScalingRelationship magScalingRel, double magScalingSigma, double rupAspectRatio, double rupOffset, double rake, double timeSpan) {
        this(magDist, faultSurface, magScalingRel, magScalingSigma, rupAspectRatio, rupOffset, rake, timeSpan, 5.0);
    }

    private double getRupLength(MagScalingRelationship magScalingRel, double magScalingSigma, double numSigma, double rupAspectRatio, double mag) throws RuntimeException {
        if (magScalingRel instanceof MagAreaRelationship) {
            double area = magScalingRel.getMedianScale(mag) * Math.pow(10.0, numSigma * magScalingSigma);
            return Math.sqrt(area * rupAspectRatio);
        }
        if (magScalingRel instanceof MagLengthRelationship) {
            return magScalingRel.getMedianScale(mag) * Math.pow(10.0, numSigma * magScalingSigma);
        }
        throw new RuntimeException("bad type of MagScalingRelationship");
    }

    private void addRupturesToList(IncrementalMagFreqDist magDist, EvenlyGriddedSurface faultSurface, MagScalingRelationship magScalingRel, double magScalingSigma, double rupAspectRatio, double rupOffset, double rake, double minMag, double numSigma, double weight) {
        int numMags = magDist.getNum();
        double prob = Double.NaN;
        Location loc1 = (Location)faultSurface.get(0, 0);
        Location loc2 = (Location)faultSurface.get(faultSurface.getNumRows() - 1, 0);
        double ddw = RelativeLocation.getTotalDistance(loc1, loc2);
        if (this.D) {
            System.out.println(C + ": ddw=" + ddw);
        }
        if (this.D) {
            System.out.println(C + ": magScalingSigma=" + magScalingSigma);
        }
        for (int i = 0; i < numMags; ++i) {
            double mag = magDist.getX(i);
            if (!(magDist.getY(i) > 0.0) || !(mag >= minMag)) continue;
            double rupLen = this.getRupLength(magScalingRel, magScalingSigma, numSigma, rupAspectRatio, mag);
            double rupWidth = rupLen / rupAspectRatio;
            if (magScalingRel instanceof MagAreaRelationship && rupWidth > ddw) {
                rupLen *= rupWidth / ddw;
                rupWidth = ddw;
            }
            double numRup = faultSurface.getNumSubsetSurfaces(rupLen, rupWidth, rupOffset);
            double rate = magDist.getY(mag);
            int r = 0;
            while ((double)r < numRup) {
                this.probEqkRupture = new ProbEqkRupture();
                this.probEqkRupture.setAveRake(rake);
                this.probEqkRupture.setRuptureSurface(faultSurface.getNthSubsetSurface(rupLen, rupWidth, rupOffset, r));
                this.probEqkRupture.setMag(mag);
                prob = weight * (1.0 - Math.exp(-this.timeSpan * rate / numRup));
                this.probEqkRupture.setProbability(prob);
                this.ruptureList.add(this.probEqkRupture);
                ++r;
            }
            if (!this.D) continue;
            System.out.println(C + ": mag=" + mag + "; rupLen=" + rupLen + "; rupWidth=" + rupWidth + "; rate=" + rate + "; timeSpan=" + this.timeSpan + "; numRup=" + numRup + "; weight=" + weight + "; prob=" + prob);
        }
    }

    public LocationList getAllSourceLocs() {
        return this.faultSurface.getLocationList();
    }

    public int getNumRuptures() {
        return this.ruptureList.size();
    }

    public ProbEqkRupture getRupture(int nthRupture) {
        return (ProbEqkRupture)this.ruptureList.get(nthRupture);
    }

    public double getMinDistance(Site site) {
        double min = Double.MAX_VALUE;
        Iterator it = this.faultCornerLocations.iterator();
        while (it.hasNext()) {
            double tempMin = RelativeLocation.getHorzDistance(site.getLocation(), (Location)it.next());
            if (!(tempMin < min)) continue;
            min = tempMin;
        }
        return min;
    }

    private void makeFaultCornerLocs(EvenlyGriddedSurface faultSurface) {
        int nRows = faultSurface.getNumRows();
        int nCols = faultSurface.getNumCols();
        this.faultCornerLocations.add(faultSurface.get(0, 0));
        this.faultCornerLocations.add(faultSurface.get(0, nCols / 2));
        this.faultCornerLocations.add(faultSurface.get(0, nCols - 1));
        this.faultCornerLocations.add(faultSurface.get(nRows - 1, 0));
        this.faultCornerLocations.add(faultSurface.get(nRows - 1, nCols / 2));
        this.faultCornerLocations.add(faultSurface.get(nRows - 1, nCols - 1));
    }

    public void setName(String name) {
        this.NAME = name;
    }

    public String getName() {
        return this.NAME;
    }
}

