/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Frankel02;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.calc.MomentMagCalc;
import org.opensha.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.data.Location;
import org.opensha.data.TimeSpan;
import org.opensha.exceptions.FaultException;
import org.opensha.param.DoubleParameter;
import org.opensha.param.StringParameter;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_GR_EqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Point2Vert_SS_FaultPoisSource;
import org.opensha.sha.fault.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.fault.FaultTrace;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.surface.EvenlyGriddedSurface;
import org.opensha.sha.surface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.surface.FrankelGriddedSurface;
import org.opensha.sha.surface.StirlingGriddedSurface;
import org.opensha.util.FileUtils;

public class Frankel02_AdjustableEqkRupForecast
extends EqkRupForecast {
    private static String C = new String("Frankel02_EqkRupForecast");
    private boolean D = false;
    public static final String NAME = new String("USGS/CGS 2002 Adj. Cal. ERF");
    private String CHAR_MAG_FREQ_DIST = "1";
    private String GR_MAG_FREQ_DIST = "2";
    private String FAULTING_STYLE_SS = "1";
    private String FAULTING_STYLE_R = "2";
    private String FAULTING_STYLE_N = "3";
    public static final double BACK_SEIS_DEPTH = 5.0;
    protected static final FaultException ERR = new FaultException(C + ": loadFaultTraces(): Missing metadata from trace, file bad format.");
    private static final String IN_FILE_PATH = "org/opensha/sha/earthquake/rupForecastImpl/Frankel02/InputFiles/";
    private ArrayList charFaultSources;
    private ArrayList grFaultSources;
    private ArrayList frankelBackgrSeisSources;
    private ArrayList allSources;
    private WC1994_MagLengthRelationship magLenRel = new WC1994_MagLengthRelationship();
    public static final String FAULT_MODEL_NAME = new String("Fault Model");
    public static final String FAULT_MODEL_FRANKEL = new String("Frankel's");
    public static final String FAULT_MODEL_STIRLING = new String("Stirling's");
    ArrayList faultModelNamesStrings = new ArrayList();
    StringParameter faultModelParam;
    public static final String BACK_SEIS_NAME = new String("Background Seismicity");
    public static final String BACK_SEIS_INCLUDE = new String("Include");
    public static final String BACK_SEIS_EXCLUDE = new String("Exclude");
    public static final String BACK_SEIS_ONLY = new String("Only Background");
    ArrayList backSeisOptionsStrings = new ArrayList();
    StringParameter backSeisParam;
    public static final String BACK_SEIS_RUP_NAME = new String("Treat Background Seismicity As");
    public static final String BACK_SEIS_RUP_POINT = new String("Point Sources");
    public static final String BACK_SEIS_RUP_FINITE = new String("Finite Sources");
    ArrayList backSeisRupStrings = new ArrayList();
    StringParameter backSeisRupParam;
    public static final String RUP_OFFSET_PARAM_NAME = "Rupture Offset";
    private Double DEFAULT_RUP_OFFSET_VAL = new Double(10.0);
    private static final String RUP_OFFSET_PARAM_UNITS = "km";
    private static final String RUP_OFFSET_PARAM_INFO = "Length of offset for floating ruptures";
    public static final double RUP_OFFSET_PARAM_MIN = 1.0;
    public static final double RUP_OFFSET_PARAM_MAX = 100.0;
    DoubleParameter rupOffset_Param;

    public Frankel02_AdjustableEqkRupForecast() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        this.timeSpan.setDuration(50.0);
        this.initAdjParams();
        this.faultModelParam.addParameterChangeListener(this);
        this.rupOffset_Param.addParameterChangeListener(this);
        this.backSeisParam.addParameterChangeListener(this);
        this.backSeisRupParam.addParameterChangeListener(this);
    }

    private void initAdjParams() {
        this.faultModelNamesStrings.add(FAULT_MODEL_FRANKEL);
        this.faultModelNamesStrings.add(FAULT_MODEL_STIRLING);
        this.faultModelParam = new StringParameter(FAULT_MODEL_NAME, this.faultModelNamesStrings, (String)this.faultModelNamesStrings.get(0));
        this.backSeisOptionsStrings.add(BACK_SEIS_EXCLUDE);
        this.backSeisOptionsStrings.add(BACK_SEIS_INCLUDE);
        this.backSeisOptionsStrings.add(BACK_SEIS_ONLY);
        this.backSeisParam = new StringParameter(BACK_SEIS_NAME, this.backSeisOptionsStrings, BACK_SEIS_EXCLUDE);
        this.rupOffset_Param = new DoubleParameter(RUP_OFFSET_PARAM_NAME, 1.0, 100.0, RUP_OFFSET_PARAM_UNITS, this.DEFAULT_RUP_OFFSET_VAL);
        this.rupOffset_Param.setInfo(RUP_OFFSET_PARAM_INFO);
        this.backSeisRupStrings.add(BACK_SEIS_RUP_POINT);
        this.backSeisRupStrings.add(BACK_SEIS_RUP_FINITE);
        this.backSeisRupParam = new StringParameter(BACK_SEIS_RUP_NAME, this.backSeisRupStrings, BACK_SEIS_RUP_POINT);
        this.rupOffset_Param = new DoubleParameter(RUP_OFFSET_PARAM_NAME, 1.0, 100.0, RUP_OFFSET_PARAM_UNITS, this.DEFAULT_RUP_OFFSET_VAL);
        this.rupOffset_Param.setInfo(RUP_OFFSET_PARAM_INFO);
        this.adjustableParams.addParameter(this.faultModelParam);
        this.adjustableParams.addParameter(this.rupOffset_Param);
        this.adjustableParams.addParameter(this.backSeisParam);
    }

    private void makeAllGridSources() {
        this.makeGridSources("CAmapC_OpenSHA", 0.667, "CAmapG_OpenSHA", 0.333);
        this.makeGridSources("EXTmapC_OpenSHA", 0.5, "EXTmapGW_OpenSHA", 0.5);
        this.makeGridSources("WUSmapC_OpenSHA", 0.5, "WUSmapG_OpenSHA", 0.5);
        this.makeGridSources("brawmap_OpenSHA", 1.0, null, 0.0);
        this.makeGridSources("cadeepAB_OpenSHA", 1.0, null, 0.0);
        this.makeGridSources("creepmap_OpenSHA", 1.0, null, 0.0);
        this.makeGridSources("shear1_OpenSHA", 1.0, null, 0.0);
        this.makeGridSources("shear2_OpenSHA", 1.0, null, 0.0);
        this.makeGridSources("shear3_OpenSHA", 1.0, null, 0.0);
        this.makeGridSources("shear4_OpenSHA", 1.0, null, 0.0);
    }

    private void makeAllFaultSources() {
        this.makeFaultSources("ca-a-other-fixed-char", 1.0, null, 1.0);
        this.makeFaultSources("ca-a-other-norm-char", 1.0, null, 1.0);
        this.makeFaultSources("ca-amod1-char", 0.5, null, 1.0);
        this.makeFaultSources("ca-amod2-char", 0.5, null, 1.0);
        this.makeFaultSources("ca-b-fullwt-norm-ell-65", 0.5, "ca-b-fullwt-norm-hank-65", 0.5);
        this.makeFaultSources("ca-b-fullwt-norm-ell-char", 0.333, "ca-b-fullwt-norm-hank-char", 0.333);
        this.makeFaultSources("ca-b-fullwt-norm-ell-gr", 0.167, "ca-b-fullwt-norm-hank-gr", 0.167);
        this.makeFaultSources("ca-b-fullwt-ss-ell-65", 0.5, "ca-b-fullwt-ss-hank-65", 0.5);
        this.makeFaultSources("ca-b-fullwt-ss-ell-char", 0.333, "ca-b-fullwt-ss-hank-char", 0.333);
        this.makeFaultSources("ca-b-fullwt-ss-ell-gr", 0.167, "ca-b-fullwt-ss-hank-gr", 0.167);
        this.makeFaultSources("ca-bflt-25weight-ell-char", 0.083, "ca-bflt-25weight-hank-char", 0.083);
        this.makeFaultSources("ca-bflt-25weight-ell-gr", 0.042, "ca-bflt-25weight-hank-gr", 0.042);
        this.makeFaultSources("ca-bflt-50weight-ell-65", 0.25, "ca-bflt-50weight-hank-65", 0.25);
        this.makeFaultSources("ca-bflt-50weight-ell-char", 0.167, "ca-bflt-50weight-hank-char", 0.167);
        this.makeFaultSources("ca-bflt-50weight-ell-gr", 0.083, "ca-bflt-50weight-hank-gr", 0.083);
        this.makeFaultSources("ca-bflt-fix-norm-ell-65", 0.5, "ca-bflt-fix-norm-hank-65", 0.5);
        this.makeFaultSources("ca-bflt-fix-norm-ell-char", 0.333, "ca-bflt-fix-norm-hank-char", 0.333);
        this.makeFaultSources("ca-bflt-fix-norm-ell-gr", 0.167, "ca-bflt-fix-norm-hank-gr", 0.167);
        this.makeFaultSources("ca-bflt-fix-ss-ell-65", 0.5, "ca-bflt-fix-ss-hank-65", 0.5);
        this.makeFaultSources("ca-bflt-fix-ss-ell-char", 0.333, "ca-bflt-fix-ss-hank-char", 0.333);
        this.makeFaultSources("ca-bflt-fix-ss-ell-gr", 0.167, "ca-bflt-fix-ss-hank-gr", 0.167);
        this.makeFaultSources("ca-wg99-dist-char", 1.0, null, 1.0);
        this.makeFaultSources("ca-wg99-dist-float", 1.0, null, 1.0);
        this.makeFaultSources("creepflt", 1.0, null, 1.0);
    }

    private void makeFaultSources(String fileName1, double wt1, String fileName2, double wt2) throws FaultException {
        int n;
        String S = C + ": makeFaultSoureces(): ";
        ArrayList inputFaultFileLines1 = null;
        try {
            inputFaultFileLines1 = FileUtils.loadJarFile(IN_FILE_PATH + fileName1);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        if (this.D) {
            System.out.println("fileName1 = org/opensha/sha/earthquake/rupForecastImpl/Frankel02/InputFiles/" + fileName1);
        }
        ArrayList inputFaultFileLines2 = null;
        if (fileName2 != null) {
            try {
                inputFaultFileLines2 = FileUtils.loadJarFile(IN_FILE_PATH + fileName2);
            }
            catch (FileNotFoundException e) {
                System.out.println(e.toString());
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
            if (this.D) {
                System.out.println("fileName2 = org/opensha/sha/earthquake/rupForecastImpl/Frankel02/InputFiles/" + fileName2);
            }
        }
        String magFreqDistType = "";
        String sourceName = "";
        ArrayList<Double> branchDmags = new ArrayList<Double>();
        ArrayList<Double> branchWts = new ArrayList<Double>();
        double rake = Double.NaN;
        double mag = 0.0;
        double mag2 = 0.0;
        double aVal = 0.0;
        double bVal = 0.0;
        double aVal2 = 0.0;
        double bVal2 = 0.0;
        double magLower2 = 0.0;
        double deltaMag2 = 0.0;
        double moRate2 = 0.0;
        double charRate = 0.0;
        double dip = 0.0;
        double downDipWidth = 0.0;
        double depthToTop = 0.0;
        double minMag2 = 0.0;
        double maxMag2 = 0.0;
        double test2 = 0.0;
        String faultModel = (String)this.faultModelParam.getValue();
        double rupOffset = (Double)this.rupOffset_Param.getValue();
        double duration = this.timeSpan.getDuration();
        ListIterator it = inputFaultFileLines1.listIterator();
        StringTokenizer st = new StringTokenizer(it.next().toString());
        double gridSpacing = Double.parseDouble(st.nextToken());
        double dmove = Double.parseDouble(st.nextToken());
        st = new StringTokenizer(it.next().toString());
        int numBranches = Integer.parseInt(st.nextToken());
        st = new StringTokenizer(it.next().toString());
        for (n = 0; n < numBranches; ++n) {
            branchDmags.add(new Double(st.nextToken()));
        }
        st = new StringTokenizer(it.next().toString());
        for (n = 0; n < numBranches; ++n) {
            branchWts.add(new Double(st.nextToken()));
        }
        st = new StringTokenizer(it.next().toString());
        double aleStdDev = Double.parseDouble(st.nextToken());
        double aleWidth = Double.parseDouble(st.nextToken());
        while (it.hasNext()) {
            double wtEp;
            double magEp;
            int i;
            GaussianMagFreqDist tempDist;
            int numMag;
            double mHigh;
            double mLow;
            SummedMagFreqDist totalMagFreqDist;
            double maxMag;
            double minMag;
            double moRate;
            st = new StringTokenizer(it.next().toString());
            magFreqDistType = new String(st.nextToken());
            String faultingStyle = new String(st.nextToken());
            if (faultingStyle.equalsIgnoreCase(this.FAULTING_STYLE_SS)) {
                rake = 0.0;
            } else if (faultingStyle.equalsIgnoreCase(this.FAULTING_STYLE_R)) {
                rake = 90.0;
            } else if (faultingStyle.equalsIgnoreCase(this.FAULTING_STYLE_N)) {
                rake = -90.0;
            } else {
                throw new RuntimeException("Unrecognized faulting style");
            }
            sourceName = "";
            while (st.hasMoreElements()) {
                sourceName = sourceName + st.nextElement() + " ";
            }
            String sourceName2 = "";
            if (fileName2 != null) {
                st = new StringTokenizer((String)inputFaultFileLines2.get(it.nextIndex() - 1));
                st.nextToken();
                st.nextToken();
                while (st.hasMoreElements()) {
                    sourceName2 = sourceName2 + st.nextElement() + " ";
                }
            }
            st = new StringTokenizer(it.next().toString());
            if (magFreqDistType.equals(this.CHAR_MAG_FREQ_DIST)) {
                mag = Double.parseDouble(st.nextToken());
                charRate = Double.parseDouble(st.nextToken());
                moRate = charRate * MomentMagCalc.getMoment(mag);
                minMag = mag + (Double)branchDmags.get(0) - aleWidth * 0.05;
                maxMag = mag + (Double)branchDmags.get(branchDmags.size() - 1) + aleWidth * 0.05;
                if (fileName1.equals("ca-wg99-dist-char")) {
                    sourceName = sourceName + " M=" + mag;
                }
                sourceName = sourceName + " Char";
                if (fileName2 != null) {
                    st = new StringTokenizer((String)inputFaultFileLines2.get(it.nextIndex() - 1));
                    mag2 = Double.parseDouble(st.nextToken());
                    double charRate2 = Double.parseDouble(st.nextToken());
                    moRate2 = charRate2 * MomentMagCalc.getMoment(mag2);
                    minMag2 = mag2 + (Double)branchDmags.get(0) - aleWidth * 0.05;
                    maxMag2 = mag2 + (Double)branchDmags.get(branchDmags.size() - 1) + aleWidth * 0.05;
                }
                if (minMag < 5.8 || aleStdDev == 0.0) {
                    if (fileName2 == null) {
                        SingleMagFreqDist tempDist2 = new SingleMagFreqDist(mag, 1, 0.1, mag, moRate * wt1);
                        totalMagFreqDist = new SummedMagFreqDist(mag, 1, 0.1, false, false);
                        totalMagFreqDist.addIncrementalMagFreqDist(tempDist2);
                    } else {
                        SingleMagFreqDist tempDist3;
                        if (minMag2 >= 5.8) {
                            throw new RuntimeException(C + " Problem: minMag of second file conflicts");
                        }
                        if (mag > mag2) {
                            totalMagFreqDist = new SummedMagFreqDist(mag2, mag, 2, false, false);
                            tempDist3 = new SingleMagFreqDist(mag2, mag, 2);
                        } else {
                            totalMagFreqDist = new SummedMagFreqDist(mag, mag2, 2, false, false);
                            tempDist3 = new SingleMagFreqDist(mag, mag2, 2);
                        }
                        tempDist3.setMagAndMomentRate(mag, moRate * wt1);
                        totalMagFreqDist.addIncrementalMagFreqDist(tempDist3);
                        tempDist3.setMagAndMomentRate(mag2, moRate2 * wt2);
                        totalMagFreqDist.addIncrementalMagFreqDist(tempDist3);
                    }
                } else {
                    if (fileName2 == null) {
                        mLow = minMag;
                        mHigh = maxMag;
                    } else if (mag < mag2) {
                        mLow = minMag;
                        mHigh = maxMag2;
                    } else {
                        mLow = minMag2;
                        mHigh = maxMag;
                    }
                    numMag = Math.round((float)((mHigh - mLow) / 0.05 + 1.0));
                    totalMagFreqDist = new SummedMagFreqDist(mLow, mHigh, numMag, false, false);
                    tempDist = new GaussianMagFreqDist(mLow, mHigh, numMag);
                    for (i = 0; i < branchDmags.size(); ++i) {
                        magEp = mag + (Double)branchDmags.get(i);
                        wtEp = (Double)branchWts.get(i);
                        tempDist.setAllButCumRate(magEp, aleStdDev, moRate * wtEp * wt1, aleWidth * 0.05 / aleStdDev, 2);
                        totalMagFreqDist.addIncrementalMagFreqDist(tempDist);
                    }
                    if (fileName2 != null) {
                        for (i = 0; i < branchDmags.size(); ++i) {
                            magEp = mag2 + (Double)branchDmags.get(i);
                            wtEp = (Double)branchWts.get(i);
                            tempDist.setAllButCumRate(magEp, aleStdDev, moRate2 * wtEp * wt2, aleWidth * 0.05 / aleStdDev, 2);
                            totalMagFreqDist.addIncrementalMagFreqDist(tempDist);
                        }
                    }
                }
            } else {
                aVal = Double.parseDouble(st.nextToken());
                bVal = Double.parseDouble(st.nextToken());
                double magLower = Double.parseDouble(st.nextToken());
                mag = Double.parseDouble(st.nextToken());
                double deltaMag = Double.parseDouble(st.nextToken());
                if (mag != magLower) {
                    magLower += deltaMag / 2.0;
                    mag -= deltaMag / 2.0;
                }
                int numMags = Math.round((float)((mag - magLower) / deltaMag + 1.0));
                moRate = this.getMomentRate(magLower, numMags, deltaMag, aVal, bVal);
                if (fileName2 != null) {
                    st = new StringTokenizer((String)inputFaultFileLines2.get(it.nextIndex() - 1));
                    aVal2 = Double.parseDouble(st.nextToken());
                    bVal2 = Double.parseDouble(st.nextToken());
                    magLower2 = Double.parseDouble(st.nextToken());
                    mag2 = Double.parseDouble(st.nextToken());
                    deltaMag2 = Double.parseDouble(st.nextToken());
                    if (mag2 != magLower2) {
                        magLower2 += deltaMag2 / 2.0;
                        mag2 -= deltaMag2 / 2.0;
                    }
                    int numMags2 = Math.round((float)((mag2 - magLower2) / deltaMag2 + 1.0));
                    moRate2 = this.getMomentRate(magLower2, numMags2, deltaMag2, aVal2, bVal2);
                }
                sourceName = mag == magLower ? sourceName + " fl-Char" : sourceName + " GR";
                if (numMags == 1) {
                    minMag = mag + (Double)branchDmags.get(0) - aleWidth * 0.05;
                    maxMag = mag + (Double)branchDmags.get(branchDmags.size() - 1) + aleWidth * 0.05;
                    if (minMag >= 5.8 && aleStdDev != 0.0) {
                        int i2;
                        if (fileName2 != null) {
                            minMag2 = mag2 + (Double)branchDmags.get(0) - aleWidth * 0.05;
                            maxMag2 = mag2 + (Double)branchDmags.get(branchDmags.size() - 1) + aleWidth * 0.05;
                            if (minMag2 < 5.8) {
                                throw new RuntimeException(C + " PROBLEM: conflicting treatment of file2");
                            }
                            if (mag < mag2) {
                                mLow = minMag;
                                mHigh = maxMag2;
                            } else {
                                mLow = minMag2;
                                mHigh = maxMag;
                            }
                        } else {
                            mLow = minMag;
                            mHigh = maxMag;
                        }
                        numMag = Math.round((float)((mHigh - mLow) / 0.05 + 1.0));
                        totalMagFreqDist = new SummedMagFreqDist(mLow, mHigh, numMag, false, false);
                        tempDist = new GaussianMagFreqDist(mLow, mHigh, numMag);
                        for (i2 = 0; i2 < branchDmags.size(); ++i2) {
                            magEp = mag + (Double)branchDmags.get(i2);
                            wtEp = (Double)branchWts.get(i2);
                            tempDist.setAllButCumRate(magEp, aleStdDev, moRate * wtEp * wt1, aleWidth * 0.05 / aleStdDev, 2);
                            totalMagFreqDist.addIncrementalMagFreqDist(tempDist);
                        }
                        if (fileName2 != null) {
                            for (i2 = 0; i2 < branchDmags.size(); ++i2) {
                                magEp = mag2 + (Double)branchDmags.get(i2);
                                wtEp = (Double)branchWts.get(i2);
                                tempDist.setAllButCumRate(magEp, aleStdDev, moRate2 * wtEp * wt2, aleWidth * 0.05 / aleStdDev, 2);
                                totalMagFreqDist.addIncrementalMagFreqDist(tempDist);
                            }
                        }
                    } else if (fileName2 == null) {
                        SingleMagFreqDist tempDist4 = new SingleMagFreqDist(mag, 1, 0.1, mag, moRate * wt1);
                        totalMagFreqDist = new SummedMagFreqDist(mag, 1, 0.1, false, false);
                        totalMagFreqDist.addIncrementalMagFreqDist(tempDist4);
                    } else {
                        SingleMagFreqDist tempDist5;
                        if (mag > mag2) {
                            totalMagFreqDist = new SummedMagFreqDist(mag2, mag, 2, false, false);
                            tempDist5 = new SingleMagFreqDist(mag2, mag, 2);
                        } else {
                            totalMagFreqDist = new SummedMagFreqDist(mag, mag2, 2, false, false);
                            tempDist5 = new SingleMagFreqDist(mag, mag2, 2);
                        }
                        tempDist5.setMagAndMomentRate(mag, moRate * wt1);
                        totalMagFreqDist.addIncrementalMagFreqDist(tempDist5);
                        tempDist5.setMagAndMomentRate(mag2, moRate2 * wt2);
                        totalMagFreqDist.addIncrementalMagFreqDist(tempDist5);
                    }
                } else {
                    double test = mag + (Double)branchDmags.get(0);
                    maxMag = test >= 6.5 && aleStdDev != 0.0 ? mag + (Double)branchDmags.get(branchDmags.size() - 1) : mag;
                    if (fileName2 != null) {
                        test2 = mag2 + (Double)branchDmags.get(0);
                        maxMag2 = test2 >= 6.5 && aleStdDev != 0.0 ? mag2 + (Double)branchDmags.get(branchDmags.size() - 1) : mag2;
                        mHigh = maxMag2 > maxMag ? maxMag2 : maxMag;
                        mLow = magLower;
                        if (magLower != magLower2 || deltaMag != deltaMag2) {
                            throw new RuntimeException(C + ": Error - magLower & deltaMag must be same for both files");
                        }
                    } else {
                        mLow = magLower;
                        mHigh = maxMag;
                    }
                    numMag = Math.round((float)((mHigh - mLow) / deltaMag + 1.0));
                    totalMagFreqDist = new SummedMagFreqDist(mLow, mHigh, numMag, false, false);
                    GutenbergRichterMagFreqDist tempGR_dist = new GutenbergRichterMagFreqDist(mLow, mHigh, numMag);
                    if (test >= 6.5 && aleStdDev != 0.0) {
                        for (int i3 = 0; i3 < branchDmags.size(); ++i3) {
                            magEp = mag + (Double)branchDmags.get(i3);
                            wtEp = (Double)branchWts.get(i3);
                            tempGR_dist.setAllButTotCumRate(magLower, magEp, moRate * wtEp * wt1, bVal);
                            totalMagFreqDist.addIncrementalMagFreqDist(tempGR_dist);
                        }
                    } else {
                        tempGR_dist.setAllButTotCumRate(magLower, mag, moRate * wt1, bVal);
                        totalMagFreqDist.addIncrementalMagFreqDist(tempGR_dist);
                    }
                    if (fileName2 != null) {
                        if (test2 >= 6.5 && aleStdDev != 0.0) {
                            for (int i4 = 0; i4 < branchDmags.size(); ++i4) {
                                magEp = mag2 + (Double)branchDmags.get(i4);
                                wtEp = (Double)branchWts.get(i4);
                                tempGR_dist.setAllButTotCumRate(magLower2, magEp, moRate2 * wtEp * wt2, bVal2);
                                totalMagFreqDist.addIncrementalMagFreqDist(tempGR_dist);
                            }
                        } else {
                            tempGR_dist.setAllButTotCumRate(magLower2, mag2, moRate2 * wt2, bVal2);
                            totalMagFreqDist.addIncrementalMagFreqDist(tempGR_dist);
                        }
                    }
                }
            }
            if (this.D) {
                System.out.println("    " + sourceName);
            }
            st = new StringTokenizer(it.next().toString());
            dip = Double.parseDouble(st.nextToken());
            downDipWidth = Double.parseDouble(st.nextToken());
            double upperSeismoDepth = depthToTop = Double.parseDouble(st.nextToken());
            double lowerSeismoDepth = depthToTop + downDipWidth * Math.sin(Math.toRadians(Math.abs(dip)));
            int numOfDataLines = Integer.parseInt(it.next().toString().trim());
            FaultTrace faultTrace = new FaultTrace(sourceName);
            for (i = 0; i < numOfDataLines; ++i) {
                if (!it.hasNext()) {
                    throw ERR;
                }
                st = new StringTokenizer(it.next().toString().trim());
                double lat = new Double(st.nextToken());
                double lon = new Double(st.nextToken());
                Location loc = new Location(lat, lon, upperSeismoDepth);
                faultTrace.addLocation((Location)loc.clone());
            }
            if (dip < 0.0) {
                faultTrace.reverse();
                dip *= -1.0;
            }
            EvenlyGriddedSurfFromSimpleFaultData surface = faultModel.equals(FAULT_MODEL_FRANKEL) ? new FrankelGriddedSurface(faultTrace, dip, upperSeismoDepth, lowerSeismoDepth, gridSpacing) : new StirlingGriddedSurface(faultTrace, dip, upperSeismoDepth, lowerSeismoDepth, gridSpacing);
            if (this.D) {
                System.out.println(totalMagFreqDist);
                for (int n2 = 0; n2 < totalMagFreqDist.getNum(); ++n2) {
                    System.out.println("\t" + (float)totalMagFreqDist.getX(n2) + "  " + (float)totalMagFreqDist.getY(n2));
                }
            }
            if (magFreqDistType.equals(this.CHAR_MAG_FREQ_DIST)) {
                FaultRuptureSource frs = new FaultRuptureSource(totalMagFreqDist, (EvenlyGriddedSurface)surface, rake, duration);
                frs.setName(sourceName);
                this.charFaultSources.add(frs);
                continue;
            }
            Frankel02_GR_EqkSource fgrs = new Frankel02_GR_EqkSource(totalMagFreqDist, surface, rupOffset, rake, duration, sourceName);
            this.grFaultSources.add(fgrs);
        }
        inputFaultFileLines1 = null;
        inputFaultFileLines2 = null;
    }

    public ArrayList getAllCharFaultSources() {
        return this.charFaultSources;
    }

    public ArrayList getAllGR_FaultSources() {
        return this.grFaultSources;
    }

    private void makeGridSources(String fileName1, double wt1, String fileName2, double wt2) {
        String S = C + ": makeGridSources(): ";
        double locMagMax2 = 0.0;
        double strike = Double.NaN;
        ArrayList inputGridFileLines1 = null;
        try {
            inputGridFileLines1 = FileUtils.loadJarFile(IN_FILE_PATH + fileName1);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        if (this.D) {
            System.out.println("fileName1 = org/opensha/sha/earthquake/rupForecastImpl/Frankel02/InputFiles/" + fileName1);
        }
        ArrayList inputGridFileLines2 = null;
        if (fileName2 != null) {
            try {
                inputGridFileLines2 = FileUtils.loadJarFile(IN_FILE_PATH + fileName2);
            }
            catch (FileNotFoundException e) {
                System.out.println(e.toString());
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
            if (this.D) {
                System.out.println("fileName2 = org/opensha/sha/earthquake/rupForecastImpl/Frankel02/InputFiles/" + fileName2);
            }
        }
        double duration = this.timeSpan.getDuration();
        ListIterator it = inputGridFileLines1.listIterator();
        StringTokenizer st = new StringTokenizer(it.next().toString());
        double bVal = Double.parseDouble(st.nextToken());
        double magMin = Double.parseDouble(st.nextToken());
        double magMax = Double.parseDouble(st.nextToken());
        double deltaMag = Double.parseDouble(st.nextToken());
        double magRef = Double.parseDouble(st.nextToken());
        if (this.D) {
            System.out.println(fileName1);
        }
        st = new StringTokenizer(it.next().toString());
        int iflt = Integer.parseInt(st.nextToken());
        st.nextToken();
        int maxmat = Integer.parseInt(st.nextToken());
        if (iflt == 2 && (strike = Double.parseDouble((st = new StringTokenizer(it.next().toString())).nextToken())) < 0.0) {
            strike += 360.0;
        }
        if (this.D) {
            System.out.println("bVal=" + bVal + "  magMin=" + magMin + "  magMax=" + magMax + "  deltaMag" + deltaMag + "  iflt=" + iflt + "  maxmat=" + maxmat);
        }
        if (magMin != magMax) {
            magMin += deltaMag / 2.0;
        }
        while (it.hasNext()) {
            IncrementalMagFreqDist magFreqDist;
            double moRate;
            int numMag;
            double locMagMax1;
            st = new StringTokenizer(it.next().toString());
            double lon = Double.parseDouble(st.nextToken());
            double lat = Double.parseDouble(st.nextToken());
            double rateAtZeroMag = Double.parseDouble(st.nextToken());
            double aVal = 0.434294 * Math.log(rateAtZeroMag);
            Location loc = new Location(lat, lon, 5.0);
            if (maxmat == 1) {
                magMax = locMagMax1 = Double.parseDouble(st.nextToken());
                if (fileName2 != null) {
                    st = new StringTokenizer((String)inputGridFileLines2.get(it.nextIndex() - 1));
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    locMagMax2 = Double.parseDouble(st.nextToken());
                    if (locMagMax2 > magMax) {
                        magMax = locMagMax2;
                    }
                }
            } else {
                locMagMax1 = magMax;
            }
            if (fileName2 == null) {
                numMag = Math.round((float)(((locMagMax1 -= deltaMag / 2.0) - magMin) / deltaMag)) + 1;
                moRate = this.getMomentRate(magMin, numMag, deltaMag, aVal, bVal);
                magFreqDist = new GutenbergRichterMagFreqDist(magMin, numMag, deltaMag, moRate * wt1, bVal);
            } else {
                numMag = Math.round((float)(((magMax -= deltaMag / 2.0) - magMin) / deltaMag)) + 1;
                SummedMagFreqDist tempDist = new SummedMagFreqDist(magMin, numMag, deltaMag, false, false);
                int numMag1 = Math.round((float)(((locMagMax1 -= deltaMag / 2.0) - magMin) / deltaMag)) + 1;
                moRate = this.getMomentRate(magMin, numMag1, deltaMag, aVal, bVal);
                tempDist.addIncrementalMagFreqDist(new GutenbergRichterMagFreqDist(magMin, numMag, deltaMag, magMin, locMagMax1, moRate * wt1, bVal));
                int numMag2 = Math.round((float)(((locMagMax2 -= deltaMag / 2.0) - magMin) / deltaMag)) + 1;
                moRate = this.getMomentRate(magMin, numMag2, deltaMag, aVal, bVal);
                tempDist.addIncrementalMagFreqDist(new GutenbergRichterMagFreqDist(magMin, numMag, deltaMag, magMin, locMagMax2, moRate * wt2, bVal));
                magFreqDist = tempDist;
            }
            String backSeisRup = (String)this.backSeisRupParam.getValue();
            double magCutOff = backSeisRup.equals(BACK_SEIS_RUP_FINITE) ? 6.0 : 10.0;
            Point2Vert_SS_FaultPoisSource src = iflt == 2 ? new Point2Vert_SS_FaultPoisSource(loc, magFreqDist, this.magLenRel, strike, duration, magCutOff) : new Point2Vert_SS_FaultPoisSource(loc, magFreqDist, this.magLenRel, duration, magCutOff);
            this.frankelBackgrSeisSources.add(src);
        }
        inputGridFileLines1 = null;
        inputGridFileLines2 = null;
    }

    public ProbEqkSource getSource(int iSource) {
        double timeDuration = this.timeSpan.getDuration();
        return (ProbEqkSource)this.allSources.get(iSource);
    }

    public int getNumSources() {
        return this.allSources.size();
    }

    public ArrayList getSourceList() {
        return this.allSources;
    }

    public String getName() {
        return NAME;
    }

    public void updateForecast() {
        if (this.parameterChangeFlag) {
            String backSeis = (String)this.backSeisParam.getValue();
            this.allSources = new ArrayList();
            this.charFaultSources = new ArrayList();
            this.grFaultSources = new ArrayList();
            this.frankelBackgrSeisSources = new ArrayList();
            if (backSeis.equalsIgnoreCase(BACK_SEIS_INCLUDE)) {
                this.makeAllFaultSources();
                this.makeAllGridSources();
                this.allSources.addAll(this.charFaultSources);
                this.allSources.addAll(this.grFaultSources);
                this.allSources.addAll(this.frankelBackgrSeisSources);
            } else if (backSeis.equalsIgnoreCase(BACK_SEIS_EXCLUDE)) {
                this.makeAllFaultSources();
                this.frankelBackgrSeisSources = null;
                this.allSources.addAll(this.charFaultSources);
                this.allSources.addAll(this.grFaultSources);
            } else {
                this.makeAllGridSources();
                this.charFaultSources = null;
                this.grFaultSources = null;
                this.allSources.addAll(this.frankelBackgrSeisSources);
            }
            this.parameterChangeFlag = false;
        }
    }

    private double getMomentRate(double magLower, int numMag, double deltaMag, double aVal, double bVal) {
        double mo = 0.0;
        for (int i = 0; i < numMag; ++i) {
            double mag = magLower + (double)i * deltaMag;
            mo += Math.pow(10.0, aVal - bVal * mag + 1.5 * mag + 9.05);
        }
        return mo;
    }

    public void parameterChange(ParameterChangeEvent event) {
        super.parameterChange(event);
        String paramName = event.getParameterName();
        if (paramName.equals(BACK_SEIS_NAME)) {
            String paramValue = (String)event.getNewValue();
            if (paramValue.equals(BACK_SEIS_EXCLUDE)) {
                if (this.adjustableParams.containsParameter(this.backSeisRupParam)) {
                    this.adjustableParams.removeParameter(this.backSeisRupParam);
                }
            } else if (!this.adjustableParams.containsParameter(this.backSeisRupParam)) {
                this.adjustableParams.addParameter(this.backSeisRupParam);
            }
        }
    }

    public static void main(String[] args) {
        Frankel02_AdjustableEqkRupForecast frankCast = new Frankel02_AdjustableEqkRupForecast();
        frankCast.updateForecast();
        try {
            frankCast.writeRuptureTraces();
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
            System.exit(0);
        }
        int totSrc = frankCast.getNumSources();
        for (int i = 0; i < totSrc; ++i) {
            ProbEqkSource src = frankCast.getSource(i);
            System.out.println(i + "\t" + src.getName());
        }
    }

    public void writeRuptureTraces() throws IOException {
        Location loc;
        int n;
        EvenlyGriddedSurfaceAPI surf;
        double rake;
        ProbEqkSource src;
        int i;
        String filename1 = "javaDevelopers/ned/NSHMP02_CA_Traces_SS.txt";
        String filename2 = "javaDevelopers/ned/NSHMP02_CA_Traces_N.txt";
        String filename3 = "javaDevelopers/ned/NSHMP02_CA_Traces_RV.txt";
        FileWriter fw1 = new FileWriter(filename1);
        FileWriter fw2 = new FileWriter(filename2);
        FileWriter fw3 = new FileWriter(filename3);
        for (i = 0; i < 155; ++i) {
            src = (ProbEqkSource)this.charFaultSources.get(i);
            rake = src.getRupture(src.getNumRuptures() - 1).getAveRake();
            if (rake == 0.0) {
                fw1.write("#" + src.getName() + "\n");
            } else if (rake == -90.0) {
                fw2.write("#" + src.getName() + "\n");
            } else if (rake == 90.0) {
                fw3.write("#" + src.getName() + "\n");
            } else {
                System.out.println("ERROR!!!!!!!!!!!");
            }
            System.out.println(i + "  " + src.getName());
            surf = src.getRupture(src.getNumRuptures() - 1).getRuptureSurface();
            for (n = 0; n < surf.getNumCols(); ++n) {
                loc = surf.getLocation(0, n);
                if (rake == 0.0) {
                    fw1.write((float)loc.getLongitude() + "\t" + (float)loc.getLatitude() + "\t" + (float)loc.getDepth() + "\n");
                    continue;
                }
                if (rake == -90.0) {
                    fw2.write((float)loc.getLongitude() + "\t" + (float)loc.getLatitude() + "\t" + (float)loc.getDepth() + "\n");
                    continue;
                }
                if (rake == 90.0) {
                    fw3.write((float)loc.getLongitude() + "\t" + (float)loc.getLatitude() + "\t" + (float)loc.getDepth() + "\n");
                    continue;
                }
                System.out.println("ERROR!!!!!!!!!!!");
            }
        }
        int[] others1 = new int[]{155, 162, 169, 174, 180, 186, 193, 199, 205, 211, 221, 233, 242, 248, 254, 260, 261, 262, 263, 270, 277, 285, 286, 287, 299, 300, 312, 323, 330, 337, 343, 353, 362, 369};
        for (i = 0; i < others1.length; ++i) {
            src = (ProbEqkSource)this.charFaultSources.get(others1[i]);
            System.out.println(others1[i] + "\t" + src.getName());
            rake = src.getRupture(src.getNumRuptures() - 1).getAveRake();
            if (rake == 0.0) {
                fw1.write("#" + src.getName() + "\n");
            } else if (rake == -90.0) {
                fw2.write("#" + src.getName() + "\n");
            } else if (rake == 90.0) {
                fw3.write("#" + src.getName() + "\n");
            } else {
                System.out.println("ERROR!!!!!!!!!!!");
            }
            surf = src.getRupture(src.getNumRuptures() - 1).getRuptureSurface();
            for (n = 0; n < surf.getNumCols(); ++n) {
                loc = surf.getLocation(0, n);
                if (rake == 0.0) {
                    fw1.write((float)loc.getLongitude() + "\t" + (float)loc.getLatitude() + "\t" + (float)loc.getDepth() + "\n");
                    continue;
                }
                if (rake == -90.0) {
                    fw2.write((float)loc.getLongitude() + "\t" + (float)loc.getLatitude() + "\t" + (float)loc.getDepth() + "\n");
                    continue;
                }
                if (rake == 90.0) {
                    fw3.write((float)loc.getLongitude() + "\t" + (float)loc.getLatitude() + "\t" + (float)loc.getDepth() + "\n");
                    continue;
                }
                System.out.println("ERROR!!!!!!!!!!!");
            }
        }
        int[] others2 = new int[]{94, 105};
        for (i = 0; i < others2.length; ++i) {
            src = (ProbEqkSource)this.grFaultSources.get(others2[i]);
            System.out.println(others2[i] + "\t" + src.getName());
            rake = src.getRupture(src.getNumRuptures() - 1).getAveRake();
            if (rake == 0.0) {
                fw1.write("#" + src.getName() + "\n");
            } else if (rake == -90.0) {
                fw2.write("#" + src.getName() + "\n");
            } else if (rake == 90.0) {
                fw3.write("#" + src.getName() + "\n");
            } else {
                System.out.println("ERROR!!!!!!!!!!!");
            }
            surf = src.getRupture(src.getNumRuptures() - 1).getRuptureSurface();
            for (n = 0; n < surf.getNumCols(); ++n) {
                loc = surf.getLocation(0, n);
                if (rake == 0.0) {
                    fw1.write((float)loc.getLongitude() + "\t" + (float)loc.getLatitude() + "\t" + (float)loc.getDepth() + "\n");
                    continue;
                }
                if (rake == -90.0) {
                    fw2.write((float)loc.getLongitude() + "\t" + (float)loc.getLatitude() + "\t" + (float)loc.getDepth() + "\n");
                    continue;
                }
                if (rake == 90.0) {
                    fw3.write((float)loc.getLongitude() + "\t" + (float)loc.getLatitude() + "\t" + (float)loc.getDepth() + "\n");
                    continue;
                }
                System.out.println("ERROR!!!!!!!!!!!");
            }
        }
        System.out.println("113\tSAF - creeping segment");
        fw1.write("#SAF - creeping segment\n-121.506\t36.8237\n-121.289\t36.6829\n-120.872\t36.2939\n-120.561\t36.0019\n");
        fw1.close();
        fw2.close();
        fw3.close();
    }
}

