/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Frankel02;

import java.io.Serializable;
import org.opensha.calc.RelativeLocation;
import org.opensha.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.data.Direction;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.Site;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.fault.FaultTrace;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.surface.FrankelGriddedSurface;
import org.opensha.sha.surface.GriddedSubsetSurface;
import org.opensha.sha.surface.PointSurface;

public class Point2Vert_SS_FaultPoisSource
extends ProbEqkSource
implements Serializable {
    private static String C = new String("Point2Vert_SS_FaultPoisSource");
    private boolean D = false;
    private IncrementalMagFreqDist magFreqDist;
    private static final double aveDip = 90.0;
    private static final double aveRake = 0.0;
    private double duration;
    private MagLengthRelationship magLengthRelationship;
    private double magCutOff;
    private PointSurface ptSurface;
    private FrankelGriddedSurface finiteFault;

    public Point2Vert_SS_FaultPoisSource(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double strike, double duration, double magCutOff) {
        this.magCutOff = magCutOff;
        this.probEqkRupture = new ProbEqkRupture();
        this.probEqkRupture.setAveRake(0.0);
        if (this.D) {
            System.out.println("magCutOff=" + magCutOff);
            System.out.println("num pts in magFreqDist=" + magFreqDist.getNum());
        }
        this.setAll(loc, magFreqDist, magLengthRelationship, strike, duration);
    }

    public Point2Vert_SS_FaultPoisSource(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double duration, double magCutOff) {
        this.magCutOff = magCutOff;
        this.probEqkRupture = new ProbEqkRupture();
        this.probEqkRupture.setAveRake(0.0);
        this.setAll(loc, magFreqDist, magLengthRelationship, duration);
    }

    public void setAll(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double duration) {
        double strike = (Math.random() - 0.5) * 180.0;
        if (strike < 0.0) {
            strike += 360.0;
        }
        this.setAll(loc, magFreqDist, magLengthRelationship, strike, duration);
    }

    public void setAll(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double strike, double duration) {
        if (this.D) {
            System.out.println("duration=" + duration);
        }
        if (this.D) {
            System.out.println("strike=" + strike);
        }
        this.duration = duration;
        this.magFreqDist = magFreqDist;
        this.magLengthRelationship = magLengthRelationship;
        this.ptSurface = new PointSurface(loc);
        this.ptSurface.setAveDip(90.0);
        this.ptSurface.setAveStrike(strike);
        double maxMag = magFreqDist.getX(magFreqDist.getNum() - 1);
        if (maxMag > this.magCutOff) {
            double halfLength = magLengthRelationship.getMedianLength(maxMag) / 2.0;
            Location loc1 = RelativeLocation.getLocation(loc, new Direction(0.0, halfLength, strike, Double.NaN));
            Direction dir = RelativeLocation.getDirection(loc1, loc);
            dir.setHorzDistance(dir.getHorzDistance() * 2.0);
            Location loc2 = RelativeLocation.getLocation(loc1, dir);
            FaultTrace fault = new FaultTrace("");
            fault.addLocation(loc1);
            fault.addLocation(loc2);
            this.finiteFault = new FrankelGriddedSurface(fault, 90.0, loc.getDepth(), loc.getDepth(), 1.0);
        }
    }

    public LocationList getAllSourceLocs() {
        if (this.finiteFault != null) {
            return this.finiteFault.getLocationList();
        }
        return this.ptSurface.getLocationList();
    }

    public int getNumRuptures() {
        return this.magFreqDist.getNum();
    }

    public ProbEqkRupture getRupture(int nthRupture) {
        double mag = this.magFreqDist.getX(nthRupture);
        this.probEqkRupture.setMag(mag);
        double prob = 1.0 - Math.exp(-this.duration * this.magFreqDist.getY(nthRupture));
        this.probEqkRupture.setProbability(prob);
        if (mag <= this.magCutOff) {
            this.probEqkRupture.setRuptureSurface(this.ptSurface);
        } else if (nthRupture == this.magFreqDist.getNum() - 1) {
            this.probEqkRupture.setRuptureSurface(this.finiteFault);
        } else {
            double rupLen = this.magLengthRelationship.getMedianLength(mag);
            double startPoint = (double)this.finiteFault.getNumCols() / 2.0 - 0.5 - rupLen / 2.0;
            GriddedSubsetSurface rupSurf = new GriddedSubsetSurface(1, Math.round((float)rupLen + 1.0f), 0, Math.round((float)startPoint), this.finiteFault);
            this.probEqkRupture.setRuptureSurface(rupSurf);
        }
        return this.probEqkRupture;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getDuration() {
        return this.duration;
    }

    public double getMinDistance(Site site) {
        return RelativeLocation.getHorzDistance(site.getLocation(), this.ptSurface);
    }

    public String getName() {
        return C;
    }

    public static void main(String[] args) {
        Location loc = new Location(34.0, -118.0, 0.0);
        GutenbergRichterMagFreqDist dist = new GutenbergRichterMagFreqDist(5.0, 16, 0.2, 1.0E17, 0.9);
        WC1994_MagLengthRelationship wc_rel = new WC1994_MagLengthRelationship();
        Point2Vert_SS_FaultPoisSource src = new Point2Vert_SS_FaultPoisSource(loc, dist, wc_rel, 1.0, 6.0);
        System.out.println("num rups =" + src.getNumRuptures());
        System.out.println("Rupture mags and end locs:");
        for (int r = 0; r < src.getNumRuptures(); ++r) {
            ProbEqkRupture rup = src.getRupture(r);
            Location loc1 = rup.getRuptureSurface().getLocation(0, 0);
            Location loc2 = rup.getRuptureSurface().getLocation(0, rup.getRuptureSurface().getNumCols() - 1);
            double length = RelativeLocation.getHorzDistance(loc1, loc2);
            double aveLat = (loc1.getLatitude() + loc2.getLatitude()) / 2.0;
            double aveLon = (loc1.getLongitude() + loc2.getLongitude()) / 2.0;
            System.out.println("\t" + (float)rup.getMag() + "\tlen1=" + (float)wc_rel.getMedianLength(rup.getMag()) + "\tlen2=" + (float)length + "\taveLat=" + (float)aveLat + "\taveLon=" + (float)aveLon);
        }
    }
}

