/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Frankel02.validation;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.opensha.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.data.region.SitesInGriddedRectangularRegion;
import org.opensha.exceptions.ParameterException;
import org.opensha.exceptions.RegionConstraintException;
import org.opensha.param.ParameterList;
import org.opensha.param.WarningParameterAPI;
import org.opensha.param.event.ParameterChangeWarningEvent;
import org.opensha.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.remoteERF_Clients.Frankel02_AdjustableEqkRupForecastClient;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.AttenuationRelationshipAPI;
import org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel;

public class HazardMapUsingGridStandaloneApplicationUsingFrankel02
implements ParameterChangeWarningListener {
    protected static final String C = "HazardMapApplet";
    protected static final boolean D = false;
    public static String SERVLET_URL = "http://gravity.usc.edu/OpenSHA/servlet/HazardMapCalcServlet";
    public static String DATASET_CHECK_SERVLET_URL = "http://gravity.usc.edu/OpenSHA/servlet/DatasetIdAndMetadataCheckServlet";
    private SitesInGriddedRectangularRegion griddedRegionSites;
    private AttenuationRelationship attenRel;
    private ArbitrarilyDiscretizedFunc function;
    private IMT_Info imtInfo = new IMT_Info();
    private Frankel02_AdjustableEqkRupForecastClient forecast = null;
    private final double MIN_LAT = 33.5;
    private final double MAX_LAT = 34.7;
    private final double MIN_LON = -119.5;
    private final double MAX_LON = -117.0;
    private final double GRID_SPACING = 0.1;

    public HazardMapUsingGridStandaloneApplicationUsingFrankel02() throws RegionConstraintException {
        this.init();
        this.run();
    }

    public void init() throws RegionConstraintException {
        try {
            this.initIMRGuiBean();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return;
        }
        this.initGriddedRegionGuiBean();
        this.initIMTGuiBean();
        try {
            this.initERFSelector_GuiBean();
            this.initTimeSpanGuiBean();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        try {
            HazardMapUsingGridStandaloneApplicationUsingFrankel02 app = new HazardMapUsingGridStandaloneApplicationUsingFrankel02();
        }
        catch (RegionConstraintException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(0);
        }
    }

    private void initGriddedRegionGuiBean() throws RegionConstraintException {
        this.griddedRegionSites = new SitesInGriddedRectangularRegion(33.5, 34.7, -119.5, -117.0, 0.1);
        this.griddedRegionSites.addSiteParams(this.attenRel.getSiteParamsIterator());
        this.griddedRegionSites.setSameSiteParams();
    }

    private void initIMTGuiBean() {
        this.attenRel.setIntensityMeasure("PGA");
    }

    private void initIMRGuiBean() {
        this.attenRel = new BJF_1997_AttenRel(this);
        this.attenRel.getParameter("Gaussian Truncation").setValue("1 Sided");
        this.attenRel.getParameter("Truncation Level").setValue(new Double(3.0));
        this.attenRel.getParameter("Component").setValue("Random Horizontal");
        this.attenRel.getParameter("Std Dev Type").setValue("Total");
        this.attenRel.getParameter("Vs30").setValue(new Double(760.0));
    }

    private void initERFSelector_GuiBean() {
        try {
            this.forecast = new Frankel02_AdjustableEqkRupForecastClient();
            ParameterList forecastParamList = this.forecast.getAdjustableParameterList();
            forecastParamList.getParameter(Frankel02_AdjustableEqkRupForecast.FAULT_MODEL_NAME).setValue(Frankel02_AdjustableEqkRupForecast.FAULT_MODEL_FRANKEL);
            forecastParamList.getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_INCLUDE);
            forecastParamList.getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_FINITE);
            forecastParamList.getParameter("Rupture Offset").setValue(new Double(1.0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTimeSpanGuiBean() {
    }

    public void setX_ValuesForHazardCurve() {
        this.function = new ArbitrarilyDiscretizedFunc();
        this.function.set(0.005, 1.0);
        this.function.set(0.007, 1.0);
        this.function.set(0.0098, 1.0);
        this.function.set(0.0137, 1.0);
        this.function.set(0.0192, 1.0);
        this.function.set(0.0269, 1.0);
        this.function.set(0.0376, 1.0);
        this.function.set(0.0527, 1.0);
        this.function.set(0.0738, 1.0);
        this.function.set(0.103, 1.0);
        this.function.set(0.145, 1.0);
        this.function.set(0.203, 1.0);
        this.function.set(0.284, 1.0);
        this.function.set(0.397, 1.0);
        this.function.set(0.556, 1.0);
        this.function.set(0.778, 1.0);
        this.function.set(1.09, 1.0);
        this.function.set(1.52, 1.0);
        this.function.set(2.13, 1.0);
    }

    public void run() {
        try {
            Object obj = this.checkForHazardMapComputation();
            if (obj instanceof String) {
                return;
            }
            if (obj instanceof Boolean) {
                this.setX_ValuesForHazardCurve();
                String eqkRupForecastLocation = this.forecast.updateAndSaveForecast();
                System.out.println("Location for Eqk is:" + eqkRupForecastLocation);
                this.sendParametersToServlet(this.griddedRegionSites, this.attenRel, eqkRupForecastLocation);
            }
        }
        catch (ParameterException ee) {
            ee.printStackTrace();
            return;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return;
        }
    }

    private Object checkForHazardMapComputation() {
        try {
            URL hazardMapServlet = new URL(DATASET_CHECK_SERVLET_URL);
            URLConnection servletConnection = hazardMapServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream toServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            toServlet.writeObject(this.getParametersInfo());
            toServlet.writeObject("frankel02_Standalone");
            toServlet.flush();
            toServlet.close();
            ObjectInputStream fromServlet = new ObjectInputStream(servletConnection.getInputStream());
            Object obj = fromServlet.readObject();
            fromServlet.close();
            return obj;
        }
        catch (Exception e) {
            System.out.println("Exception in connection with servlet:" + e);
            e.printStackTrace();
            return null;
        }
    }

    private void sendParametersToServlet(SitesInGriddedRectangularRegion regionSites, AttenuationRelationshipAPI imr, String eqkRupForecastLocation) {
        try {
            URL hazardMapServlet = new URL(SERVLET_URL);
            URLConnection servletConnection = hazardMapServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream toServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            toServlet.writeObject(regionSites);
            toServlet.writeObject(imr);
            toServlet.writeObject(eqkRupForecastLocation);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < this.function.getNum(); ++i) {
                list.add(new String("" + this.function.getX(i)));
            }
            toServlet.writeObject(list);
            Double maxDistance = new Double(200.0);
            toServlet.writeObject(maxDistance);
            toServlet.writeObject("niting@usc.edu");
            toServlet.writeObject(this.getParametersInfo());
            toServlet.writeObject("frankel02_Standalone");
            toServlet.flush();
            toServlet.close();
            ObjectInputStream fromServlet = new ObjectInputStream(servletConnection.getInputStream());
            String dataset = fromServlet.readObject().toString();
            System.out.println("Receiving the Input from the Servlet:" + dataset);
            fromServlet.close();
        }
        catch (Exception e) {
            System.out.println("Exception in connection with servlet:" + e);
            e.printStackTrace();
        }
    }

    public String getParametersInfo() {
        return "IMR Param List:\n---------------\nIMR = Boore, Joyner & Fumal (1997); Gaussian Truncation = 1 Sided; Truncation Level = 3.0; Component = Random Horizontal; Std Dev Type = Total\n\nRegion Param List: \n----------------\nMin Longitude = -119.5; Max Longitude = -117.0; Min  Latitude = 33.5; Max  Latitude = 34.7; Grid Spacing = 0.1; Set Site Params = Apply same site parameter(s) to all locations; Vs30 = 760.0\n\nIMT Param List: \n---------------\nIMT = PGA\n\nForecast Param List:\n--------------------\nEqk Rup Forecast = USGS/CGS 2002 Adj. Cal. ERF; Fault Model = Frankel's; Rupture Offset = 1.0; Background Seismicity = Include; Treat Background Seismicity As = Finite Sources\n\nTimeSpan Param List:\n--------------------\nDuration = 50.0\n\n Control Panel \n-------------------\nSite Source distance Control Panel =200kms\n\nX Values Control panel\n----------------------\n0.0050,0.0070,0.0098,0.0137,0.0192,0.0269,0.0376,0.0527,0.0738,0.103,0.145,0.203,0.284,0.397,0.556,0.778,1.09,1.52,2.13\n";
    }

    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        String S = " : parameterChangeWarning(): ";
        WarningParameterAPI param = e.getWarningParameter();
        param.setValueIgnoreWarning(e.getNewValue());
    }
}

