/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.calc.RelativeLocation;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.Site;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class PointEqkSource
extends ProbEqkSource
implements Serializable {
    private static String C = new String("PointEqkSource");
    private static String NAME = "Point Eqk Source";
    private boolean D = false;
    private Location location;
    private double aveDip = Double.NaN;
    private double aveRake = Double.NaN;
    private double duration = Double.NaN;
    private double minMag = Double.NaN;
    private ArrayList mags;
    private ArrayList rates;

    public PointEqkSource(Location loc, IncrementalMagFreqDist magFreqDist, double duration, double aveRake, double aveDip, double minMag) {
        this.location = loc;
        this.duration = duration;
        this.aveRake = aveRake;
        this.aveDip = aveDip;
        this.minMag = minMag;
        this.setMagFreqDist(magFreqDist);
        this.isPoissonian = true;
        this.probEqkRupture = new ProbEqkRupture();
        this.probEqkRupture.setPointSurface(this.location, aveDip);
        this.probEqkRupture.setAveRake(aveRake);
    }

    public PointEqkSource(Location loc, IncrementalMagFreqDist magFreqDist, double duration, double aveRake, double aveDip) {
        this(loc, magFreqDist, duration, aveRake, aveDip, 0.0);
    }

    public PointEqkSource(Location loc, double magnitude, double probability, double aveRake, double aveDip) {
        this.location = loc;
        this.aveRake = aveRake;
        this.aveDip = aveDip;
        this.mags = new ArrayList();
        this.mags.add(new Double(magnitude));
        this.isPoissonian = false;
        this.probEqkRupture = new ProbEqkRupture();
        this.probEqkRupture.setPointSurface(this.location, aveDip);
        this.probEqkRupture.setAveRake(aveRake);
        this.probEqkRupture.setProbability(probability);
    }

    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        locList.addLocation(this.location);
        return locList;
    }

    private void setMagFreqDist(IncrementalMagFreqDist magFreqDist) {
        this.mags = new ArrayList();
        this.rates = new ArrayList();
        for (int i = 0; i < magFreqDist.getNum(); ++i) {
            if (!(magFreqDist.getY(i) > 0.0) || !(magFreqDist.getX(i) >= this.minMag)) continue;
            this.mags.add(new Double(magFreqDist.getX(i)));
            this.rates.add(new Double(magFreqDist.getY(i)));
        }
    }

    public int getNumRuptures() {
        return this.mags.size();
    }

    public ProbEqkRupture getRupture(int nthRupture) {
        this.probEqkRupture.setMag((Double)this.mags.get(nthRupture));
        if (this.isPoissonian) {
            this.probEqkRupture.setProbability(1.0 - Math.exp(-this.duration * (Double)this.rates.get(nthRupture)));
        }
        return this.probEqkRupture;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setLocation(Location loc) {
        this.location = loc;
        this.probEqkRupture.setPointSurface(this.location, this.aveDip);
    }

    public Location getLocation() {
        return this.location;
    }

    public double getMinMag() {
        return this.minMag;
    }

    public double getMinDistance(Site site) {
        return RelativeLocation.getHorzDistance(site.getLocation(), this.location);
    }

    public String getName() {
        return C;
    }
}

