/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.util.ArrayList;
import org.opensha.data.Location;
import org.opensha.param.DoubleParameter;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.PointEqkSource;

public class PointSourceERF
extends EqkRupForecast {
    private static String C = "PointSourceERF";
    private boolean D = true;
    public static final String NAME = "Point Source ERF";
    private PointEqkSource source;
    public static final String MAG_PARAM_NAME = "Magnitude Probability";
    private static final String MAG_PARAM_INFO = "The  magnitude of the rupture";
    private static final String MAG_PARAM_UNITS = null;
    private Double MAG_PARAM_MIN = new Double(0.0);
    private Double MAG_PARAM_MAX = new Double(10.0);
    private Double MAG_PARAM_DEFAULT = new Double(7.0);
    public static final String PROB_PARAM_NAME = "Source Probability";
    private static final String PROB_PARAM_INFO = "The probability of the rupture";
    private static final String PROB_PARAM_UNITS = null;
    private Double PROB_PARAM_MIN = new Double(0.0);
    private Double PROB_PARAM_MAX = new Double(1.0);
    private Double PROB_PARAM_DEFAULT = new Double(1.0);
    public static final String RAKE_PARAM_NAME = "Rake";
    private static final String RAKE_PARAM_INFO = "The rake of the rupture (direction of slip)";
    private static final String RAKE_PARAM_UNITS = "degrees";
    private Double RAKE_PARAM_MIN = new Double(-180.0);
    private Double RAKE_PARAM_MAX = new Double(180.0);
    private Double RAKE_PARAM_DEFAULT = new Double(0.0);
    public static final String DIP_PARAM_NAME = "Dip";
    private static final String DIP_PARAM_INFO = "The dip of the rupture surface";
    private static final String DIP_PARAM_UNITS = "degrees";
    private Double DIP_PARAM_MIN = new Double(0.0);
    private Double DIP_PARAM_MAX = new Double(90.0);
    private Double DIP_PARAM_DEFAULT = new Double(90.0);
    public static final String SRC_LAT_PARAM_NAME = "Source Latitude";
    private static final String SRC_LAT_PARAM_INFO = "Latitude of the point source";
    private static final String SRC_LAT_PARAM_UNITS = "Degrees";
    private Double SRC_LAT_PARAM_MIN = new Double(-90.0);
    private Double SRC_LAT_PARAM_MAX = new Double(90.0);
    private Double SRC_LAT_PARAM_DEFAULT = new Double(35.71);
    public static final String SRC_LON_PARAM_NAME = "Source Longitude";
    private static final String SRC_LON_PARAM_INFO = "Longitude of the point source";
    private static final String SRC_LON_PARAM_UNITS = "Degrees";
    private Double SRC_LON_PARAM_MIN = new Double(-360.0);
    private Double SRC_LON_PARAM_MAX = new Double(360.0);
    private Double SRC_LON_PARAM_DEFAULT = new Double(-121.1);
    public static final String SRC_DEPTH_PARAM_NAME = "Source Depth";
    private static final String SRC_DEPTH_PARAM_INFO = "Depth of the point source";
    private static final String SRC_DEPTH_PARAM_UNITS = "km";
    private Double SRC_DEPTH_PARAM_MIN = new Double(0.0);
    private Double SRC_DEPTH_PARAM_MAX = new Double(50.0);
    private Double SRC_DEPTH_PARAM_DEFAULT = new Double(7.6);
    DoubleParameter magParam;
    DoubleParameter probParam;
    DoubleParameter dipParam;
    DoubleParameter rakeParam;
    DoubleParameter srcLatParam;
    DoubleParameter srcLonParam;
    DoubleParameter srcDepthParam;

    public PointSourceERF() {
        this.timeSpan = null;
        this.magParam = new DoubleParameter(MAG_PARAM_NAME, this.MAG_PARAM_MIN, this.MAG_PARAM_MAX, MAG_PARAM_UNITS, this.MAG_PARAM_DEFAULT);
        this.magParam.setInfo(MAG_PARAM_INFO);
        this.probParam = new DoubleParameter(PROB_PARAM_NAME, this.PROB_PARAM_MIN, this.PROB_PARAM_MAX, PROB_PARAM_UNITS, this.PROB_PARAM_DEFAULT);
        this.probParam.setInfo(PROB_PARAM_INFO);
        this.rakeParam = new DoubleParameter(RAKE_PARAM_NAME, this.RAKE_PARAM_MIN, this.RAKE_PARAM_MAX, "degrees", this.RAKE_PARAM_DEFAULT);
        this.rakeParam.setInfo(RAKE_PARAM_INFO);
        this.dipParam = new DoubleParameter(DIP_PARAM_NAME, this.DIP_PARAM_MIN, this.DIP_PARAM_MAX, "degrees", this.DIP_PARAM_DEFAULT);
        this.dipParam.setInfo(DIP_PARAM_INFO);
        this.srcLatParam = new DoubleParameter(SRC_LAT_PARAM_NAME, this.SRC_LAT_PARAM_MIN, this.SRC_LAT_PARAM_MAX, "Degrees", this.SRC_LAT_PARAM_DEFAULT);
        this.srcLatParam.setInfo(SRC_LAT_PARAM_INFO);
        this.srcLonParam = new DoubleParameter(SRC_LON_PARAM_NAME, this.SRC_LON_PARAM_MIN, this.SRC_LON_PARAM_MAX, "Degrees", this.SRC_LON_PARAM_DEFAULT);
        this.srcLonParam.setInfo(SRC_LON_PARAM_INFO);
        this.srcDepthParam = new DoubleParameter(SRC_DEPTH_PARAM_NAME, this.SRC_DEPTH_PARAM_MIN, this.SRC_DEPTH_PARAM_MAX, SRC_DEPTH_PARAM_UNITS, this.SRC_DEPTH_PARAM_DEFAULT);
        this.srcDepthParam.setInfo(SRC_DEPTH_PARAM_INFO);
        this.adjustableParams.addParameter(this.magParam);
        this.adjustableParams.addParameter(this.probParam);
        this.adjustableParams.addParameter(this.srcLatParam);
        this.adjustableParams.addParameter(this.srcLonParam);
        this.adjustableParams.addParameter(this.srcDepthParam);
        this.adjustableParams.addParameter(this.rakeParam);
        this.adjustableParams.addParameter(this.dipParam);
        this.magParam.addParameterChangeListener(this);
        this.probParam.addParameterChangeListener(this);
        this.rakeParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
        this.srcLatParam.addParameterChangeListener(this);
        this.srcLonParam.addParameterChangeListener(this);
        this.srcDepthParam.addParameterChangeListener(this);
    }

    public void updateForecast() {
        String S = C + "updateForecast::";
        if (this.parameterChangeFlag) {
            Location loc = new Location((Double)this.srcLatParam.getValue(), (Double)this.srcLonParam.getValue(), (Double)this.srcDepthParam.getValue());
            this.source = new PointEqkSource(loc, (Double)this.magParam.getValue(), (double)((Double)this.probParam.getValue()), (double)((Double)this.rakeParam.getValue()), (double)((Double)this.dipParam.getValue()));
            this.parameterChangeFlag = false;
        }
        if (this.D) {
            System.out.println(C + " numSources=" + this.getNumSources());
            System.out.println(C + " numRuptures(0th src)=" + this.getSource(0).getNumRuptures());
            System.out.println(C + " isPoissonian(0th src)=" + this.getSource(0).isSourcePoissonian());
            for (int n = 0; n < this.getSource(0).getNumRuptures(); ++n) {
                System.out.println(C + " " + n + "th rup prob=" + this.getSource(0).getRupture(n).getProbability());
                System.out.println(C + " " + n + "th rup mag=" + this.getSource(0).getRupture(n).getMag());
            }
        }
    }

    public ProbEqkSource getSource(int iSource) {
        if (iSource != 0) {
            throw new RuntimeException("Only 1 source available, iSource should be equal to 0");
        }
        return this.source;
    }

    public int getNumSources() {
        return 1;
    }

    public ArrayList getSourceList() {
        ArrayList<PointEqkSource> v = new ArrayList<PointEqkSource>();
        v.add(this.source);
        return v;
    }

    public String getName() {
        return NAME;
    }
}

