/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.remote;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.data.TimeSpan;
import org.opensha.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.data.region.EvenlyGriddedGeographicRegionAPI;
import org.opensha.data.region.GeographicRegion;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.remote.RemoteERF_FactoryAPI;
import org.opensha.sha.earthquake.rupForecastImpl.remote.RemoteEqkRupForecastAPI;

public class RemoteERF_Client
extends EqkRupForecast
implements ParameterChangeListener {
    private RemoteEqkRupForecastAPI erfServer = null;

    protected void getRemoteERF(String className, String rmiRemoteRegistrationName) throws RemoteException {
        try {
            RemoteERF_FactoryAPI remoteERF_Factory = (RemoteERF_FactoryAPI)Naming.lookup(rmiRemoteRegistrationName);
            this.erfServer = remoteERF_Factory.getRemoteERF(className);
            this.adjustableParams = this.erfServer.getAdjustableParameterList();
            this.addListenersToParameters();
            this.timeSpan = this.erfServer.getTimeSpan();
            this.addListenersToTimeSpan();
        }
        catch (NotBoundException n) {
            n.printStackTrace();
        }
        catch (MalformedURLException m) {
            m.printStackTrace();
        }
        catch (UnmarshalException u) {
            u.printStackTrace();
        }
    }

    private void addListenersToParameters() {
        ListIterator it = this.adjustableParams.getParametersIterator();
        while (it.hasNext()) {
            ((ParameterAPI)it.next()).addParameterChangeListener(this);
        }
    }

    private void addListenersToTimeSpan() {
        if (this.timeSpan != null) {
            this.timeSpan.addParameterChangeListener(this);
            ParameterList timeSpanParamList = this.timeSpan.getAdjustableParams();
            ListIterator it = timeSpanParamList.getParametersIterator();
            while (it.hasNext()) {
                ((ParameterAPI)it.next()).addParameterChangeListener(this);
            }
        }
    }

    protected void getRemoteERF(ArrayList paramArrays, ArrayList paramTypes, String className, String rmiRemoteRegistrationName) throws RemoteException {
        try {
            RemoteERF_FactoryAPI remoteERF_Factory = (RemoteERF_FactoryAPI)Naming.lookup(rmiRemoteRegistrationName);
            this.erfServer = remoteERF_Factory.getRemoteERF(paramArrays, paramTypes, className);
            this.adjustableParams = this.erfServer.getAdjustableParameterList();
            ListIterator it = this.adjustableParams.getParametersIterator();
            while (it.hasNext()) {
                ((ParameterAPI)it.next()).addParameterChangeListener(this);
            }
        }
        catch (NotBoundException n) {
            n.printStackTrace();
        }
        catch (MalformedURLException m) {
            m.printStackTrace();
        }
        catch (UnmarshalException u) {
            u.printStackTrace();
        }
    }

    public ParameterAPI getParameter(String paramName) {
        try {
            return this.erfServer.getParameter(paramName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getNumSources() {
        try {
            int numSources = this.erfServer.getNumSources();
            return numSources;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public ProbEqkSource getSource(int iSource) {
        try {
            ProbEqkSource source = this.erfServer.getSource(iSource);
            return source;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList getSourceList() {
        try {
            ArrayList list = this.erfServer.getSourceList();
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void parameterChange(ParameterChangeEvent event) {
        try {
            String eventParamName = event.getParameterName();
            this.erfServer.setParameter(event.getParameterName(), event.getNewValue());
            this.adjustableParams = this.erfServer.getAdjustableParameterList();
            this.addListenersToParameters();
            this.timeSpan = this.erfServer.getTimeSpan();
            this.addListenersToTimeSpan();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isLocWithinApplicableRegion(Location loc) {
        try {
            return this.erfServer.isLocWithinApplicableRegion(loc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public GeographicRegion getApplicableRegion() {
        try {
            return this.erfServer.getApplicableRegion();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getNumRuptures(int iSource) {
        try {
            int numRupsForSource = this.erfServer.getNumRuptures(iSource);
            return numRupsForSource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public ProbEqkRupture getRupture(int iSource, int nRupture) {
        try {
            ProbEqkRupture rupture = this.erfServer.getRupture(iSource, nRupture);
            return rupture;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ProbEqkRupture getRuptureClone(int iSource, int nRupture) {
        try {
            return this.erfServer.getRuptureClone(iSource, nRupture);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ProbEqkSource getSourceClone(int iSource) {
        try {
            return this.erfServer.getSourceClone(iSource);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateForecast() {
        try {
            this.erfServer.updateForecast();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String updateAndSaveForecast() {
        try {
            this.updateForecast();
            return this.erfServer.saveForecast();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getName() {
        try {
            return this.erfServer.getName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TimeSpan getTimeSpan() {
        try {
            return this.timeSpan;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ParameterList getAdjustableParameterList() {
        try {
            return this.adjustableParams;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setTimeSpan(TimeSpan time) {
        try {
            this.erfServer.setTimeSpan(time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public RemoteEqkRupForecastAPI getERF_Server() {
        return this.erfServer;
    }

    public void setERF_Server(RemoteEqkRupForecastAPI remoteEqkRupForecastAPI) {
        this.erfServer = remoteEqkRupForecastAPI;
    }

    public double getTotalProbAbove(double minMag, GeographicRegion region) {
        try {
            return this.erfServer.getTotalProbAbove(minMag, region);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public double getTotalRateAbove(double minMag, GeographicRegion region) {
        try {
            return this.erfServer.getTotalRateAbove(minMag, region);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public ArrayList getMagRateDistForEachLocationInRegion(double minMag, EvenlyGriddedGeographicRegionAPI region) {
        try {
            return this.erfServer.getMagRateDistForEachLocationInRegion(minMag, region);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public double[] getTotalSeisRateAtEachLocationInRegion(double minMag, EvenlyGriddedGeographicRegionAPI region) {
        try {
            return this.erfServer.getTotalSeisRateAtEachLocationInRegion(minMag, region);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ArbDiscrEmpiricalDistFunc getMagRateDistForRegion(double minMag, GeographicRegion region) {
        try {
            return this.erfServer.getMagRateDistForRegion(minMag, region);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

