/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.fault;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.exceptions.FaultException;
import org.opensha.sha.fault.FaultTrace;
import org.opensha.sha.fault.SimpleFaultData;
import org.opensha.sha.surface.EvenlyGriddedSurface;
import org.opensha.util.FaultUtils;

public abstract class EvenlyGriddedSurfFromSimpleFaultData
extends EvenlyGriddedSurface {
    protected static final String C = "EvenlyGriddedSurfFromSimpleFaultData";
    protected static final boolean D = false;
    protected FaultTrace faultTrace;
    protected double upperSeismogenicDepth = Double.NaN;
    protected double lowerSeismogenicDepth = Double.NaN;

    protected EvenlyGriddedSurfFromSimpleFaultData(SimpleFaultData simpleFaultData, double gridSpacing) throws FaultException {
        this(simpleFaultData.getFaultTrace(), simpleFaultData.getAveDip(), simpleFaultData.getUpperSeismogenicDepth(), simpleFaultData.getLowerSeismogenicDepth(), gridSpacing);
    }

    protected EvenlyGriddedSurfFromSimpleFaultData(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing) throws FaultException {
        this.faultTrace = faultTrace;
        this.aveDip = aveDip;
        this.upperSeismogenicDepth = upperSeismogenicDepth;
        this.lowerSeismogenicDepth = lowerSeismogenicDepth;
        this.gridSpacing = gridSpacing;
    }

    protected void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    protected void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public FaultTrace getFaultTrace() {
        return this.faultTrace;
    }

    public double getUpperSeismogenicDepth() {
        return this.upperSeismogenicDepth;
    }

    public double getLowerSeismogenicDepth() {
        return this.lowerSeismogenicDepth;
    }

    protected void assertValidData() throws FaultException {
        if (this.faultTrace == null) {
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultDataFault Trace is null");
        }
        FaultUtils.assertValidDip(this.aveDip);
        FaultUtils.assertValidSeisUpperAndLower(this.upperSeismogenicDepth, this.lowerSeismogenicDepth);
        if (this.gridSpacing == Double.NaN) {
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultDatainvalid gridSpacing");
        }
        double depth = this.faultTrace.getLocationAt(0).getDepth();
        if (depth > this.upperSeismogenicDepth) {
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultDatadepth on faultTrace locations must be < upperSeisDepth");
        }
        ListIterator it = this.faultTrace.listIterator();
        while (it.hasNext()) {
            if (((Location)it.next()).getDepth() == depth) continue;
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultDataAll depth on faultTrace locations must be equal");
        }
    }
}

