/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.data.Range;
import org.opensha.sha.gui.controls.AxisLimitsControlPanel;
import org.opensha.sha.gui.controls.AxisLimitsControlPanelAPI;
import org.opensha.sha.gui.controls.PlotColorAndLineTypeSelectorControlPanel;
import org.opensha.sha.gui.controls.PlotColorAndLineTypeSelectorControlPanelAPI;
import org.opensha.sha.gui.infoTools.ButtonControlPanelAPI;

public class ButtonControlPanel
extends JPanel
implements AxisLimitsControlPanelAPI,
PlotColorAndLineTypeSelectorControlPanelAPI {
    private JCheckBox jCheckxlog = new JCheckBox();
    private static final String AXIS_RANGE_NOT_ALLOWED = new String("First Choose Add Graph. Then choose Axis Scale option");
    ButtonControlPanelAPI application;
    private JCheckBox jCheckylog = new JCheckBox();
    private JButton setAxisButton = new JButton();
    private JButton toggleButton = new JButton();
    private AxisLimitsControlPanel axisControlPanel;
    private PlotColorAndLineTypeSelectorControlPanel plotControl;
    private boolean customAxis = false;
    private JButton plotPrefsButton = new JButton();
    private FlowLayout flowLayout1 = new FlowLayout();

    public ButtonControlPanel(ButtonControlPanelAPI api) {
        this.application = api;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.jCheckxlog.setText("X Log");
        this.jCheckxlog.setFont(new Font("Dialog", 1, 11));
        this.setLayout(this.flowLayout1);
        this.setDoubleBuffered(false);
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(500, 36));
        this.jCheckxlog.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ButtonControlPanel.this.jCheckxlog_itemStateChanged(e);
            }
        });
        this.jCheckylog.setText("Y Log");
        this.jCheckylog.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ButtonControlPanel.this.jCheckylog_itemStateChanged(e);
            }
        });
        this.jCheckylog.setFont(new Font("Dialog", 1, 11));
        this.setAxisButton.setText("Set Axis");
        this.setAxisButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonControlPanel.this.setAxisButton_actionPerformed(e);
            }
        });
        this.toggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonControlPanel.this.toggleButton_actionPerformed(e);
            }
        });
        this.toggleButton.setText("Show Data");
        this.plotPrefsButton.setText("Plot Prefs");
        this.plotPrefsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonControlPanel.this.plotPrefsButton_actionPerformed(e);
            }
        });
        this.add((Component)this.plotPrefsButton, 0);
        this.add((Component)this.toggleButton, 1);
        this.add((Component)this.setAxisButton, 2);
        this.add((Component)this.jCheckylog, 3);
        this.add((Component)this.jCheckxlog, 4);
    }

    public void setToggleButtonText(String text) {
        this.toggleButton.setText(text);
    }

    void jCheckylog_itemStateChanged(ItemEvent e) {
        this.application.setY_Log(this.jCheckylog.isSelected());
    }

    void jCheckxlog_itemStateChanged(ItemEvent e) {
        this.application.setX_Log(this.jCheckxlog.isSelected());
    }

    void toggleButton_actionPerformed(ActionEvent e) {
        this.application.togglePlot();
    }

    void setAxisButton_actionPerformed(ActionEvent e) {
        Range xAxisRange = this.application.getX_AxisRange();
        Range yAxisRange = this.application.getY_AxisRange();
        if (xAxisRange == null || yAxisRange == null) {
            JOptionPane.showMessageDialog(this, AXIS_RANGE_NOT_ALLOWED);
            return;
        }
        double minX = xAxisRange.getLowerBound();
        double maxX = xAxisRange.getUpperBound();
        double minY = yAxisRange.getLowerBound();
        double maxY = yAxisRange.getUpperBound();
        if (this.customAxis) {
            if (this.axisControlPanel == null) {
                this.axisControlPanel = new AxisLimitsControlPanel(this, this, "Custom Scale", minX, maxX, minY, maxY);
            } else {
                this.axisControlPanel.setParams("Custom Scale", minX, maxX, minY, maxY);
            }
        } else if (this.axisControlPanel == null) {
            this.axisControlPanel = new AxisLimitsControlPanel(this, this, "Auto Scale", minX, maxX, minY, maxY);
        } else {
            this.axisControlPanel.setParams("Auto Scale", minX, maxX, minY, maxY);
        }
        this.axisControlPanel.pack();
        this.axisControlPanel.setVisible(true);
    }

    public void plotGraphUsingPlotPreferences() {
        this.application.plotGraphUsingPlotPreferences();
    }

    public void setAxisRange(double xMin, double xMax, double yMin, double yMax) {
        this.application.setAxisRange(xMin, xMax, yMin, yMax);
        this.customAxis = true;
    }

    public void setAutoRange() {
        this.application.setAutoRange();
        this.customAxis = false;
    }

    public void setXLog(boolean flag) {
        this.jCheckxlog.setSelected(flag);
    }

    public void setYLog(boolean flag) {
        this.jCheckylog.setSelected(flag);
    }

    public void setEnabled(boolean flag) {
        this.jCheckxlog.setEnabled(flag);
        this.jCheckylog.setEnabled(flag);
        this.setAxisButton.setEnabled(flag);
        this.toggleButton.setEnabled(flag);
        this.plotPrefsButton.setEnabled(flag);
    }

    void plotPrefsButton_actionPerformed(ActionEvent e) {
        ArrayList plotFeatures = this.application.getPlottingFeatures();
        if (this.plotControl == null) {
            this.plotControl = new PlotColorAndLineTypeSelectorControlPanel(this, plotFeatures);
        } else {
            this.plotControl.setPlotColorAndLineType(plotFeatures);
        }
        this.plotControl.setVisible(true);
    }

    public int getAxisLabelFontSize() {
        if (this.plotControl != null) {
            return this.plotControl.getAxisLabelFontSize();
        }
        return 12;
    }

    public int getTickLabelFontSize() {
        if (this.plotControl != null) {
            return this.plotControl.getTickLabelFontSize();
        }
        return 10;
    }

    public void setPlotPreferencesButtonVisible(boolean flag) {
        this.plotPrefsButton.setVisible(false);
    }

    public String getXAxisLabel() {
        return this.application.getXAxisLabel();
    }

    public String getYAxisLabel() {
        return this.application.getYAxisLabel();
    }

    public String getPlotLabel() {
        return this.application.getPlotLabel();
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.application.setXAxisLabel(xAxisLabel);
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.application.setYAxisLabel(yAxisLabel);
    }

    public void setPlotLabel(String plotTitle) {
        this.application.setPlotLabel(plotTitle);
    }
}

