/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.awt.Color;
import java.util.ArrayList;
import org.opensha.data.estimate.DiscreteValueEstimate;
import org.opensha.data.estimate.Estimate;
import org.opensha.data.function.DiscretizedFunc;
import org.opensha.sha.gui.infoTools.GraphWindow;
import org.opensha.sha.gui.infoTools.GraphWindowAPI;
import org.opensha.sha.gui.infoTools.PlotCurveCharacterstics;

public class EstimateViewer
implements GraphWindowAPI {
    private static final String X_AXIS_LABEL = "X Values";
    private static final String Y_AXIS_LABEL = "Probability";
    private Estimate estimate;
    private String xAxisLabel;
    private String yAxisLabel;
    private GraphWindow graphWindow;
    private final PlotCurveCharacterstics PDF_PLOT_CHAR_HISTOGRAM = new PlotCurveCharacterstics("Histograms", Color.RED, 2.0);
    private final PlotCurveCharacterstics CDF_PLOT_CHAR = new PlotCurveCharacterstics("Solid Line", Color.BLUE, 2.0);
    private final PlotCurveCharacterstics CDF_USING_FRACTILE_PLOT_CHAR = new PlotCurveCharacterstics("Solid Line", Color.BLACK, 2.0);
    private final PlotCurveCharacterstics DISCRETE_VAL_CDF_USING_FRACTILE_PLOT_CHAR = new PlotCurveCharacterstics("+ Symbols", Color.BLACK, 6.0);

    public EstimateViewer(Estimate estimate) {
        this.setEstimate(estimate);
        this.setXAxisLabel(X_AXIS_LABEL);
        this.setYAxisLabel(Y_AXIS_LABEL);
        this.graphWindow = new GraphWindow(this);
        this.graphWindow.setPlotLabel(estimate.getName());
        this.graphWindow.plotGraphUsingPlotPreferences();
        this.graphWindow.setVisible(true);
    }

    public void setXAxisLabel(String label) {
        this.xAxisLabel = label;
    }

    public void setYAxisLabel(String label) {
        this.yAxisLabel = label;
    }

    public void setEstimate(Estimate estimate) {
        this.estimate = estimate;
    }

    public boolean getXLog() {
        return false;
    }

    public boolean getYLog() {
        return false;
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public boolean isCustomAxis() {
        return false;
    }

    public ArrayList getCurveFunctionList() {
        ArrayList<DiscretizedFunc> list = new ArrayList<DiscretizedFunc>();
        DiscretizedFunc func = this.estimate.getPDF_Test();
        list.add(func);
        list.add(this.estimate.getCDF_Test());
        list.add(this.estimate.getCDF_TestUsingFractile());
        return list;
    }

    public ArrayList getPlottingFeatures() {
        ArrayList<PlotCurveCharacterstics> list = new ArrayList<PlotCurveCharacterstics>();
        list.add(this.PDF_PLOT_CHAR_HISTOGRAM);
        list.add(this.CDF_PLOT_CHAR);
        if (this.estimate instanceof DiscreteValueEstimate) {
            list.add(this.DISCRETE_VAL_CDF_USING_FRACTILE_PLOT_CHAR);
        } else {
            list.add(this.CDF_USING_FRACTILE_PLOT_CHAR);
        }
        return list;
    }

    public double getMinX() {
        throw new UnsupportedOperationException("Method getMinX() not yet implemented.");
    }

    public double getMaxX() {
        throw new UnsupportedOperationException("Method getMaxX() not yet implemented.");
    }

    public double getMinY() {
        throw new UnsupportedOperationException("Method getMinY() not yet implemented.");
    }

    public double getMaxY() {
        throw new UnsupportedOperationException("Method getMaxY() not yet implemented.");
    }
}

