/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.PrintJob;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.XYDataset;
import org.jfree.util.ShapeUtils;
import org.opensha.data.function.DiscretizedFuncAPI;
import org.opensha.data.function.DiscretizedFuncList;
import org.opensha.gui.plot.jfreechart.DiscretizedFunctionXYDataSet;
import org.opensha.gui.plot.jfreechart.MyTickUnits;
import org.opensha.sha.gui.infoTools.ButtonControlPanel;
import org.opensha.sha.gui.infoTools.GraphPanelAPI;
import org.opensha.sha.gui.infoTools.PlotCurveCharacterstics;
import org.opensha.sha.gui.infoTools.WeightedFuncListforPlotting;
import org.opensha.util.DataUtil;
import org.opensha.util.SystemPropertiesUtils;

public class GraphPanel
extends JPanel {
    private static final String NO_PLOT_MSG = "No Plot Data Available";
    Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.green, Color.darkGray, Color.magenta, Color.cyan, Color.orange, Color.pink, Color.yellow, Color.gray};
    private SimpleAttributeSet setLegend;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JSplitPane chartSplitPane = new JSplitPane();
    private JScrollPane metadataScrollPane = new JScrollPane();
    private JPanel chartPane = new JPanel();
    private static final double SIZE = 3.0;
    private static final double DELTA = 1.5;
    private Insets plotInsets = new Insets(4, 4, 4, 4);
    private DiscretizedFunctionXYDataSet data = new DiscretizedFunctionXYDataSet();
    private DiscretizedFuncList totalProbFuncs = new DiscretizedFuncList();
    private int weightedfuncListIndex;
    private double Y_MIN_VAL = 1.0E-16;
    private ChartPanel chartPanel;
    private XYPlot plot;
    NumberAxis xAxis;
    NumberAxis xAxis1;
    NumberAxis yAxis;
    NumberAxis yAxis1;
    private Color lightBlue = new Color(200, 200, 230);
    private boolean graphOn = false;
    GraphPanelAPI application;
    JTextPane metadataText = new JTextPane();
    private ArrayList curvePlottingCharacterstics = new ArrayList();
    private JScrollPane dataScrollPane = new JScrollPane();
    private JTextArea pointsTextArea = new JTextArea();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private ArrayList legendString;

    public GraphPanel(GraphPanelAPI api) {
        this.data.setFunctions(this.totalProbFuncs);
        this.data.setConvertZeroToMin(true, this.Y_MIN_VAL);
        this.application = api;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.chartSplitPane.setOrientation(0);
        this.metadataText.setEditable(false);
        this.chartPane.setLayout(this.gridBagLayout1);
        this.add((Component)this.chartSplitPane, "Center");
        this.chartSplitPane.add((Component)this.metadataScrollPane, "bottom");
        this.metadataScrollPane.getViewport().add((Component)this.metadataText, null);
        this.chartSplitPane.add((Component)this.chartPane, "top");
        this.chartSplitPane.setDividerLocation(450);
        this.pointsTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.pointsTextArea.setText(NO_PLOT_MSG);
        this.pointsTextArea.setLineWrap(true);
        this.dataScrollPane.setHorizontalScrollBarPolicy(30);
        this.dataScrollPane.setVerticalScrollBarPolicy(20);
        this.dataScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.dataScrollPane.getViewport().add((Component)this.pointsTextArea, null);
    }

    private void drawCurvesUsingPlottingFeatures(String lineType, Color color, double curveWidth, int functionIndex) {
        if (lineType.equals("Solid Line")) {
            StandardXYItemRenderer SOLID_LINE_RENDERER = new StandardXYItemRenderer(2, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            SOLID_LINE_RENDERER.setStroke((Stroke)new BasicStroke((float)curveWidth));
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)SOLID_LINE_RENDERER);
        } else if (lineType.equals("Dash Line")) {
            StandardXYItemRenderer DASHED_LINE_RENDERER = new StandardXYItemRenderer(2, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)DASHED_LINE_RENDERER);
            DASHED_LINE_RENDERER.setStroke((Stroke)new BasicStroke((float)curveWidth, 0, 2, 0.0f, new float[]{9.0f}, 0.0f));
        } else if (lineType.equals("Dotted Line")) {
            StandardXYItemRenderer DOTTED_LINE_RENDERER = new StandardXYItemRenderer(2, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)DOTTED_LINE_RENDERER);
            DOTTED_LINE_RENDERER.setStroke((Stroke)new BasicStroke((float)curveWidth, 0, 2, 0.0f, new float[]{1.0f}, 0.0f));
        } else if (lineType.equals("Dot and Dash Line")) {
            StandardXYItemRenderer DASH_DOTTED_LINE_RENDERER = new StandardXYItemRenderer(2, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)DASH_DOTTED_LINE_RENDERER);
            DASH_DOTTED_LINE_RENDERER.setStroke((Stroke)new BasicStroke((float)curveWidth, 0, 2, 0.0f, new float[]{5.0f, 3.0f, 2.0f, 3.0f}, 0.0f));
        } else if (lineType.equals("Filled Circles")) {
            StandardXYItemRenderer FILLED_CIRCLES_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            FILLED_CIRCLES_SHAPE_RENDERER.setShape((Shape)new Ellipse2D.Double(-1.5 - curveWidth / 2.0, -1.5 - curveWidth / 2.0, 3.0 + curveWidth, 3.0 + curveWidth));
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)FILLED_CIRCLES_SHAPE_RENDERER);
        } else if (lineType.equals("Circles")) {
            StandardXYItemRenderer CIRCLES_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            CIRCLES_SHAPE_RENDERER.setShape((Shape)new Ellipse2D.Double(-1.5 - curveWidth / 2.0, -1.5 - curveWidth / 2.0, 3.0 + curveWidth, 3.0 + curveWidth));
            CIRCLES_SHAPE_RENDERER.setShapesFilled(false);
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)CIRCLES_SHAPE_RENDERER);
        } else if (lineType.equals("Filled Triangles")) {
            StandardXYItemRenderer FILLED_TRIANGLES_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            FILLED_TRIANGLES_SHAPE_RENDERER.setShape(ShapeUtils.createUpTriangle((float)((float)curveWidth)));
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)FILLED_TRIANGLES_SHAPE_RENDERER);
        } else if (lineType.equals("Triangles")) {
            StandardXYItemRenderer TRIANGLES_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            TRIANGLES_SHAPE_RENDERER.setShape(ShapeUtils.createUpTriangle((float)((float)curveWidth)));
            TRIANGLES_SHAPE_RENDERER.setShapesFilled(false);
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)TRIANGLES_SHAPE_RENDERER);
        } else if (lineType.equals("Filled Inv. Triangles")) {
            StandardXYItemRenderer FILLED_INV_TRIANGLES_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            FILLED_INV_TRIANGLES_SHAPE_RENDERER.setShape(ShapeUtils.createDownTriangle((float)((float)curveWidth)));
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)FILLED_INV_TRIANGLES_SHAPE_RENDERER);
        } else if (lineType.equals("Inv. Triangles")) {
            StandardXYItemRenderer INV_TRIANGLES_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            INV_TRIANGLES_SHAPE_RENDERER.setShape(ShapeUtils.createDownTriangle((float)((float)curveWidth)));
            INV_TRIANGLES_SHAPE_RENDERER.setShapesFilled(false);
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)INV_TRIANGLES_SHAPE_RENDERER);
        } else if (lineType.equals("Filled Diamond")) {
            StandardXYItemRenderer FILLED_DIAMONDS_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            FILLED_DIAMONDS_SHAPE_RENDERER.setShape(ShapeUtils.createDiamond((float)((float)curveWidth)));
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)FILLED_DIAMONDS_SHAPE_RENDERER);
        } else if (lineType.equals("Diamond")) {
            StandardXYItemRenderer DIAMONDS_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            DIAMONDS_SHAPE_RENDERER.setShape(ShapeUtils.createDiamond((float)((float)curveWidth)));
            DIAMONDS_SHAPE_RENDERER.setShapesFilled(false);
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)DIAMONDS_SHAPE_RENDERER);
        } else if (lineType.equals("Line and Circles")) {
            StandardXYItemRenderer LINE_AND_CIRCLES_RENDERER = new StandardXYItemRenderer(3, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            LINE_AND_CIRCLES_RENDERER.setShape((Shape)new Ellipse2D.Double(-1.5 - curveWidth * 4.0 / 2.0, -1.5 - curveWidth * 4.0 / 2.0, 3.0 + curveWidth * 4.0, 3.0 + curveWidth * 4.0));
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)LINE_AND_CIRCLES_RENDERER);
            LINE_AND_CIRCLES_RENDERER.setStroke((Stroke)new BasicStroke((float)curveWidth));
        } else if (lineType.equals("Line and Triangles")) {
            StandardXYItemRenderer LINE_AND_TRIANGLES_RENDERER = new StandardXYItemRenderer(3, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            LINE_AND_TRIANGLES_RENDERER.setShape(ShapeUtils.createUpTriangle((float)((float)(curveWidth * 4.0))));
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)LINE_AND_TRIANGLES_RENDERER);
            LINE_AND_TRIANGLES_RENDERER.setStroke((Stroke)new BasicStroke((float)curveWidth));
        } else if (lineType.equals("X Symbols")) {
            StandardXYItemRenderer X_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            X_SHAPE_RENDERER.setShape(ShapeUtils.createDiagonalCross((float)((float)curveWidth), (float)0.1f));
            X_SHAPE_RENDERER.setShapesFilled(false);
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)X_SHAPE_RENDERER);
        } else if (lineType.equals("+ Symbols")) {
            StandardXYItemRenderer X_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            X_SHAPE_RENDERER.setShape(ShapeUtils.createRegularCross((float)((float)curveWidth), (float)0.1f));
            X_SHAPE_RENDERER.setShapesFilled(false);
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)X_SHAPE_RENDERER);
        } else if (lineType.equals("Squares")) {
            StandardXYItemRenderer SQUARE_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            SQUARE_SHAPE_RENDERER.setShape((Shape)new Rectangle2D.Double(-1.5 - curveWidth / 2.0, -1.5 - curveWidth / 2.0, 3.0 + curveWidth, 3.0 + curveWidth));
            SQUARE_SHAPE_RENDERER.setShapesFilled(false);
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)SQUARE_SHAPE_RENDERER);
        } else if (lineType.equals("Filled Squares")) {
            StandardXYItemRenderer FILLED_SQUARE_SHAPE_RENDERER = new StandardXYItemRenderer(1, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            FILLED_SQUARE_SHAPE_RENDERER.setShape((Shape)new Rectangle2D.Double(-1.5 - curveWidth / 2.0, -1.5 - curveWidth / 2.0, 3.0 + curveWidth, 3.0 + curveWidth));
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)FILLED_SQUARE_SHAPE_RENDERER);
        } else if (lineType.equals("Histograms")) {
            XYBarRenderer HISTOGRAM_RENDERER = new XYBarRenderer();
            this.setRendererInPlot(color, functionIndex, (AbstractXYItemRenderer)HISTOGRAM_RENDERER);
        }
    }

    private void setRendererInPlot(Color color, int functionIndex, AbstractXYItemRenderer xyItemRenderer) {
        if (functionIndex == 0) {
            this.plot.setRenderer((XYItemRenderer)xyItemRenderer);
        } else {
            this.plot.setSecondaryRenderer(functionIndex - 1, (XYItemRenderer)xyItemRenderer);
        }
        xyItemRenderer.setPaint((Paint)color);
    }

    public void drawGraphPanel(String xAxisName, String yAxisName, ArrayList funcList, boolean xLog, boolean yLog, boolean customAxis, String title, ButtonControlPanel buttonControlPanel) {
        Font axisTickFont;
        Font axisLabelFont;
        String S = "drawGraphPanel(): ";
        this.createColorSchemeAndFunctionList(funcList);
        boolean logErrorFlag = false;
        int axisFontSize = buttonControlPanel.getAxisLabelFontSize();
        int tickFontSize = buttonControlPanel.getTickLabelFontSize();
        TickUnits units = MyTickUnits.createStandardTickUnits();
        try {
            this.xAxis = xLog ? new LogarithmicAxis(xAxisName) : new NumberAxis(xAxisName);
            if (!xLog) {
                this.xAxis.setAutoRangeIncludesZero(true);
            } else {
                this.xAxis.setAutoRangeIncludesZero(false);
            }
            this.xAxis.setStandardTickUnits((TickUnitSource)units);
            this.xAxis.setTickMarksVisible(false);
            axisLabelFont = this.xAxis.getLabelFont();
            this.xAxis.setLabelFont(new Font(axisLabelFont.getFontName(), axisLabelFont.getStyle(), axisFontSize));
            axisTickFont = this.xAxis.getTickLabelFont();
            this.xAxis.setTickLabelFont(new Font(axisTickFont.getFontName(), axisTickFont.getStyle(), tickFontSize));
            if (customAxis) {
                this.xAxis.setRange(this.application.getMinX(), this.application.getMaxX());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "X-Plot Error", 0);
            this.graphOn = false;
            xLog = false;
            buttonControlPanel.setXLog(xLog);
            this.xAxis = this.xAxis1;
            logErrorFlag = true;
        }
        try {
            this.yAxis = yLog ? new LogarithmicAxis(yAxisName) : new NumberAxis(yAxisName);
            if (!yLog) {
                this.yAxis.setAutoRangeIncludesZero(true);
            } else {
                this.yAxis.setAutoRangeIncludesZero(false);
            }
            this.yAxis.setStandardTickUnits((TickUnitSource)units);
            this.yAxis.setTickMarksVisible(false);
            axisLabelFont = this.yAxis.getLabelFont();
            this.yAxis.setLabelFont(new Font(axisLabelFont.getFontName(), axisLabelFont.getStyle(), axisFontSize));
            axisTickFont = this.yAxis.getTickLabelFont();
            this.yAxis.setTickLabelFont(new Font(axisTickFont.getFontName(), axisTickFont.getStyle(), tickFontSize));
            if (customAxis) {
                this.yAxis.setRange(this.application.getMinY(), this.application.getMaxY());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Y-Plot Error", 0);
            this.graphOn = false;
            yLog = false;
            buttonControlPanel.setYLog(yLog);
            this.yAxis = this.yAxis1;
            logErrorFlag = false;
        }
        this.plot = null;
        this.plot = new XYPlot(null, (ValueAxis)this.xAxis, (ValueAxis)this.yAxis, null);
        this.plot.setDomainCrosshairLockedOnData(false);
        this.plot.setDomainCrosshairVisible(false);
        this.plot.setRangeCrosshairLockedOnData(false);
        this.plot.setRangeCrosshairVisible(false);
        this.plot.setInsets(new Insets(10, 0, 0, tickFontSize + 15));
        int numFuncs = this.curvePlottingCharacterstics.size();
        int datasetIndex = 0;
        int j = 0;
        int secondaryDatasetIndex = 0;
        while (j < numFuncs) {
            PlotCurveCharacterstics curveCharaceterstic = (PlotCurveCharacterstics)this.curvePlottingCharacterstics.get(j);
            Color color = curveCharaceterstic.getCurveColor();
            double lineWidth = curveCharaceterstic.getCurveWidth();
            String lineType = curveCharaceterstic.getCurveType();
            int numCurves = curveCharaceterstic.getNumContinuousCurvesWithSameCharacterstics();
            if (lineWidth == 0.0) {
                datasetIndex += numCurves;
                --secondaryDatasetIndex;
            } else {
                DiscretizedFuncList dataFunctions = new DiscretizedFuncList();
                DiscretizedFunctionXYDataSet dataset = new DiscretizedFunctionXYDataSet();
                dataset.setXLog(xLog);
                dataset.setYLog(yLog);
                dataset.setConvertZeroToMin(true, this.Y_MIN_VAL);
                dataset.setFunctions(dataFunctions);
                for (int i = datasetIndex; i < datasetIndex + numCurves; ++i) {
                    dataFunctions.add(this.totalProbFuncs.get(i));
                }
                datasetIndex += numCurves;
                if (secondaryDatasetIndex != 0) {
                    this.plot.setSecondaryDataset(secondaryDatasetIndex - 1, (XYDataset)dataset);
                } else {
                    this.plot.setDataset((XYDataset)dataset);
                }
                this.drawCurvesUsingPlottingFeatures(lineType, color, lineWidth, secondaryDatasetIndex);
            }
            ++j;
            ++secondaryDatasetIndex;
        }
        this.plot.setBackgroundAlpha(0.8f);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, (Plot)this.plot, false);
        chart.setBackgroundPaint((Paint)this.lightBlue);
        this.chartPanel = new ChartPanel(chart, true, true, true, true, false);
        this.chartPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.chartPanel.setMouseZoomable(true);
        this.chartPanel.setDisplayToolTips(true);
        this.chartPanel.setHorizontalAxisTrace(false);
        this.chartPanel.setVerticalAxisTrace(false);
        int numOfColors = this.plot.getSeriesCount();
        this.metadataText.removeAll();
        this.metadataText.setEditable(false);
        this.setLegend = new SimpleAttributeSet();
        this.setLegend.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
        StyledDocument doc = this.metadataText.getStyledDocument();
        this.weightedfuncListIndex = -1;
        try {
            doc.remove(0, doc.getLength());
            int totalNumofFunctions = funcList.size();
            this.legendString = new ArrayList();
            int plotPrefIndex = 0;
            for (int i = 0; i < totalNumofFunctions; ++i) {
                Color color;
                String legend = null;
                this.setLegend = new SimpleAttributeSet();
                StyleConstants.setFontSize(this.setLegend, 12);
                Object obj = funcList.get(i);
                String datasetName = "DATASET #" + (i + 1);
                if (obj instanceof WeightedFuncListforPlotting) {
                    WeightedFuncListforPlotting weightedList = (WeightedFuncListforPlotting)obj;
                    String listInfo = weightedList.getInfo();
                    legend = new String(datasetName + "\n" + listInfo + SystemPropertiesUtils.getSystemLineSeparator());
                    this.legendString.add(legend);
                    StyleConstants.setForeground(this.setLegend, Color.black);
                    doc.insertString(doc.getLength(), legend, this.setLegend);
                    this.weightedfuncListIndex = this.legendString.size() - 1;
                    if (weightedList.areIndividualCurvesToPlot()) {
                        ((PlotCurveCharacterstics)this.curvePlottingCharacterstics.get(plotPrefIndex)).setCurveName(datasetName + " Curves");
                        String listFunctionsInfo = weightedList.getFunctionTraceInfo();
                        legend = new String(listFunctionsInfo + SystemPropertiesUtils.getSystemLineSeparator());
                        this.legendString.add(legend);
                        color = ((PlotCurveCharacterstics)this.curvePlottingCharacterstics.get(plotPrefIndex)).getCurveColor();
                        StyleConstants.setForeground(this.setLegend, color);
                        doc.insertString(doc.getLength(), legend, this.setLegend);
                        ++plotPrefIndex;
                    }
                    if (weightedList.areFractilesToPlot()) {
                        ((PlotCurveCharacterstics)this.curvePlottingCharacterstics.get(plotPrefIndex)).setCurveName(datasetName + " Fractiles");
                        String fractileListInfo = weightedList.getFractileInfo();
                        legend = new String(fractileListInfo + SystemPropertiesUtils.getSystemLineSeparator());
                        this.legendString.add(legend);
                        color = ((PlotCurveCharacterstics)this.curvePlottingCharacterstics.get(plotPrefIndex)).getCurveColor();
                        StyleConstants.setForeground(this.setLegend, color);
                        doc.insertString(doc.getLength(), legend, this.setLegend);
                        ++plotPrefIndex;
                    }
                    if (!weightedList.isMeanToPlot()) continue;
                    ((PlotCurveCharacterstics)this.curvePlottingCharacterstics.get(plotPrefIndex)).setCurveName(datasetName + " Mean");
                    String meanInfo = weightedList.getMeanFunctionInfo();
                    legend = new String(meanInfo + SystemPropertiesUtils.getSystemLineSeparator());
                    this.legendString.add(legend);
                    color = ((PlotCurveCharacterstics)this.curvePlottingCharacterstics.get(plotPrefIndex)).getCurveColor();
                    StyleConstants.setForeground(this.setLegend, color);
                    doc.insertString(doc.getLength(), legend, this.setLegend);
                    ++plotPrefIndex;
                    continue;
                }
                ((PlotCurveCharacterstics)this.curvePlottingCharacterstics.get(plotPrefIndex)).setCurveName(datasetName);
                DiscretizedFuncAPI func = (DiscretizedFuncAPI)funcList.get(i);
                String functionInfo = func.getInfo();
                String name = func.getName();
                legend = new String(datasetName + "\n" + name + "  " + SystemPropertiesUtils.getSystemLineSeparator() + functionInfo + SystemPropertiesUtils.getSystemLineSeparator());
                this.legendString.add(legend);
                color = ((PlotCurveCharacterstics)this.curvePlottingCharacterstics.get(plotPrefIndex)).getCurveColor();
                StyleConstants.setForeground(this.setLegend, color);
                doc.insertString(doc.getLength(), legend, this.setLegend);
                ++plotPrefIndex;
            }
        }
        catch (BadLocationException e) {
            return;
        }
        this.graphOn = false;
        if (!logErrorFlag && !xLog) {
            this.xAxis1 = this.xAxis;
        }
        if (!logErrorFlag && !yLog) {
            this.yAxis1 = this.yAxis;
        }
        this.pointsTextArea.setText(this.showDataInWindow(funcList, xAxisName, yAxisName));
    }

    private String showDataInWindow(ArrayList funcList, String xAxisName, String yAxisName) {
        int size = funcList.size();
        StringBuffer b = new StringBuffer();
        b.append("\n");
        b.append("X-Axis: " + xAxisName + '\n');
        b.append("Y-Axis: " + yAxisName + '\n');
        b.append("Number of Data Sets: " + size + "\n\n");
        for (int i = 0; i < size; ++i) {
            DiscretizedFuncAPI function;
            int j;
            int listSize;
            DiscretizedFuncList list;
            Object obj = funcList.get(i);
            if (!(obj instanceof WeightedFuncListforPlotting)) {
                DiscretizedFuncAPI function2 = (DiscretizedFuncAPI)obj;
                b.append("\nDATASET #" + (i + 1) + "\n\n");
                b.append(((Object)function2).toString() + '\n');
                continue;
            }
            WeightedFuncListforPlotting weightedList = (WeightedFuncListforPlotting)obj;
            b.append("\nDATASET #" + (i + 1) + "   Weighted Function List" + '\n');
            b.append(weightedList.getInfo() + "\n\n");
            if (weightedList.areIndividualCurvesToPlot()) {
                list = weightedList.getWeightedFunctionList();
                ArrayList wtList = weightedList.getRelativeWtList();
                listSize = list.size();
                for (j = 0; j < listSize; ++j) {
                    b.append("\nFunction #" + (j + 1) + " of " + listSize + ", from Dataset #" + (i + 1) + ", with relative wt = " + (Double)wtList.get(j) + "\n");
                    function = list.get(j);
                    b.append(function.getMetadataString() + '\n');
                }
            }
            if (weightedList.areFractilesToPlot()) {
                list = weightedList.getFractileList();
                ArrayList fractileValueList = weightedList.getFractileValuesList();
                listSize = list.size();
                for (j = 0; j < listSize; ++j) {
                    b.append("\n" + (Double)fractileValueList.get(j) + " Fractile for Dataset #" + (i + 1) + "\n");
                    function = list.get(j);
                    b.append(function.getMetadataString() + '\n');
                }
            }
            if (!weightedList.isMeanToPlot()) continue;
            b.append("\nMean for Dataset #" + (i + 1) + "\n");
            b.append(weightedList.getMean().getMetadataString() + "\n");
        }
        return b.toString();
    }

    public void setMetadata(String metadata) {
        this.pointsTextArea.setText(metadata);
    }

    public void removeChartAndMetadata() {
        this.chartPane.removeAll();
        this.chartPanel = null;
        this.metadataText.setText("");
        this.pointsTextArea.setText(NO_PLOT_MSG);
        this.curvePlottingCharacterstics.clear();
    }

    public void togglePlot(ButtonControlPanel buttonControlPanel) {
        this.chartPane.removeAll();
        if (this.graphOn) {
            buttonControlPanel.setToggleButtonText("Show Plot");
            this.graphOn = false;
            this.chartPane.add((Component)this.dataScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.plotInsets, 0, 0));
        } else {
            this.graphOn = true;
            buttonControlPanel.setToggleButtonText("Show Data");
            if (this.chartPanel != null) {
                this.chartPane.add((Component)this.chartPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.plotInsets, 0, 0));
            } else {
                this.chartPane.add((Component)this.dataScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.plotInsets, 0, 0));
            }
        }
    }

    public void setPlotBackgroundColor(Color color) {
        if (this.plot != null) {
            this.plot.setBackgroundPaint((Paint)color);
        }
    }

    public Range getX_AxisRange() {
        return this.xAxis.getRange();
    }

    public Range getY_AxisRange() {
        return this.yAxis.getRange();
    }

    public ArrayList getCurvePlottingCharacterstic() {
        return this.curvePlottingCharacterstics;
    }

    public void setCurvePlottingCharacterstic(ArrayList plotPrefsList) {
        this.curvePlottingCharacterstics = plotPrefsList;
    }

    private void createColorSchemeAndFunctionList(ArrayList functionList) {
        this.totalProbFuncs.clear();
        int numCurves = functionList.size();
        ArrayList<Integer> numColorArray = new ArrayList<Integer>();
        for (int i = 0; i < numCurves; ++i) {
            Object obj = functionList.get(i);
            if (obj instanceof WeightedFuncListforPlotting) {
                DiscretizedFuncList list;
                WeightedFuncListforPlotting weightedList = (WeightedFuncListforPlotting)obj;
                if (weightedList.areIndividualCurvesToPlot()) {
                    list = weightedList.getWeightedFunctionList();
                    numColorArray.add(new Integer(list.size()));
                    this.totalProbFuncs.addAll(list);
                }
                if (weightedList.areFractilesToPlot()) {
                    list = weightedList.getFractileList();
                    this.totalProbFuncs.addAll(list);
                    numColorArray.add(new Integer(list.size()));
                }
                if (!weightedList.isMeanToPlot()) continue;
                DiscretizedFuncAPI meanFunc = weightedList.getMean();
                this.totalProbFuncs.add(meanFunc);
                numColorArray.add(new Integer(1));
                continue;
            }
            this.totalProbFuncs.add((DiscretizedFuncAPI)obj);
            numColorArray.add(new Integer(1));
        }
        int existingCurvesWithPlotPrefs = this.curvePlottingCharacterstics.size();
        int numDiffColors = numColorArray.size();
        int i = 0;
        int defaultColorIndex = 0;
        while (i < numDiffColors) {
            if (defaultColorIndex == this.defaultColor.length) {
                defaultColorIndex = 0;
            }
            int val = (Integer)numColorArray.get(i);
            if (i >= existingCurvesWithPlotPrefs) {
                this.curvePlottingCharacterstics.add(new PlotCurveCharacterstics("Solid Line", this.defaultColor[defaultColorIndex], 1.0, val));
            }
            ++i;
            ++defaultColorIndex;
        }
    }

    public void save() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        int option = fileChooser.showSaveDialog(this);
        String fileName = null;
        if (option == 0) {
            fileName = fileChooser.getSelectedFile().getAbsolutePath();
            if (!fileName.endsWith(".pdf") && this.graphOn) {
                fileName = fileName + ".pdf";
            } else if (!this.graphOn) {
                fileName = fileName + ".txt";
            }
        } else {
            return;
        }
        if (this.graphOn) {
            this.saveAsPDF(fileName);
        } else {
            DataUtil.save(fileName, this.pointsTextArea.getText());
        }
    }

    public void saveAsPDF(String fileName) throws IOException {
        int width = this.chartPanel.getWidth();
        int height = this.chartPanel.getHeight();
        int textLength = this.metadataText.getStyledDocument().getLength();
        int totalLength = textLength + height;
        Document metadataDocument = new Document(new Rectangle((float)width, (float)height));
        metadataDocument.addAuthor("OpenSHA");
        metadataDocument.addCreationDate();
        HeaderFooter footer = new HeaderFooter(new Phrase("Powered by OpenSHA"), true);
        metadataDocument.setFooter(footer);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)metadataDocument, (OutputStream)new FileOutputStream(fileName));
            metadataDocument.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2d = tp.createGraphics((float)width, (float)height, (FontMapper)new DefaultFontMapper());
            Rectangle2D.Double r2d = new Rectangle2D.Double(0.0, 0.0, width, height);
            this.chartPanel.getChart().draw(g2d, (Rectangle2D)r2d);
            g2d.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            metadataDocument.newPage();
            int size = this.legendString.size();
            int i = 0;
            int legendColor = 0;
            while (i < size) {
                Paragraph para = new Paragraph();
                if (this.weightedfuncListIndex != -1 && this.weightedfuncListIndex == i) {
                    para.add((Object)new Phrase((String)this.legendString.get(i), FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)0, (Color)Color.black)));
                    --legendColor;
                } else {
                    para.add((Object)new Phrase((String)this.legendString.get(i), FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)0, (Color)((PlotCurveCharacterstics)this.curvePlottingCharacterstics.get(legendColor)).getCurveColor())));
                }
                metadataDocument.add((Element)para);
                ++i;
                ++legendColor;
            }
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
        metadataDocument.close();
    }

    public void print(JFrame frame) {
        if (this.graphOn) {
            this.chartPanel.createChartPrintJob();
        } else {
            Properties p = new Properties();
            PrintJob pjob = this.getToolkit().getPrintJob(frame, "Printing", p);
            if (pjob != null) {
                Graphics pg = pjob.getGraphics();
                if (pg != null) {
                    DataUtil.print(pjob, pg, this.pointsTextArea.getText());
                    pg.dispose();
                }
                pjob.end();
            }
        }
    }

    public String getXAxisLabel() {
        if (this.xAxis != null) {
            return this.xAxis.getLabel();
        }
        return null;
    }

    public String getYAxisLabel() {
        if (this.yAxis != null) {
            return this.yAxis.getLabel();
        }
        return null;
    }

    public String getPlotLabel() {
        if (this.chartPanel != null) {
            return this.chartPanel.getChart().getTitle().getText();
        }
        return null;
    }
}

