/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.jfree.data.Range;
import org.opensha.sha.gui.infoTools.ButtonControlPanel;
import org.opensha.sha.gui.infoTools.ButtonControlPanelAPI;
import org.opensha.sha.gui.infoTools.GraphPanel;
import org.opensha.sha.gui.infoTools.GraphPanelAPI;
import org.opensha.sha.gui.infoTools.GraphWindowAPI;
import org.opensha.sha.gui.infoTools.PlotCurveCharacterstics;
import org.opensha.util.ImageUtils;

public class GraphWindow
extends JFrame
implements ButtonControlPanelAPI,
GraphPanelAPI {
    protected static final int W = 670;
    protected static final int H = 700;
    protected JSplitPane chartSplitPane = new JSplitPane();
    protected JPanel chartPane = new JPanel();
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected JPanel buttonPanel = new JPanel();
    protected FlowLayout flowLayout1 = new FlowLayout();
    protected boolean xLog = false;
    protected boolean yLog = false;
    protected boolean customAxis = false;
    protected static int windowNumber = 1;
    protected static final String TITLE = "Plot Window - ";
    private String plotTitle = "Hazard Curves";
    protected double minXValue;
    protected double maxXValue;
    protected double minYValue;
    protected double maxYValue;
    protected ButtonControlPanel buttonControlPanel;
    protected GraphWindowAPI application;
    protected GraphPanel graphPanel;
    protected ArrayList functionList;
    protected String xAxisName;
    protected String yAxisName;
    protected double Y_MIN_VAL = 1.0E-16;
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenu fileMenu = new JMenu();
    protected JMenuItem fileExitMenu = new JMenuItem();
    protected JMenuItem fileSaveMenu = new JMenuItem();
    protected JMenuItem filePrintMenu = new JCheckBoxMenuItem();
    protected JToolBar jToolBar = new JToolBar();
    protected JButton closeButton = new JButton();
    protected ImageIcon closeFileImage = new ImageIcon(ImageUtils.loadImage("closeFile.png"));
    protected JButton printButton = new JButton();
    protected ImageIcon printFileImage = new ImageIcon(ImageUtils.loadImage("printFile.jpg"));
    protected JButton saveButton = new JButton();
    protected ImageIcon saveFileImage = new ImageIcon(ImageUtils.loadImage("saveFile.jpg"));

    protected GraphWindow() {
    }

    public GraphWindow(GraphWindowAPI api) {
        this.application = api;
        this.graphPanel = new GraphPanel(this);
        ArrayList<PlotCurveCharacterstics> plotCharacterstics = new ArrayList<PlotCurveCharacterstics>();
        ArrayList applicationPlottingPrefList = api.getPlottingFeatures();
        int size = applicationPlottingPrefList.size();
        for (int i = 0; i < size; ++i) {
            PlotCurveCharacterstics curvePlotPref = (PlotCurveCharacterstics)applicationPlottingPrefList.get(i);
            plotCharacterstics.add(new PlotCurveCharacterstics(curvePlotPref.getCurveName(), curvePlotPref.getCurveType(), curvePlotPref.getCurveColor(), curvePlotPref.getCurveWidth(), curvePlotPref.getNumContinuousCurvesWithSameCharacterstics()));
        }
        this.graphPanel.setCurvePlottingCharacterstic(plotCharacterstics);
        this.functionList = new ArrayList();
        ArrayList applicationCurveList = api.getCurveFunctionList();
        size = applicationCurveList.size();
        for (int i = 0; i < size; ++i) {
            this.functionList.add(applicationCurveList.get(i));
        }
        this.xAxisName = api.getXAxisLabel();
        this.yAxisName = api.getYAxisLabel();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++windowNumber;
        this.xLog = api.getXLog();
        this.yLog = api.getYLog();
        this.customAxis = api.isCustomAxis();
        if (this.customAxis) {
            this.buttonControlPanel.setAxisRange(api.getMinX(), api.getMaxX(), api.getMinY(), api.getMaxY());
        }
        if (this.xLog) {
            this.buttonControlPanel.setXLog(this.xLog);
        }
        if (this.yLog) {
            this.buttonControlPanel.setYLog(this.yLog);
        }
        if (!this.xLog && !this.yLog) {
            this.drawGraph();
        }
    }

    protected void jbInit() throws Exception {
        this.setSize(670, 700);
        this.getContentPane().setLayout(this.borderLayout1);
        this.fileMenu.setText("File");
        this.fileExitMenu.setText("Exit");
        this.fileSaveMenu.setText("Save");
        this.filePrintMenu.setText("Print");
        this.fileExitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphWindow.this.fileExitMenu_actionPerformed(e);
            }
        });
        this.fileSaveMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphWindow.this.fileSaveMenu_actionPerformed(e);
            }
        });
        this.filePrintMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphWindow.this.filePrintMenu_actionPerformed(e);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphWindow.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphWindow.this.printButton_actionPerformed(actionEvent);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphWindow.this.saveButton_actionPerformed(actionEvent);
            }
        });
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.fileSaveMenu);
        this.fileMenu.add(this.filePrintMenu);
        this.fileMenu.add(this.fileExitMenu);
        this.setJMenuBar(this.menuBar);
        this.closeButton.setIcon(this.closeFileImage);
        this.closeButton.setToolTipText("Close Window");
        Dimension d = this.closeButton.getSize();
        this.jToolBar.add(this.closeButton);
        this.printButton.setIcon(this.printFileImage);
        this.printButton.setToolTipText("Print Graph");
        this.printButton.setSize(d);
        this.jToolBar.add(this.printButton);
        this.saveButton.setIcon(this.saveFileImage);
        this.saveButton.setToolTipText("Save Graph as image");
        this.saveButton.setSize(d);
        this.jToolBar.add(this.saveButton);
        this.jToolBar.setFloatable(false);
        this.getContentPane().add((Component)this.jToolBar, "North");
        this.chartSplitPane.setOrientation(0);
        this.chartPane.setLayout(this.gridBagLayout1);
        this.buttonPanel.setLayout(this.flowLayout1);
        this.getContentPane().add((Component)this.chartSplitPane, "Center");
        this.chartSplitPane.add((Component)this.chartPane, "top");
        this.chartSplitPane.add((Component)this.buttonPanel, "bottom");
        this.chartSplitPane.setDividerLocation(580);
        this.buttonControlPanel = new ButtonControlPanel(this);
        this.buttonPanel.add((Component)this.buttonControlPanel, null);
        this.togglePlot();
        this.setTitle(TITLE + windowNumber);
    }

    protected void fileExitMenu_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    protected void fileSaveMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    protected void filePrintMenu_actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    protected void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    protected void printButton_actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    protected void saveButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    public void save() throws IOException {
        this.graphPanel.save();
    }

    public void print() {
        this.graphPanel.print(this);
    }

    public Range getX_AxisRange() {
        return this.graphPanel.getX_AxisRange();
    }

    public Range getY_AxisRange() {
        return this.graphPanel.getY_AxisRange();
    }

    public void setX_Log(boolean xLog) {
        this.xLog = xLog;
        this.drawGraph();
    }

    public void setY_Log(boolean yLog) {
        this.yLog = yLog;
        this.drawGraph();
    }

    public void setAxisRange(double xMin, double xMax, double yMin, double yMax) {
        this.minXValue = xMin;
        this.maxXValue = xMax;
        this.minYValue = yMin;
        this.maxYValue = yMax;
        this.customAxis = true;
        this.drawGraph();
    }

    public void setAutoRange() {
        this.customAxis = false;
        this.drawGraph();
    }

    protected void drawGraph() {
        this.graphPanel.drawGraphPanel(this.xAxisName, this.yAxisName, this.functionList, this.xLog, this.yLog, this.customAxis, this.plotTitle, this.buttonControlPanel);
        this.togglePlot();
    }

    public void plotGraphUsingPlotPreferences() {
        this.drawGraph();
    }

    public void togglePlot() {
        this.chartPane.removeAll();
        this.graphPanel.togglePlot(this.buttonControlPanel);
        this.chartPane.add((Component)this.graphPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.chartPane.validate();
        this.chartPane.repaint();
    }

    public double getMinX() {
        return this.minXValue;
    }

    public double getMaxX() {
        return this.maxXValue;
    }

    public double getMinY() {
        return this.minYValue;
    }

    public double getMaxY() {
        return this.maxYValue;
    }

    public ArrayList getPlottingFeatures() {
        return this.graphPanel.getCurvePlottingCharacterstic();
    }

    public String getXAxisLabel() {
        return this.xAxisName;
    }

    public String getYAxisLabel() {
        return this.yAxisName;
    }

    public String getPlotLabel() {
        return TITLE;
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxisName = xAxisLabel;
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.yAxisName = yAxisLabel;
    }

    public void setPlotLabel(String plotTitle) {
        this.plotTitle = plotTitle;
    }
}

