/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets.siteEffect;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.region.EvenlyGriddedRectangularGeographicRegion;
import org.opensha.exceptions.RegionConstraintException;

public final class BasinDepthClass {
    ArrayList locations;
    String basinDepthFile;

    public BasinDepthClass(double minLon, double maxLon, double minLat, double maxLat, double gridSpacing, String fileName) throws RegionConstraintException {
        this.prepareSitesInput(minLon, maxLon, minLat, maxLat, gridSpacing);
        this.basinDepthFile = fileName;
    }

    public BasinDepthClass(LocationList locList, String fileName) {
        int numLocations = locList.size();
        this.basinDepthFile = fileName;
        this.locations = new ArrayList();
        for (int i = 0; i < numLocations; ++i) {
            this.locations.add(locList.getLocationAt(i));
        }
    }

    private void prepareSitesInput(double minLon, double maxLon, double minLat, double maxLat, double gridSpacing) throws RegionConstraintException {
        this.locations = new ArrayList();
        EvenlyGriddedRectangularGeographicRegion region = new EvenlyGriddedRectangularGeographicRegion(minLat, maxLat, minLon, maxLon, gridSpacing);
        ListIterator it = region.getGridLocationsIterator();
        while (it.hasNext()) {
            this.locations.add(it.next());
        }
    }

    public ArrayList getBasinDepth() {
        double gridSpacingForBasinDepthInFile = 0.01001;
        try {
            FileReader input = new FileReader(this.basinDepthFile);
            BufferedReader iBuf = new BufferedReader(input);
            String str = iBuf.readLine();
            int size = this.locations.size();
            ArrayList<Double> bd = new ArrayList<Double>();
            for (int i = 0; i < size; ++i) {
                bd.add(new Double(Double.NaN));
            }
            double prevLat = Double.NaN;
            block3: for (int i = 0; i < size; ++i) {
                double lat = ((Location)this.locations.get(i)).getLatitude();
                double lon = ((Location)this.locations.get(i)).getLongitude();
                boolean latFlag = false;
                while (str != null) {
                    StringTokenizer st = new StringTokenizer(str);
                    double valLat = Double.parseDouble(st.nextToken());
                    double valLon = Double.parseDouble(st.nextToken());
                    if (valLat - lat > gridSpacingForBasinDepthInFile / 2.0) continue block3;
                    if (Math.abs(lat - valLat) <= gridSpacingForBasinDepthInFile / 2.0) {
                        latFlag = true;
                    }
                    if (Math.abs(lon - valLon) <= gridSpacingForBasinDepthInFile / 2.0 && latFlag) {
                        bd.set(i, new Double(st.nextToken()));
                        continue block3;
                    }
                    if (valLon - lon > gridSpacingForBasinDepthInFile / 2.0 && latFlag) continue block3;
                    str = iBuf.readLine();
                }
            }
            return bd;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

