/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets.siteEffect;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.region.EvenlyGriddedRectangularGeographicRegion;
import org.opensha.exceptions.RegionConstraintException;

public final class WillsSiteClass {
    ArrayList locations;
    String willsSiteClassFile;
    public static final double GRID_SPACING_FOR_VS30_IN_FILE = 0.0166;

    public WillsSiteClass(double minLon, double maxLon, double minLat, double maxLat, double gridSpacing, String fileName) throws RegionConstraintException {
        this.prepareSitesInput(minLon, maxLon, minLat, maxLat, gridSpacing);
        this.willsSiteClassFile = fileName;
    }

    public WillsSiteClass(LocationList locList, String fileName) {
        int numLocations = locList.size();
        this.willsSiteClassFile = fileName;
        this.locations = new ArrayList();
        for (int i = 0; i < numLocations; ++i) {
            this.locations.add(locList.getLocationAt(i));
        }
    }

    private void prepareSitesInput(double minLon, double maxLon, double minLat, double maxLat, double gridSpacing) throws RegionConstraintException {
        this.locations = new ArrayList();
        EvenlyGriddedRectangularGeographicRegion region = new EvenlyGriddedRectangularGeographicRegion(minLat, maxLat, minLon, maxLon, gridSpacing);
        ListIterator it = region.getGridLocationsIterator();
        while (it.hasNext()) {
            this.locations.add(it.next());
        }
    }

    public ArrayList getWillsSiteClass() {
        try {
            FileReader input = new FileReader(this.willsSiteClassFile);
            BufferedReader iBuf = new BufferedReader(input);
            String str = iBuf.readLine();
            int size = this.locations.size();
            ArrayList<String> vs30 = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                vs30.add("NA");
            }
            double prevLat = Double.NaN;
            block3: for (int i = 0; i < size; ++i) {
                double lat = ((Location)this.locations.get(i)).getLatitude();
                double lon = ((Location)this.locations.get(i)).getLongitude();
                boolean latFlag = false;
                while (str != null) {
                    StringTokenizer st = new StringTokenizer(str);
                    double valLat = Double.parseDouble(st.nextToken());
                    double valLon = Double.parseDouble(st.nextToken());
                    if (valLat - lat > 0.0083) continue block3;
                    if (Math.abs(lat - valLat) <= 0.0083) {
                        latFlag = true;
                    }
                    if (Math.abs(lon - valLon) <= 0.0083 && latFlag) {
                        vs30.set(i, st.nextToken());
                        continue block3;
                    }
                    if (valLon - lon > 0.0083 && latFlag) continue block3;
                    str = iBuf.readLine();
                }
            }
            return vs30;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

