/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.util.HashMap;
import org.opensha.data.NamedObjectAPI;
import org.opensha.data.Site;
import org.opensha.exceptions.InvalidRangeException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.DoubleDiscreteConstraint;
import org.opensha.param.DoubleDiscreteParameter;
import org.opensha.param.StringConstraint;
import org.opensha.param.StringParameter;
import org.opensha.param.WarningDoubleParameter;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeListener;
import org.opensha.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.AttenuationRelationshipAPI;
import org.opensha.sha.param.DistanceJBParameter;

public class Boore_2005_prelim_AttenRel
extends AttenuationRelationship
implements AttenuationRelationshipAPI,
NamedObjectAPI,
ParameterChangeListener {
    private static final String C = "Boore_2005_prelim_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "Boore2005";
    public static final String NAME = "Boore & Atkinson (2005 prelim)";
    double[] period = new double[]{-1.0, 0.0, 0.1, 0.2, 1.0, 3.0, -2.0};
    double[] e01 = new double[]{4.73642, -0.92027, -0.36995, 0.01688, -1.00316, -2.27419, -0.96409};
    double[] e02 = new double[]{0.46374, 0.28115, 0.06284, 0.19353, 0.70367, 0.78311, 0.29795};
    double[] e03 = new double[]{-0.1324, -0.21409, -0.24453, -0.26457, -0.25927, -0.46006, -0.20341};
    double[] e04 = new double[]{0.0, 0.0, 0.0, 0.0, 0.30832, 0.9588, 0.0};
    double[] mh = new double[]{8.5, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0};
    double[] c01 = new double[]{-0.7468, -0.5641, -0.5404, -0.6379, -0.7478, -0.7986, -0.55};
    double[] c02 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    double[] c03 = new double[]{-0.00622, -0.01151, -0.01359, -0.00967, -0.00322, -0.00196, -0.01151};
    double[] mref = new double[]{6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0};
    double[] rref = new double[]{5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0};
    double[] h = new double[]{4.4, 3.2, 3.4, 4.6, 4.0, 5.0, 3.0};
    double[] blin = new double[]{-0.6, -0.36, -0.25, -0.31, -0.7, -0.74, 0.0};
    double[] vref = new double[]{760.0, 760.0, 760.0, 760.0, 760.0, 760.0, 760.0};
    double[] b1 = new double[]{-0.5, -0.64, -0.6, -0.52, -0.44, -0.34, 0.0};
    double[] b2 = new double[]{-0.06, -0.14, -0.13, -0.19, 0.0, 0.0, 0.0};
    double[] v1 = new double[]{180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0};
    double[] v2 = new double[]{300.0, 300.0, 300.0, 300.0, 300.0, 300.0, 300.0};
    double[] pga_low = new double[]{0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06};
    double[] sig1 = new double[]{0.49, 0.49, 0.523, 0.523, 0.571, 0.562, -999.0};
    double[] sig2 = new double[]{0.26, 0.253, 0.311, 0.235, 0.311, 0.433, -999.0};
    private HashMap indexFromPerHashMap;
    private int iper;
    private double vs30;
    private double rjb;
    private double mag;
    private String stdDevType;
    private boolean parameterChange;
    protected static final Double MAG_WARN_MIN = new Double(4.5);
    protected static final Double MAG_WARN_MAX = new Double(8.5);
    protected static final Double DISTANCE_JB_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_JB_WARN_MAX = new Double(200.0);
    protected static final Double VS30_WARN_MIN = new Double(120.0);
    protected static final Double VS30_WARN_MAX = new Double(2000.0);
    private DistanceJBParameter distanceJBParam = null;
    private static final Double DISTANCE_JB_DEFAULT = new Double(0.0);
    private transient ParameterChangeWarningListener warningListener = null;

    public Boore_2005_prelim_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 1; i < this.period.length - 1; ++i) {
            this.indexFromPerHashMap.put(new Double(this.period[i]), new Integer(i));
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValue(site.getParameter("Vs30").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceJBParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Boore_2005_prelim_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        this.iper = this.im.getName().equalsIgnoreCase("PGV") ? 0 : (this.im.getName().equalsIgnoreCase("PGA") ? 1 : (Integer)this.indexFromPerHashMap.get(this.periodParam.getValue()));
        this.parameterChange = true;
        this.intensityMeasureChanged = false;
    }

    public double getMean() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        if (this.rjb > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.parameterChange) {
            double pga4nl = Math.exp(this.getMean(6, this.vs30, this.rjb, this.mag, 0.0));
            return this.getMean(this.iper, this.vs30, this.rjb, this.mag, pga4nl);
        }
        return 0.0;
    }

    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper, this.stdDevType);
    }

    public void setParamDefaults() {
        this.vs30Param.setValue(VS30_DEFAULT);
        this.magParam.setValue(MAG_DEFAULT);
        this.distanceJBParam.setValue(DISTANCE_JB_DEFAULT);
        this.saParam.setValue(SA_DEFAULT);
        this.periodParam.setValue(PERIOD_DEFAULT);
        this.dampingParam.setValue(DAMPING_DEFAULT);
        this.pgaParam.setValue(PGA_DEFAULT);
        this.pgvParam.setValue(PGV_DEFAULT);
        this.stdDevTypeParam.setValue("Total");
        this.vs30 = (Double)this.vs30Param.getValue();
        this.rjb = (Double)this.distanceJBParam.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceJBParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        super.initSiteParams();
        DoubleConstraint warn = new DoubleConstraint(VS30_WARN_MIN, VS30_WARN_MAX);
        warn.setNonEditable();
        this.vs30Param.setWarningConstraint(warn);
        this.vs30Param.addParameterChangeWarningListener(this.warningListener);
        this.vs30Param.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    protected void initEqkRuptureParams() {
        super.initEqkRuptureParams();
        DoubleConstraint warn = new DoubleConstraint(MAG_WARN_MIN, MAG_WARN_MAX);
        warn.setNonEditable();
        this.magParam.setWarningConstraint(warn);
        this.magParam.addParameterChangeWarningListener(this.warningListener);
        this.magParam.setNonEditable();
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter();
        this.distanceJBParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_JB_WARN_MIN, DISTANCE_JB_WARN_MAX);
        warn.setNonEditable();
        this.distanceJBParam.setWarningConstraint(warn);
        this.distanceJBParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        super.initSupportedIntensityMeasureParams();
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 1; i < this.period.length - 1; ++i) {
            periodConstraint.addDouble(new Double(this.period[i]));
        }
        periodConstraint.setNonEditable();
        this.periodParam = new DoubleDiscreteParameter("SA Period", periodConstraint, "sec", null);
        this.periodParam.setInfo("Oscillator Period for SA");
        this.periodParam.setNonEditable();
        DoubleConstraint pgvConstraint = new DoubleConstraint(PGV_MIN, PGV_MAX);
        pgvConstraint.setNonEditable();
        this.pgvParam = new WarningDoubleParameter("PGV", pgvConstraint, "cm/sec");
        this.pgvParam.setInfo("Peak Ground Velocity");
        DoubleConstraint warn = new DoubleConstraint(PGV_WARN_MIN, PGV_WARN_MAX);
        warn.setNonEditable();
        this.pgvParam.setWarningConstraint(warn);
        this.pgvParam.setNonEditable();
        this.dampingConstraint.setNonEditable();
        this.saParam.addIndependentParameter(this.dampingParam);
        this.saParam.addIndependentParameter(this.periodParam);
        this.saParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.pgvParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal");
        constraint.setNonEditable();
        this.componentParam = new StringParameter("Component", constraint, "Average Horizontal");
        this.componentParam.setInfo("Component of shaking");
        this.componentParam.setNonEditable();
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StringParameter("Std Dev Type", stdDevTypeConstraint, "Total");
        this.stdDevTypeParam.setInfo("Type of Standard Deviation");
        this.stdDevTypeParam.setNonEditable();
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int iper, double vs30, double rjb, double mag, double pga4nl) {
        double Fm = mag <= this.mh[iper] ? this.e01[iper] + this.e02[iper] * (mag - this.mh[iper]) + this.e03[iper] * Math.pow(mag - this.mh[iper], 2.0) : this.e01[iper] + this.e04[iper] * (mag - this.mh[iper]);
        double r = Math.sqrt(rjb * rjb + this.h[iper] * this.h[iper]);
        double Fd = this.c01[iper] * Math.log(r / this.rref[iper]) + this.c02[iper] * (mag - this.mref[iper]) * Math.log(r / this.rref[iper]) + this.c03[iper] * (r - this.rref[iper]);
        double bnl = 0.0;
        if (vs30 <= this.v1[iper]) {
            bnl = this.b1[iper];
        } else if (vs30 <= this.v2[iper] && vs30 > this.v1[iper]) {
            bnl = (this.b1[iper] - this.b2[iper]) * Math.log(vs30 / this.v2[iper]) / Math.log(this.v1[iper] / this.v2[iper]) + this.b2[iper];
        } else if (vs30 <= this.vref[iper] && vs30 > this.v2[iper]) {
            bnl = this.b2[iper] * Math.log(vs30 / this.vref[iper]) / Math.log(this.v2[iper] / this.vref[iper]);
        } else if (vs30 > this.vref[iper]) {
            bnl = 0.0;
        }
        double Fs = pga4nl <= 0.06 ? this.blin[iper] * Math.log(vs30 / this.vref[iper]) + bnl * Math.log(0.6) : this.blin[iper] * Math.log(vs30 / this.vref[iper]) + bnl * Math.log(pga4nl / 0.1);
        return Fm + Fd + Fs;
    }

    public double getStdDev(int iper, String stdDevType) {
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Intra-Event")) {
            return this.sig2[iper];
        }
        if (stdDevType.equals("Inter-Event")) {
            return this.sig1[iper];
        }
        return Math.sqrt(this.sig1[iper] * this.sig1[iper] + this.sig2[iper] * this.sig2[iper]);
    }

    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceJB")) {
            this.rjb = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("SA Period") && this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
    }

    public void resetParameterEventListeners() {
        this.distanceJBParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.periodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    protected void initParameterEventListeners() {
        this.distanceJBParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.periodParam.addParameterChangeListener(this);
    }
}

