/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.util.HashMap;
import org.opensha.data.NamedObjectAPI;
import org.opensha.data.Site;
import org.opensha.exceptions.InvalidRangeException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.BooleanParameter;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.DoubleDiscreteConstraint;
import org.opensha.param.DoubleDiscreteParameter;
import org.opensha.param.StringConstraint;
import org.opensha.param.StringParameter;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeListener;
import org.opensha.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.AttenuationRelationshipAPI;
import org.opensha.sha.param.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.param.DistanceRupParameter;
import org.opensha.sha.surface.EvenlyGriddedSurfaceAPI;

public class CB_2005_prelim_AttenRel
extends AttenuationRelationship
implements AttenuationRelationshipAPI,
NamedObjectAPI,
ParameterChangeListener {
    private static final String C = "CB_2005_prelim_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "CB2005";
    public static final String NAME = "Campbell & Bozorgnia (2005 prelim)";
    private static double[] per = new double[]{0.0, 0.2, 1.0};
    private static double[] c0_EPRI = new double[]{1.387, -0.394, -3.117};
    private static double[] c0_PEN = new double[]{1.481, -0.112, -3.109};
    private static double[] c1_EPRI = new double[]{-0.019, 0.461, 0.553};
    private static double[] c1_PEN = new double[]{-0.052, 0.4, 0.55};
    private static double[] c2_EPRI = new double[]{-0.439, -0.65, -0.622};
    private static double[] c2_PEN = new double[]{-0.378, -0.575, -0.586};
    private static double[] c2prime_EPRI = new double[]{-0.385, -0.65, -0.622};
    private static double[] c2prime_PEN = new double[]{-0.353, -0.575, -0.586};
    private static double[] c3_EPRI = new double[]{-2.57, -2.05, -2.246};
    private static double[] c3_PEN = new double[]{-2.48, -1.914, -2.199};
    private static double[] c4_EPRI = new double[]{0.224, 0.123, 0.212};
    private static double[] c4_PEN = new double[]{0.218, 0.117, 0.207};
    private static double[] c5_EPRI = new double[]{6.07, 8.57, 3.17};
    private static double[] c5_PEN = new double[]{6.41, 9.48, 3.21};
    private static double[] c6_EPRI = new double[]{0.419, 0.368, 0.355};
    private static double[] c6_PEN = new double[]{0.409, 0.333, 0.359};
    private static double[] c7_EPRI = new double[]{-0.107, -0.035, -0.15};
    private static double[] c7_PEN = new double[]{-0.088, -0.007, -0.142};
    private static double[] c8_EPRI = new double[]{0.742, 0.798, 0.828};
    private static double[] c8_PEN = new double[]{0.687, 0.668, 0.825};
    private static double[] c9_EPRI = new double[]{0.988, 1.305, 1.429};
    private static double[] c9_PEN = new double[]{1.034, 2.155, 1.579};
    private static double[] c10_EPRI = new double[]{0.046, 0.071, 0.146};
    private static double[] c10_PEN = new double[]{0.029, 0.047, 0.137};
    private static double[] k1_EPRI = new double[]{1035.0, 1229.0, 444.0};
    private static double[] k1_PEN = new double[]{865.0, 748.0, 401.0};
    private static double[] k2_EPRI = new double[]{-1.14, -1.479, -1.7};
    private static double[] k2_PEN = new double[]{-1.186, -2.188, -1.955};
    private static double[] k3_EPRI = new double[]{1.346, 1.312, 1.179};
    private static double[] k3_PEN = new double[]{1.346, 1.312, 1.179};
    private static double[] k4_EPRI = new double[]{1.838, 1.856, 1.929};
    private static double[] k4_PEN = new double[]{1.838, 1.856, 1.929};
    private static double[] sigma_EPRI = new double[]{0.475, 0.524, 0.568};
    private static double[] sigma_PEN = new double[]{0.473, 0.522, 0.568};
    private static double[] tau_EPRI = new double[]{0.269, 0.341, 0.353};
    private static double[] tau_PEN = new double[]{0.25, 0.31, 0.352};
    private static double[] sigma_ln_EPRI = new double[]{0.546, 0.625, 0.669};
    private static double[] sigma_ln_PEN = new double[]{0.535, 0.607, 0.668};
    private HashMap indexFromPerHashMap;
    private int iper;
    private double vs30;
    private double rjb;
    private double rRup;
    private double distRupJB_Fraction;
    private double rake;
    private double mag;
    private double depthTop;
    private double depthTo2pt5kmPerSec;
    private String stdDevType;
    private String nonLinearAmpModel;
    private boolean magSaturation;
    private boolean parameterChange;
    protected static final Double MAG_WARN_MIN = new Double(4.5);
    protected static final Double MAG_WARN_MAX = new Double(8.5);
    protected static final Double DISTANCE_RUP_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_RUP_WARN_MAX = new Double(200.0);
    protected static final Double VS30_WARN_MIN = new Double(120.0);
    protected static final Double VS30_WARN_MAX = new Double(2000.0);
    protected static final Double DEPTH_2pt5_WARN_MIN = new Double(0.0);
    protected static final Double DEPTH_2pt5_WARN_MAX = new Double(7000.0);
    protected StringParameter nonLinearAmpModelParam = null;
    public static final String NONLIN_MODEL_TYPE_NAME = "Nonlinear Model";
    public static final String NONLIN_MODEL_TYPE_INFO = "Type of nonlinear amplification model";
    public static final String NONLIN_MODEL_TYPE_PEN = "PEN";
    public static final String NONLIN_MODEL_TYPE_EPRI = "EPRI";
    public static final String NONLIN_MODEL_TYPE_DEFAULT = "PEN";
    protected BooleanParameter magSaturationParam = null;
    public static final String MAG_SATURATION_NAME = "Mag Saturation";
    public static final String MAG_SATURATION_INFO = "Applies the magnitude-saturation option (c-prime rather than c coeff)";
    public static final Boolean MAG_SATURATION_DEFAULT = new Boolean(false);
    private DistanceRupParameter distanceRupParam = null;
    private static final Double DISTANCE_RUP_DEFAULT = new Double(0.0);
    private DistRupMinusJB_OverRupParameter distRupMinusJB_OverRupParam = null;
    private static final Double DISTANCE_RUP_MINUS_JB_DEFAULT = new Double(0.0);
    private transient ParameterChangeWarningListener warningListener = null;

    public CB_2005_prelim_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 0; i < per.length; ++i) {
            this.indexFromPerHashMap.put(new Double(per[i]), new Integer(i));
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        this.rakeParam.setValue(eqkRupture.getAveRake());
        EvenlyGriddedSurfaceAPI surface = eqkRupture.getRuptureSurface();
        double depth = surface.getLocation(0, 0).getDepth();
        this.rupTopDepthParam.setValue(depth);
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValue(site.getParameter("Vs30").getValue());
        this.depthTo2pt5kmPerSecParam.setValueIgnoreWarning(site.getParameter("Depth 2.5 km/sec").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
            this.distRupMinusJB_OverRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("CB_2005_prelim_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        this.iper = this.im.getName().equalsIgnoreCase("SA") ? (Integer)this.indexFromPerHashMap.get(this.periodParam.getValue()) : 0;
        this.parameterChange = true;
        this.intensityMeasureChanged = false;
    }

    public double getMean() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (Double.isNaN(this.depthTo2pt5kmPerSec)) {
            this.depthTo2pt5kmPerSec = this.vs30 <= 2500.0 ? 1.0 : 0.0;
        }
        if (this.nonLinearAmpModel.equals(NONLIN_MODEL_TYPE_EPRI)) {
            double pgar = Math.exp(this.getMean_EPRI(0, 1100.0, this.rRup, this.distRupJB_Fraction, this.rake, this.mag, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, 0.0));
            return this.getMean_EPRI(this.iper, this.vs30, this.rRup, this.distRupJB_Fraction, this.rake, this.mag, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, pgar);
        }
        double pgar = Math.exp(this.getMean_PEN(0, 1100.0, this.rRup, this.distRupJB_Fraction, this.rake, this.mag, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, 0.0));
        return this.getMean_PEN(this.iper, this.vs30, this.rRup, this.distRupJB_Fraction, this.rake, this.mag, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, pgar);
    }

    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        if (this.nonLinearAmpModel.equals(NONLIN_MODEL_TYPE_EPRI)) {
            return this.getStdDev_EPRI(this.iper, this.stdDevType);
        }
        return this.getStdDev_PEN(this.iper, this.stdDevType);
    }

    public void setParamDefaults() {
        this.vs30Param.setValue(VS30_DEFAULT);
        this.magParam.setValue(MAG_DEFAULT);
        this.rakeParam.setValue(RAKE_DEFAULT);
        this.nonLinearAmpModelParam.setValue("PEN");
        this.rupTopDepthParam.setValue(RUP_TOP_DEFAULT);
        this.distanceRupParam.setValue(DISTANCE_RUP_DEFAULT);
        this.distRupMinusJB_OverRupParam.setValue(DISTANCE_RUP_MINUS_JB_DEFAULT);
        this.saParam.setValue(SA_DEFAULT);
        this.periodParam.setValue(PERIOD_DEFAULT);
        this.dampingParam.setValue(DAMPING_DEFAULT);
        this.pgaParam.setValue(PGA_DEFAULT);
        this.componentParam.setValue("Average Horizontal");
        this.stdDevTypeParam.setValue("Total");
        this.magSaturationParam.setValue(MAG_SATURATION_DEFAULT);
        this.depthTo2pt5kmPerSecParam.setValue(DEPTH_2pt5_DEFAULT);
        this.vs30 = (Double)this.vs30Param.getValue();
        this.distRupJB_Fraction = (Double)this.distRupMinusJB_OverRupParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
        this.nonLinearAmpModel = (String)this.nonLinearAmpModelParam.getValue();
        this.rake = (Double)this.rakeParam.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.magSaturation = (Boolean)this.magSaturationParam.getValue();
        this.depthTop = (Double)this.rupTopDepthParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
        this.depthTo2pt5kmPerSec = (Double)this.depthTo2pt5kmPerSecParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.depthTo2pt5kmPerSecParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.rakeParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.meanIndependentParams.addParameter(this.magSaturationParam);
        this.meanIndependentParams.addParameter(this.nonLinearAmpModelParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.addParameter(this.nonLinearAmpModelParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        super.initSiteParams();
        DoubleConstraint warn = new DoubleConstraint(VS30_WARN_MIN, VS30_WARN_MAX);
        warn.setNonEditable();
        this.vs30Param.setWarningConstraint(warn);
        this.vs30Param.addParameterChangeWarningListener(this.warningListener);
        this.vs30Param.setNonEditable();
        DoubleConstraint warn2 = new DoubleConstraint(DEPTH_2pt5_WARN_MIN, DEPTH_2pt5_WARN_MAX);
        warn2.setNonEditable();
        this.depthTo2pt5kmPerSecParam.setWarningConstraint(warn2);
        this.depthTo2pt5kmPerSecParam.addParameterChangeWarningListener(this.warningListener);
        this.depthTo2pt5kmPerSecParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.depthTo2pt5kmPerSecParam);
    }

    protected void initEqkRuptureParams() {
        super.initEqkRuptureParams();
        DoubleConstraint warn = new DoubleConstraint(MAG_WARN_MIN, MAG_WARN_MAX);
        warn.setNonEditable();
        this.magParam.setWarningConstraint(warn);
        this.magParam.addParameterChangeWarningListener(this.warningListener);
        this.magParam.setNonEditable();
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.rakeParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
    }

    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter();
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.distRupMinusJB_OverRupParam = new DistRupMinusJB_OverRupParameter();
        this.distRupMinusJB_OverRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusJB_OverRupParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        super.initSupportedIntensityMeasureParams();
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < per.length; ++i) {
            periodConstraint.addDouble(new Double(per[i]));
        }
        periodConstraint.setNonEditable();
        this.periodParam = new DoubleDiscreteParameter("SA Period", periodConstraint, "sec", null);
        this.periodParam.setInfo("Oscillator Period for SA");
        this.periodParam.setNonEditable();
        this.dampingConstraint.setNonEditable();
        this.saParam.addIndependentParameter(this.dampingParam);
        this.saParam.addIndependentParameter(this.periodParam);
        this.saParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal");
        constraint.setNonEditable();
        this.componentParam = new StringParameter("Component", constraint, "Average Horizontal");
        this.componentParam.setInfo("Component of shaking");
        this.componentParam.setNonEditable();
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StringParameter("Std Dev Type", stdDevTypeConstraint, "Total");
        this.stdDevTypeParam.setInfo("Type of Standard Deviation");
        this.stdDevTypeParam.setNonEditable();
        StringConstraint nonLinConstr = new StringConstraint();
        nonLinConstr.addString("PEN");
        nonLinConstr.addString(NONLIN_MODEL_TYPE_EPRI);
        this.nonLinearAmpModelParam = new StringParameter(NONLIN_MODEL_TYPE_NAME, nonLinConstr, "PEN");
        this.nonLinearAmpModelParam.setInfo(NONLIN_MODEL_TYPE_INFO);
        this.nonLinearAmpModelParam.setNonEditable();
        this.magSaturationParam = new BooleanParameter(MAG_SATURATION_NAME, MAG_SATURATION_DEFAULT);
        this.magSaturationParam.setInfo(MAG_SATURATION_INFO);
        this.magSaturationParam.setNonEditable();
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
        this.otherParams.addParameter(this.nonLinearAmpModelParam);
        this.otherParams.addParameter(this.magSaturationParam);
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean_PEN(int iper, double vs30, double rRup, double distRupJB_Fraction, double rake, double mag, double depthTop, double depthTo2pt5kmPerSec, boolean magSaturation, double pgar) {
        double c = 1.88;
        double n = 1.18;
        double rjb = rRup - distRupJB_Fraction * rRup;
        double Frv = rake > 30.0 && rake < 150.0 ? 1.0 : 0.0;
        double Fn = rake < -30.0 && rake > -150.0 ? 1.0 : 0.0;
        double Ff = depthTop < 1.0 ? depthTop : 1.0;
        double F1 = mag <= 6.5 ? c0_PEN[iper] + c1_PEN[iper] * mag : (magSaturation ? c0_PEN[iper] + c1_PEN[iper] * mag + c2prime_PEN[iper] * (mag - 6.5) : c0_PEN[iper] + c1_PEN[iper] * mag + c2_PEN[iper] * (mag - 6.5));
        double F2 = (c3_PEN[iper] + c4_PEN[iper] * mag) * Math.log(Math.sqrt(rRup * rRup + c5_PEN[iper] * c5_PEN[iper]));
        double F3 = c6_PEN[iper] * Frv * Ff + c7_PEN[iper] * Fn;
        double FhwR = rjb == 0.0 ? 1.0 : distRupJB_Fraction;
        double FhwM = mag <= 6.0 ? 0.0 : (mag < 6.5 ? (mag - 6.0) / 0.5 : 1.0);
        double FhwH = depthTop >= 20.0 ? 0.0 : (20.0 - depthTop) / 20.0;
        double F4 = c8_PEN[iper] * Frv * FhwR * FhwM * FhwH;
        double F5 = vs30 < k1_PEN[iper] ? c9_PEN[iper] * Math.log(vs30 / k1_PEN[iper]) + k2_PEN[iper] * (Math.log(pgar + c * Math.pow(vs30 / k1_PEN[iper], n)) - Math.log(pgar + c)) : (c9_PEN[iper] + k2_PEN[iper] * n) * Math.log(vs30 / k1_PEN[iper]);
        double F6 = depthTo2pt5kmPerSec <= 1.0 ? c10_PEN[iper] * (depthTo2pt5kmPerSec - 1.0) : (depthTo2pt5kmPerSec <= 3.0 ? 0.0 : k3_PEN[iper] * (Math.exp(-10.0) - Math.exp(-3.333 * depthTo2pt5kmPerSec)) + k4_PEN[iper] * (Math.exp(-0.75) - Math.exp(-0.25 * depthTo2pt5kmPerSec)));
        return F1 + F2 + F3 + F4 + F5 + F6;
    }

    public double getMean_EPRI(int iper, double vs30, double rRup, double distRupJB_Fraction, double rake, double mag, double depthTop, double depthTo2pt5kmPerSec, boolean magSaturation, double pgar) {
        double c = 1.38;
        double n = 1.3;
        double rjb = rRup - distRupJB_Fraction * rRup;
        double Frv = rake > 30.0 && rake < 150.0 ? 1.0 : 0.0;
        double Fn = rake < -30.0 && rake > -150.0 ? 1.0 : 0.0;
        double Ff = depthTop < 1.0 ? depthTop : 1.0;
        double F1 = mag <= 6.5 ? c0_EPRI[iper] + c1_EPRI[iper] * mag : (magSaturation ? c0_EPRI[iper] + c1_EPRI[iper] * mag + c2prime_EPRI[iper] * (mag - 6.5) : c0_EPRI[iper] + c1_EPRI[iper] * mag + c2_EPRI[iper] * (mag - 6.5));
        double F2 = (c3_EPRI[iper] + c4_EPRI[iper] * mag) * Math.log(Math.sqrt(rRup * rRup + c5_EPRI[iper] * c5_EPRI[iper]));
        double F3 = c6_EPRI[iper] * Frv * Ff + c7_EPRI[iper] * Fn;
        double FhwR = rjb == 0.0 ? 1.0 : distRupJB_Fraction;
        double FhwM = mag <= 6.0 ? 0.0 : (mag < 6.5 ? (mag - 6.0) / 0.5 : 1.0);
        double FhwH = depthTop >= 20.0 ? 0.0 : (20.0 - depthTop) / 20.0;
        double F4 = c8_EPRI[iper] * Frv * FhwR * FhwM * FhwH;
        double F5 = vs30 < k1_EPRI[iper] ? c9_EPRI[iper] * Math.log(vs30 / k1_EPRI[iper]) + k2_EPRI[iper] * (Math.log(pgar + c * Math.pow(vs30 / k1_EPRI[iper], n)) - Math.log(pgar + c)) : (c9_EPRI[iper] + k2_EPRI[iper] * n) * Math.log(vs30 / k1_EPRI[iper]);
        double F6 = depthTo2pt5kmPerSec <= 1.0 ? c10_EPRI[iper] * (depthTo2pt5kmPerSec - 1.0) : (depthTo2pt5kmPerSec <= 3.0 ? 0.0 : k3_EPRI[iper] * (Math.exp(-10.0) - Math.exp(-3.333 * depthTo2pt5kmPerSec)) + k4_EPRI[iper] * (Math.exp(-0.75) - Math.exp(-0.25 * depthTo2pt5kmPerSec)));
        return F1 + F2 + F3 + F4 + F5 + F6;
    }

    public double getStdDev_EPRI(int iper, String stdDevType) {
        double s = sigma_EPRI[iper];
        double t = tau_EPRI[iper];
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Intra-Event")) {
            return t;
        }
        if (stdDevType.equals("Inter-Event")) {
            return s;
        }
        return Math.sqrt(t * t + s * s);
    }

    public double getStdDev_PEN(int iper, String stdDevType) {
        double s = sigma_PEN[iper];
        double t = tau_PEN[iper];
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Intra-Event")) {
            return t;
        }
        if (stdDevType.equals("Inter-Event")) {
            return s;
        }
        return Math.sqrt(t * t + s * s);
    }

    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("(distRup-distJB)/distRup")) {
            this.distRupJB_Fraction = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Depth 2.5 km/sec")) {
            this.depthTo2pt5kmPerSec = val == null ? Double.NaN : (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Rake")) {
            this.rake = (Double)val;
        } else if (pName.equals(NONLIN_MODEL_TYPE_NAME)) {
            this.nonLinearAmpModel = (String)val;
        } else if (pName.equals(MAG_SATURATION_NAME)) {
            this.magSaturation = (Boolean)val;
        } else if (pName.equals("Rupture Top Depth")) {
            this.depthTop = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("SA Period") && this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
    }

    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.depthTo2pt5kmPerSecParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.rakeParam.removeParameterChangeListener(this);
        this.nonLinearAmpModelParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.magSaturationParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.periodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.depthTo2pt5kmPerSecParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.rakeParam.addParameterChangeListener(this);
        this.nonLinearAmpModelParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.magSaturationParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.periodParam.addParameterChangeListener(this);
    }
}

