/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import org.opensha.calc.MomentMagCalc;
import org.opensha.exceptions.DataPoint2DException;
import org.opensha.exceptions.DiscretizedFuncException;
import org.opensha.exceptions.InvalidRangeException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class SingleMagFreqDist
extends IncrementalMagFreqDist {
    public static String NAME = "Single-Mag Dist";
    private double mag;
    private double rate;

    public SingleMagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
    }

    public SingleMagFreqDist(double min, double max, int num) throws DiscretizedFuncException, InvalidRangeException {
        super(min, max, num);
    }

    public SingleMagFreqDist(double min, int num, double delta, double mag, double moRate) throws InvalidRangeException, DataPoint2DException {
        super(min, num, delta);
        this.rate = moRate / MomentMagCalc.getMoment(mag);
        this.setMagAndRate(mag, this.rate);
    }

    public double getRate() {
        return this.rate;
    }

    public double getMag() {
        return this.mag;
    }

    public void setMagAndRate(double mag, double rate) throws DataPoint2DException {
        this.mag = mag;
        this.rate = rate;
        for (int i = 0; i < this.num; ++i) {
            this.set(i, 0.0);
        }
        this.set(mag, rate);
    }

    public void setMagAndMomentRate(double mag, double moRate) throws DataPoint2DException {
        this.rate = moRate / MomentMagCalc.getMoment(mag);
        this.setMagAndRate(mag, this.rate);
    }

    public void setRateAndMomentRate(double rate, double moRate, boolean relaxTotMoRate) throws DataPoint2DException {
        this.mag = MomentMagCalc.getMag(moRate / rate);
        int index = (int)Math.rint((this.mag - this.minX) / this.delta);
        if (relaxTotMoRate) {
            this.setMagAndRate(this.getX(index), rate);
        } else {
            this.setMagAndMomentRate(this.getX(index), moRate);
        }
    }

    public String getDefaultName() {
        return NAME;
    }

    public String getDefaultInfo() {
        double totMoRate = this.rate * MomentMagCalc.getMoment(this.mag);
        return "minMag=" + this.minX + "; maxMag=" + this.maxX + "; numMag=" + this.num + "; mag=" + (float)this.mag + "; rate=" + (float)this.rate + "; totMoRate=" + (float)totMoRate;
    }
}

